
#TVGN_PARENT = $3


Procedure.l EVButtonChangeDir() ; Returns #True if changed
  Protected Win.l, Ende.l, Event.l, EventWindow.l, GadEx.l, GadBAb.l, GadBOK.l, EventGadget.l
  
  GUIDisableGadgets(#True)
  Win.l = OpenWindow(#PB_Any, 10, 10, 250, 340, GLOB\PRW\CHDIRTitle, #PB_Window_WindowCentered|#PB_Window_SystemMenu, WindowID(GLOB\GUI\MainWindow))
  
  CreateGadgetList(WindowID(Win))
  GadEx  = ExplorerTreeGadget(#PB_Any, 10, 10, 230, 280, GLOB\MN\ProjectsDir, #PB_Explorer_AlwaysShowSelection|#PB_Explorer_NoFiles|#PB_Explorer_NoDriveRequester)
  GadBAb = ButtonGadget(#PB_Any, 20, 300, 60, 30, "Cancel")
  GadBOK = ButtonGadget(#PB_Any, 90, 300, 60, 30, "OK")
  
  Repeat
    
    Event = WaitWindowEvent()
    EventWindow = EventWindow()
    If EventWindow = Win
      
      Select Event
        Case #PB_Event_Gadget
          EventGadget = EventGadget()
          
          Select EventGadget
            Case GadBAb
              Ende = 1
              
            Case GadBOK
              GLOB\MN\ProjectsDir = GetGadgetText(GadEx)
              Ende = 2
          EndSelect
          
        Case #PB_Event_CloseWindow
          Ende = 1
          
      EndSelect
    EndIf
    
  Until Ende
  
  CloseWindow(Win)
  GUIDisableGadgets(#False)
  
  If Ende = 1
    ProcedureReturn #False
  ElseIf Ende = 2
    ProcedureReturn #True
  EndIf
EndProcedure

Procedure.l EVButtonSetPrefs() ; Returns #True if changed
  Protected GadPF.l, GadPP.f, GadTP1.l, GadBOK.l, GadBAb.l, GadF1.l
  Protected GadPFE.l, GadTP2.l
  ;Protected GadF2.l, GadTR1.l, GadSR.l
  Protected Win.l, Ende.l, Event.l, EventWindow.l, EventGadget.l
  
  Protected WinX.l, WinY.l
  WinX = 270 ;540
  WinY = 330
  
  GUIDisableGadgets(#True)
  Win.l = OpenWindow(#PB_Any, 10, 10, WinX, WinY, GLOB\PRW\PRFWinTitle, #PB_Window_WindowCentered|#PB_Window_SystemMenu, WindowID(GLOB\GUI\MainWindow))
  CreateGadgetList(WindowID(Win))
  
  GadF1  = Frame3DGadget(#PB_Any, 5, 0, 260, 280, GLOB\PRW\Fr3D)
  ;{
  
  GadTP1 = TextGadget(#PB_Any, 20, 20, 230, 110, GLOB\PRW\GadTP1)
  GadPP  = StringGadget(#PB_Any, 20, 130, 230, 20, GLOB\MN\DontShowPrjPattern)
  GadPF  = StringGadget(#PB_Any, 20, 160, 230, 20, GLOB\MN\DontShowFilePattern)
  
  GadTP2 = TextGadget(#PB_Any, 20, 190, 230, 60, GLOB\PRW\GadTP2)
  GadPFE = StringGadget(#PB_Any, 20, 250, 230, 20, GLOB\MN\FilePatterns)
  ;}
  
  ; GadF2  = Frame3DGadget(#PB_Any, 275, 0, 260, 150, "Other")
  ; ;{
  ; s = "Path to PB-IDE/jaPBe:"
  ; GadTR1 = TextGadget(#PB_Any, 285, 20, 230, 20, s)
  ; GadSR  = StringGadget(#PB_Any, 285, 50, 190, 20, GLOB\MN\IDEPath)
  ; ;}
  
  GadBAb = ButtonGadget(#PB_Any, 10, 290, 60, 30, "Cancel")
  GadBOK = ButtonGadget(#PB_Any, 80, 290, 60, 30, "OK")
  
  Repeat
    
    Event = WaitWindowEvent()
    EventWindow = EventWindow()
    If EventWindow = Win
      
      Select Event
        Case #PB_Event_Gadget
          EventGadget = EventGadget()
          
          Select EventGadget
            Case GadBAb
              Ende = 1
              
            Case GadBOK
              GLOB\MN\DontShowPrjPattern  = GetGadgetText(GadPP)
              GLOB\MN\DontShowFilePattern = GetGadgetText(GadPF)
              GLOB\MN\FilePatterns        = GetGadgetText(GadPFE)
              Ende = 2
          EndSelect
          
        Case #PB_Event_CloseWindow
          Ende = 1
          
      EndSelect
    EndIf
    
  Until Ende
  
  
  CloseWindow(Win)
  GUIDisableGadgets(#False)
  
  If Ende = 1
    ProcedureReturn #False
  ElseIf Ende = 2
    ProcedureReturn #True
  EndIf
EndProcedure

Procedure.l EVTreeGetParent(ItemNr.l)
  ProcedureReturn Tree_GetParent(GLOB\GUI\GTree\id, ItemNr)
EndProcedure

Procedure EVButtonRun()
  Protected ProjectName.s
  
  ProjectName = GetGadgetItemText(GLOB\GUI\GTree\id, EVTreeGetParent(EVTreeGetParent(GetGadgetState(GLOB\GUI\GTree\id))), 0)
  ;RunProgram(GLOB\MN\ProjectsDir + ProjectName + "\" + GetGadgetItemText(GLOB\GUI\GTree\id, GetGadgetState(GLOB\GUI\GTree\id), 0)) 
  ShellExecute_(0,0,GLOB\MN\ProjectsDir + ProjectName + "\" + GetGadgetItemText(GLOB\GUI\GTree\id, GetGadgetState(GLOB\GUI\GTree\id), 0),0,0,#SW_SHOW)
EndProcedure

Procedure.s EVInputRequester(Title.s, Text.s, Input.s)
  Protected Win.l, Ende.l, Event.l, EventWindow.l, s.s
  Protected GadT.l, GadS.l, GadBAb.l, GadBOK.l, EventGadget.l
  
  GUIDisableGadgets(#True)
  Win.l = OpenWindow(#PB_Any, 10, 10, 250, 180, Title, #PB_Window_WindowCentered|#PB_Window_SystemMenu, WindowID(GLOB\GUI\MainWindow))
  
  CreateGadgetList(WindowID(Win))
  GadT   = TextGadget(#PB_Any, 10, 10, 230, 100, Text)
  GadS   = StringGadget(#PB_Any, 10, 110, 230, 20, Input)
  GadBAb = ButtonGadget(#PB_Any, 60, 140, 60, 30, "Cancel")
  GadBOK = ButtonGadget(#PB_Any, 130, 140, 60, 30, "OK")
  
  Repeat
    
    Event = WaitWindowEvent()
    EventWindow = EventWindow()
    If EventWindow = Win
      
      Select Event
        Case #PB_Event_Gadget
          EventGadget = EventGadget()
          
          Select EventGadget
            Case GadBAb
              Ende = 1
              
            Case GadBOK
              s = GetGadgetText(GadS)
              Ende = 2
          EndSelect
          
        Case #PB_Event_CloseWindow
          Ende = 1
          
      EndSelect
    EndIf
    
  Until Ende
  
  CloseWindow(Win)
  GUIDisableGadgets(#False)
  
  If Ende = 1
    ProcedureReturn ""
  ElseIf Ende = 2
    ProcedureReturn s
  EndIf
EndProcedure

Procedure EVOpenEditorFile()
  Protected FileID.l, Format.l
  
  GUIDisableGadgets(#True)
  ClearGadgetItemList(GLOB\GUI\GEditor\id)
  
  FileID = OpenFile(#PB_Any, GLOB\MN\FileName)
  Format = ReadStringFormat(FileID)
  If IsFile(FileID)
    While Eof(FileID) = #False
      AddGadgetItem(GLOB\GUI\GEditor\id, -1, ReadString(FileID, Format))
      While WindowEvent() : Wend
    Wend
    
    CloseFile(FileID)
  EndIf
  GUIDisableGadgets(#False)
  
EndProcedure

Procedure EVTreeDoubleClick() ; Opens File in Editorgadget
  Protected FileName.s, ProjectName.s
  
  ProjectName = GetGadgetItemText(GLOB\GUI\GTree\ID, EVTreeGetParent(EVTreeGetParent(GetGadgetState(GLOB\GUI\GTree\ID))), 0)
  FileName    = GLOB\MN\ProjectsDir + ProjectName + "\" + GetGadgetItemText(GLOB\GUI\GTree\ID, GetGadgetState(GLOB\GUI\GTree\ID), 0)
  
  GLOB\MN\FileName = FileName
  
  EVOpenEditorFile()
  
EndProcedure

Procedure EVButtonNew()
  Protected FileName.s, ItemNr.l, ProjectName.s
  
  FileName = EVInputRequester(GLOB\PRW\NewInputTitle, GLOB\PRW\NewInputText, "NewFile.txt")
  
  If FileName <> ""
    ItemNr = EVTreeGetParent(EVTreeGetParent(GetGadgetState(GLOB\GUI\GTree\ID)))
    If ItemNr = -1
      ItemNr = EVTreeGetParent(GetGadgetState(GLOB\GUI\GTree\ID))
      If ItemNr = -1
        ItemNr = GetGadgetState(GLOB\GUI\GTree\ID)
        
        If ItemNr = -1
          ProcedureReturn #False
        EndIf
      EndIf
    EndIf
    
    ProjectName = GetGadgetItemText(GLOB\GUI\GTree\ID, ItemNr, 0)
    FileName    = GLOB\MN\ProjectsDir + ProjectName + "\" + FileName
    GLOB\MN\FileName = FileName
    CreateFile(0, FileName)
    
    CloseFile(0)
    ProcedureReturn #True
  EndIf
  
  ProcedureReturn #False
EndProcedure

Procedure EVButtonDelete()
  Protected FileName.s, ItemNr.l, ProjectName.s
  
  ProjectName = GetGadgetItemText(GLOB\GUI\GTree\ID, EVTreeGetParent(EVTreeGetParent(GetGadgetState(GLOB\GUI\GTree\ID))), 0)
  FileName    = GLOB\MN\ProjectsDir + ProjectName + "\" + GetGadgetItemText(GLOB\GUI\GTree\ID, GetGadgetState(GLOB\GUI\GTree\ID), 0)
  
  If GetExtensionPart(FileName) <> "" And FindString(FileName, "\\", 1) = 0 And MessageRequester(GLOB\PRW\DeleteMsgTitle, GLOB\PRW\DeleteMsgText + #CRLF$ + FileName, #PB_MessageRequester_YesNo) = 6
    ; Ja
    DeleteFile(FileName)
    ProcedureReturn #True
  Else
    ProcedureReturn #False
  EndIf
  
EndProcedure

Procedure EVButtonSave()
  
  If FileSize(GLOB\MN\FileName) <> -1
    If MessageRequester(GLOB\PRW\SaveMsgTitle, GLOB\PRW\SaveMsgText + #CRLF$ + GLOB\MN\FileName, #PB_MessageRequester_YesNo) = 7
      ProcedureReturn #False
    EndIf
  EndIf
  
  If CreateFile(0, GLOB\MN\FileName)
    WriteString(0, GetGadgetText(GLOB\GUI\GEditor\id))
    CloseFile(0)
  EndIf
  
EndProcedure


Procedure EVButtonOpenDir()
  Protected ProjectName.s, ItemNr.l
  
  ItemNr = EVTreeGetParent(EVTreeGetParent(GetGadgetState(GLOB\GUI\GTree\ID)))
  If ItemNr = -1
    ItemNr = EVTreeGetParent(GetGadgetState(GLOB\GUI\GTree\ID))
    If ItemNr = -1
      ItemNr = GetGadgetState(GLOB\GUI\GTree\ID)
      
      If ItemNr = -1
        ProcedureReturn #False
      EndIf
    EndIf
  EndIf
  
  ProjectName = GetGadgetItemText(GLOB\GUI\GTree\ID, ItemNr, 0)
  RunProgram(GLOB\MN\ProjectsDir + ProjectName) 
EndProcedure


Declare MNUpdate()
Declare MNSearchFor(String.s)
Procedure EVEvents()
  Event = WaitWindowEvent()
  Select Event
    Case #PB_Event_CloseWindow
      ProcedureReturn #True
      
    Case #PB_Event_SizeWindow
      GUIUpdateWindowDatas()
      GUIResize()
      
    Case #PB_Event_Gadget
      EventGadget = EventGadget()
      EventType   = EventType()
      Select EventGadget
        Case GLOB\GUI\GBChangeDir\id
          If EVButtonChangeDir()
            GUIChangeWindowTitle("Project-Manager - " + GLOB\MN\ProjectsDir)
            MNUpdate()
          EndIf
          
        Case GLOB\GUI\GBUpdate\id
          MNUpdate()
          
        Case GLOB\GUI\GBSetPrefs\id
          If EVButtonSetPrefs()
            MNUpdate()
          EndIf
          
        Case GLOB\GUI\GBOpenDir\id
          EVButtonOpenDir()
          
        Case GLOB\GUI\GBRun\id
          EVButtonRun()
          
        Case GLOB\GUI\GBNew\id
          If EVButtonNew()
            MNUpdate()
          EndIf
          
        Case GLOB\GUI\GBDelete\id
          If EVButtonDelete()
            MNUpdate()
          EndIf
          
        Case GLOB\GUI\GBSave\id
          EVButtonSave()
          
        Case GLOB\GUI\GTree\id
          If EventType = #PB_EventType_LeftDoubleClick
            EVTreeDoubleClick()
          EndIf
          
        Case GLOB\GUI\GCShowOnlyWF\id
          GLOB\MN\ShowOnlyWithFiles = GetGadgetState(GLOB\GUI\GCShowOnlyWF\id)
          MNUpdate()
          
        Case GLOB\GUI\GCWithSubDirs\id
          GLOB\MN\ShowSubDirs = GetGadgetState(GLOB\GUI\GCWithSubDirs\id)
          MNUpdate()
          
        Case GLOB\GUI\GCUsePattern\id
          GLOB\MN\UsePatterns = GetGadgetState(GLOB\GUI\GCUsePattern\id)
          MNUpdate()
          
        Case GLOB\GUI\GSSearchFor\id
          If EventType = #PB_EventType_Change
            MNSearchFor(GetGadgetText(GLOB\GUI\GSSearchFor\id))
          EndIf
          
      EndSelect
  EndSelect
EndProcedure




 
; jaPBe Version=3.6.8.556
; FoldLines=0043004B00D100DB00DD00F900FB0109011B012C
; Build=0
; CompileThis=Project-Manager.pb
; FirstLine=115
; CursorPosition=136
; ExecutableFormat=Windows
; DontSaveDeclare
; EOF