

Procedure GUIInit()
  Protected WWidth.l, WHeight.l
  
  WWidth  = GLOB\GUI\Width
  WHeight = GLOB\GUI\Height
  
  GLOB\GUI\GTree\x = 10
  GLOB\GUI\GTree\y = 100
  GLOB\GUI\GTree\Width  = 170
  GLOB\GUI\GTree\Height = WHeight - 110
  GLOB\GUI\GTree\flags  = #PB_Tree_AlwaysShowSelection
  
  GLOB\GUI\GBChangeDir\x      = 10
  GLOB\GUI\GBChangeDir\y      = 10
  GLOB\GUI\GBChangeDir\Width  = 50
  GLOB\GUI\GBChangeDir\Height = 30
  
  GLOB\GUI\GBUpdate\x      = 70
  GLOB\GUI\GBUpdate\y      = 10
  GLOB\GUI\GBUpdate\Width  = 50
  GLOB\GUI\GBUpdate\Height = 30
  
  GLOB\GUI\GBSetPrefs\x      = 130
  GLOB\GUI\GBSetPrefs\y      = 10
  GLOB\GUI\GBSetPrefs\Width  = 50
  GLOB\GUI\GBSetPrefs\Height = 30
  
  GLOB\GUI\GBOpenDir\x      = 190
  GLOB\GUI\GBOpenDir\y      = 10
  GLOB\GUI\GBOpenDir\Width  = 50
  GLOB\GUI\GBOpenDir\Height = 30
  
  GLOB\GUI\GBRun\x      = 250
  GLOB\GUI\GBRun\y      = 10
  GLOB\GUI\GBRun\Width  = 50
  GLOB\GUI\GBRun\Height = 30
  
  
  GLOB\GUI\GBNew\x      = 250
  GLOB\GUI\GBNew\Y      = 50
  GLOB\GUI\GBNew\Width  = 50
  GLOB\GUI\GBNew\Height = 30
  
  GLOB\GUI\GBDelete\X      = 310
  GLOB\GUI\GBDelete\Y      = 50
  GLOB\GUI\GBDelete\Width  = 50
  GLOB\GUI\GBDelete\Height = 30
  
  GLOB\GUI\GBSave\X      = 370
  GLOB\GUI\GBSave\Y      = 50
  GLOB\GUI\GBSave\Width  = 50
  GLOB\GUI\GBSave\Height = 30
  
  
  GLOB\GUI\GCShowOnlyWF\X      = 10
  GLOB\GUI\GCShowOnlyWF\Y      = 50
  GLOB\GUI\GCShowOnlyWF\Width  = 110
  GLOB\GUI\GCShowOnlyWF\Height = 20
  
  GLOB\GUI\GCUsePattern\X      = 130
  GLOB\GUI\GCUsePattern\Y      = 50
  GLOB\GUI\GCUsePattern\Width  = 80
  GLOB\GUI\GCUsePattern\Height = 20
  
  GLOB\GUI\GCWithSubDirs\x      = 10
  GLOB\GUI\GCWithSubDirs\y      = 75
  GLOB\GUI\GCWithSubDirs\Width  = 110
  GLOB\GUI\GCWithSubDirs\Height = 20
  
  GLOB\GUI\GSSearchFor\x      = WWidth - 110
  GLOB\GUI\GSSearchFor\y      = 10
  GLOB\GUI\GSSearchFor\Width  = 100
  GLOB\GUI\GSSearchFor\Height = 20
  
  GLOB\GUI\GEditor\x      = 190
  GLOB\GUI\GEditor\y      = 100
  GLOB\GUI\GEditor\Width  = WWidth - 160 - 40
  GLOB\GUI\GEditor\Height = WHeight - 110
EndProcedure

Procedure GUIDisableGadgets(state.l)
  DisableGadget(GLOB\GUI\GCShowOnlyWF\id, state)
  DisableGadget(GLOB\GUI\GCUsePattern\id, state)
  DisableGadget(GLOB\GUI\GCWithSubDirs\id, state)
  DisableGadget(GLOB\GUI\GBChangeDir\id, state)
  DisableGadget(GLOB\GUI\GBDelete\id, state)
  DisableGadget(GLOB\GUI\GBNew\id, state)
  DisableGadget(GLOB\GUI\GBOpenDir\id, state)
  DisableGadget(GLOB\GUI\GBRun\id, state)
  DisableGadget(GLOB\GUI\GBSave\id, state)
  DisableGadget(GLOB\GUI\GBSetPrefs\id, state)
  DisableGadget(GLOB\GUI\GBUpdate\id, state)
  DisableGadget(GLOB\GUI\GSSearchFor\id, state)
EndProcedure

Procedure GUICreateMainWindow()
  Protected WndPl.WINDOWPLACEMENT, Splitter.l
  
  GLOB\GUI\MainWindow = OpenWindow(#PB_Any, GLOB\GUI\PosX,GLOB\GUI\PosY, GLOB\GUI\Width,GLOB\GUI\Height, GLOB\GUI\Title, GLOB\GUI\flags)
  CreateGadgetList(WindowID(GLOB\GUI\MainWindow))
  
  GLOB\GUI\GTree\id       = TreeGadget(#PB_Any, GLOB\GUI\GTree\x, GLOB\GUI\GTree\y, GLOB\GUI\GTree\Width, GLOB\GUI\GTree\Height)
  GLOB\GUI\GEditor\id     = EditorGadget(#PB_Any, GLOB\GUI\GEditor\x, GLOB\GUI\GEditor\y, GLOB\GUI\GEditor\Width, GLOB\GUI\GEditor\Height)
  Splitter = SplitterGadget(#PB_Any, GLOB\GUI\GTree\x, GLOB\GUI\GTree\y, (GLOB\GUI\GEditor\x + GLOB\GUI\GEditor\Width) - GLOB\GUI\GTree\x, GLOB\GUI\GTree\Height, GLOB\GUI\GTree\id, GLOB\GUI\GEditor\id, #PB_Splitter_Vertical|#PB_Splitter_Separator)
  SetGadgetState(Splitter, GLOB\GUI\GTree\Width + 3)
  
  GLOB\GUI\GBChangeDir\id = ButtonGadget(#PB_Any, GLOB\GUI\GBChangeDir\x, GLOB\GUI\GBChangeDir\y, GLOB\GUI\GBChangeDir\Width, GLOB\GUI\GBChangeDir\Height, GLOB\GUI\GBChangeDir\Text)
  GLOB\GUI\GBOpenDir\id   = ButtonGadget(#PB_Any, GLOB\GUI\GBOpenDir\x, GLOB\GUI\GBOpenDir\y, GLOB\GUI\GBOpenDir\Width, GLOB\GUI\GBOpenDir\Height, GLOB\GUI\GBOpenDir\Text)
  GLOB\GUI\GBUpdate\id    = ButtonGadget(#PB_Any, GLOB\GUI\GBUpdate\x, GLOB\GUI\GBUpdate\y, GLOB\GUI\GBUpdate\Width, GLOB\GUI\GBUpdate\Height, GLOB\GUI\GBUpdate\Text)
  GLOB\GUI\GBSetPrefs\id  = ButtonGadget(#PB_Any, GLOB\GUI\GBSetPrefs\x, GLOB\GUI\GBSetPrefs\y, GLOB\GUI\GBSetPrefs\Width, GLOB\GUI\GBSetPrefs\Height, GLOB\GUI\GBSetPrefs\Text)
  GLOB\GUI\GBRun\id       = ButtonGadget(#PB_Any, GLOB\GUI\GBRun\x, GLOB\GUI\GBRun\y, GLOB\GUI\GBRun\Width, GLOB\GUI\GBRun\Height, GLOB\GUI\GBRun\Text)
  
  GLOB\GUI\GBSave\id      = ButtonGadget(#PB_Any, GLOB\GUI\GBSave\x, GLOB\GUI\GBSave\y, GLOB\GUI\GBSave\Width, GLOB\GUI\GBSave\Height, GLOB\GUI\GBSave\Text)
  GLOB\GUI\GBDelete\id    = ButtonGadget(#PB_Any, GLOB\GUI\GBDelete\x, GLOB\GUI\GBDelete\y, GLOB\GUI\GBDelete\Width, GLOB\GUI\GBDelete\Height, GLOB\GUI\GBDelete\Text)
  GLOB\GUI\GBNew\id       = ButtonGadget(#PB_Any, GLOB\GUI\GBNew\x, GLOB\GUI\GBNew\y, GLOB\GUI\GBNew\Width, GLOB\GUI\GBNew\Height, GLOB\GUI\GBNew\Text)
  
  GLOB\GUI\GCShowOnlyWF\id = CheckBoxGadget(#PB_Any, GLOB\GUI\GCShowOnlyWF\x, GLOB\GUI\GCShowOnlyWF\y, GLOB\GUI\GCShowOnlyWF\Width, GLOB\GUI\GCShowOnlyWF\Height, GLOB\GUI\GCShowOnlyWF\Text)
  SetGadgetState(GLOB\GUI\GCShowOnlyWF\id, GLOB\MN\ShowOnlyWithFiles)
  GLOB\GUI\GCUsePattern\id = CheckBoxGadget(#PB_Any, GLOB\GUI\GCUsePattern\x, GLOB\GUI\GCUsePattern\y, GLOB\GUI\GCUsePattern\Width, GLOB\GUI\GCUsePattern\Height, GLOB\GUI\GCUsePattern\Text)
  SetGadgetState(GLOB\GUI\GCUsePattern\id, GLOB\MN\UsePatterns)
  GLOB\GUI\GCWithSubDirs\id= CheckBoxGadget(#PB_Any, GLOB\GUI\GCWithSubDirs\x, GLOB\GUI\GCWithSubDirs\y, GLOB\GUI\GCWithSubDirs\Width, GLOB\GUI\GCWithSubDirs\Height, GLOB\GUI\GCWithSubDirs\Text)
  SetGadgetState(GLOB\GUI\GCWithSubDirs\id, GLOB\MN\ShowSubDirs)
  GLOB\GUI\GSSearchFor\id = StringGadget(#PB_Any, GLOB\GUI\GSSearchFor\x, GLOB\GUI\GSSearchFor\y, GLOB\GUI\GSSearchFor\Width, GLOB\GUI\GSSearchFor\Height, GLOB\GUI\GSSearchFor\Text, #PB_String_LowerCase)
  
  
  ;- MAXIMIZE
  If GLOB\GUI\Maximize
    GetWindowPlacement_(WindowID(GLOB\GUI\MainWindow), @WndPl)
    WndPl\showCmd = #SW_MAXIMIZE
    SetWindowPlacement_(WindowID(GLOB\GUI\MainWindow), @WndPl)
  EndIf
EndProcedure

Procedure GUIUpdateWindowDatas()
  Protected WndPl.WINDOWPLACEMENT
  
  GLOB\GUI\PosX    = WindowX(GLOB\GUI\MainWindow)
  GLOB\GUI\PosY    = WindowY(GLOB\GUI\MainWindow)
  GLOB\GUI\Width   = WindowWidth(GLOB\GUI\MainWindow)
  GLOB\GUI\Height  = WindowHeight(GLOB\GUI\MainWindow)
  
  GetWindowPlacement_(WindowID(GLOB\GUI\MainWindow), @WndPl)
  If WndPl\showCmd = #SW_MAXIMIZE
    GLOB\GUI\Maximize = #True
  Else
    GLOB\GUI\Maximize = #False
  EndIf
EndProcedure

Procedure GUIResize()
  Protected WWidth.l, WHeight.l
  
  WWidth  = GLOB\GUI\Width
  WHeight = GLOB\GUI\Height
  
  GLOB\GUI\GTree\Height = WHeight - 110
  ResizeGadget(GLOB\GUI\GTree\id, #PB_Ignore, #PB_Ignore, #PB_Ignore, GLOB\GUI\GTree\Height)
  
  GLOB\GUI\GSSearchFor\x = WWidth - 110
  ResizeGadget(GLOB\GUI\GSSearchFor\id, GLOB\GUI\GSSearchFor\x, #PB_Ignore, #PB_Ignore, #PB_Ignore)
  
  GLOB\GUI\GEditor\Width  = WWidth - 160 - 40
  GLOB\GUI\GEditor\Height = WHeight - 110
  ResizeGadget(GLOB\GUI\GEditor\id, #PB_Ignore, #PB_Ignore, GLOB\GUI\GEditor\Width, GLOB\GUI\GEditor\Height)
  
  
EndProcedure

Procedure GUIChangeWindowTitle(Title.s)
  GLOB\GUI\Title = Title
  SetWindowTitle(GLOB\GUI\MainWindow, Title)
EndProcedure




; IDE Options = PureBasic v3.94 (Windows - x86)
; CursorPosition = 106
; FirstLine = 4 
; jaPBe Version=3.6.8.556
; Build=0
; CompileThis=Project-Manager.pb
; FirstLine=127
; CursorPosition=165
; EnableXP
; ExecutableFormat=Windows
; CPU=1
; DontSaveDeclare
; EOF