

Procedure MNIsNotInPattern(Text.s, Pattern.s)
  Protected s.s, z.l, n.l
  
  Text = LCase(Text)
  n = CountString(Pattern, ",")
  For z = 1 To n + 1
    s = StringField(Pattern, z, ",")
    If s <> ""
      If FindString(Text, s, 1)
        ProcedureReturn #False
      EndIf
    EndIf
  Next
  
  
  ProcedureReturn #True
EndProcedure


Procedure.l MNGetIcon(FileName.s)
  Protected ExeName.s, a.l, hIcon.l
  
  ExeName = FileName
  a       = 0
  hIcon   = ExtractAssociatedIcon_(0, @ExeName, @a)
  If a
    hIcon = a
  EndIf
  
  AddElement(hIcons())
  hIcons() = hIcon
  
  ProcedureReturn hIcon
EndProcedure

Procedure MNRecursiveSearch(MainFolder.s, ex.s, Folder.s, FileCount.l, Level.l, TreeLevel.l)
  Protected Name.s, Typ.l, s.s
  
  
  If ExamineDirectory(Level, Folder, "*.*")
    While NextDirectoryEntry(Level)
      If DirectoryEntryType(Level) = #PB_DirectoryEntry_File And GetExtensionPart(DirectoryEntryName(Level)) = ex And (GLOB\MN\UsePatterns = #False Or MNIsNotInPattern(DirectoryEntryName(Level), GLOB\MN\DontShowFilePattern))
        
        Name = Folder + "\" + DirectoryEntryName(Level)
        If FileCount = 0
          ; setze *.txt - Icon
          AddGadgetItem(GLOB\GUI\GTree\id, -1, ex, MNGetIcon(Name), TreeLevel)
        EndIf
        
        s = Right(Name, Len(Name) - Len(MainFolder) - 1)
        AddGadgetItem(GLOB\GUI\GTree\id, -1, s, MNGetIcon(Name), TreeLevel + 1)
        
        FileCount + 1
        
      ElseIf DirectoryEntryType(Level) = #PB_DirectoryEntry_Directory And DirectoryEntryName(Level) <> "." And DirectoryEntryName(Level) <> ".."
        If GLOB\MN\ShowSubDirs
          FileCount = MNRecursiveSearch(MainFolder, ex, Folder + "\" + DirectoryEntryName(Level), FileCount, Level + 1, TreeLevel)
        EndIf
      EndIf
    Wend
    
    FinishDirectory(Level)
  EndIf
  
  
  ProcedureReturn FileCount
EndProcedure

Procedure MNUpdate()
  Protected Typ.l, EntryName.s, FileCount.l, ItemNr.l, z.l, s.s, n.l, FileCount2.l, Name.s, MainFolder.s
  Protected Level = 0, ffC.l
  
  GUIDisableGadgets(#True)
  ClearGadgetItemList(GLOB\GUI\GTree\id)
  ForEach hIcons()
    DestroyIcon_(hIcons())
  Next
  ClearList(hIcons())
  
  TreeView_SetLineColor(GadgetID(GLOB\GUI\GTree\id), $FF)
  TreeView_SetBkColor(GadgetID(GLOB\GUI\GTree\id), $FFF8F0)
  
  If ExamineDirectory(0, GLOB\MN\ProjectsDir, "*.*")
    
    While NextDirectoryEntry(0)
      If DirectoryEntryType(0) = #PB_DirectoryEntry_Directory
        ; Ist ein Ordner
        EntryName = DirectoryEntryName(0)
        If EntryName <> "." And EntryName <> ".." And (GLOB\MN\UsePatterns = #False Or MNIsNotInPattern(EntryName, GLOB\MN\DontShowPrjPattern))
          
          Name = GLOB\MN\ProjectsDir + EntryName
          AddGadgetItem(GLOB\GUI\GTree\id, -1, EntryName, MNGetIcon(Name), 0) ;>
            MainFolder = Name
            FileCount  = 0
            n = CountString(GLOB\MN\FilePatterns, "|") + 1
            For z = 1 To n
              s = StringField(GLOB\MN\FilePatterns, z, "|")
              
              FileCount + MNRecursiveSearch(MainFolder, Right(s, Len(s) - 2), GLOB\MN\ProjectsDir + EntryName, 0, 1, 1)
            Next
           ;<
            
          If FileCount = 0 And GLOB\MN\ShowOnlyWithFiles
            RemoveGadgetItem(GLOB\GUI\GTree\id, CountGadgetItems(GLOB\GUI\GTree\id) - 1)
          EndIf
          
        EndIf
        
        While WindowEvent() : Wend
      EndIf
      
    Wend
    FinishDirectory(0)
  EndIf
  
  GUIDisableGadgets(#False)
EndProcedure

Procedure MNSearch(In.s, Withs.s)
  Protected n.l, z.l
  
  Withs = Trim(Withs)
  n = CountString(Withs, " ") + 1
  For z = 1 To n
    If FindString(In, StringField(Withs, z, " "), 1) = #False
      ProcedureReturn #False
    EndIf
  Next
  
  ProcedureReturn #True
EndProcedure

Procedure MNSearchFor(Text.s)
  Protected AnzItems.l, z.l
  
  AnzItems = CountGadgetItems(GLOB\GUI\GTree\id)
  For z = 0 To AnzItems - 1
    SetGadgetItemState(GLOB\GUI\GTree\id, z, #PB_Tree_Collapsed)
    
    If Text <> ""
      If MNSearch(LCase(GetGadgetItemText(GLOB\GUI\GTree\id, z, 0)), Text)
        SetGadgetItemState(GLOB\GUI\GTree\id, EVTreeGetParent(EVTreeGetParent(z)), #PB_Tree_Expanded)
        SetGadgetItemState(GLOB\GUI\GTree\id, EVTreeGetParent(z), #PB_Tree_Expanded)
        SetGadgetItemState(GLOB\GUI\GTree\id, z, #PB_Tree_Expanded)
      EndIf
    EndIf
  Next
  
EndProcedure


 
; jaPBe Version=3.6.8.556
; FoldLines=00020012
; Build=0
; CompileThis=Project-Manager.pb
; FirstLine=62
; CursorPosition=94
; ExecutableFormat=Windows
; DontSaveDeclare
; EOF