

Procedure PRFInit()
  GLOB\PRF\FileName = "Preferences.ini"
EndProcedure

Procedure PRFLoadPreferences()
  Protected s.s
  
  OpenPreferences(GLOB\PRF\FileName)
  PreferenceGroup("GUI")
  GLOB\GUI\PosX    = ReadPreferenceLong("PosX", 100)
  GLOB\GUI\PosY    = ReadPreferenceLong("PosY", 100)
  GLOB\GUI\Width   = ReadPreferenceLong("Width", 500)
  GLOB\GUI\Height  = ReadPreferenceLong("Height", 500)
  GLOB\GUI\Flags   = ReadPreferenceLong("Flags", #PB_Window_SizeGadget|#PB_Window_SystemMenu|#PB_Window_MaximizeGadget|#PB_Window_MinimizeGadget)
  GLOB\GUI\Maximize= ReadPreferenceLong("Maximize", #True)
  GLOB\GUI\Title   = ReadPreferenceString("Title", "Project-Manager")
  
  PreferenceGroup("Main")
  GLOB\MN\ProjectsDir       = ReadPreferenceString("ProjectsDir", "")
  GLOB\MN\ShowOnlyWithFiles = ReadPreferenceLong("ShowOnlyWithFiles", #False)
  GLOB\MN\FilePatterns      = ReadPreferenceString("FilePatterns", "*.txt")
  GLOB\MN\DontShowPrjPattern  = ReadPreferenceString("DontShowPrjPattern", "kopie")
  GLOB\MN\DontShowFilePattern = ReadPreferenceString("DontShowFilePattern", "kopie")
  GLOB\MN\UsePatterns         = ReadPreferenceLong("UsePatterns", #True)
  GLOB\MN\ShowSubDirs         = ReadPreferenceLong("ShowSubDirs", #True)
  
  PreferenceGroup("Language")
  GLOB\PRW\CHDIRTitle   = ReadPreferenceString("WinChangeDirTitle", "Choose Folder")
  GLOB\PRW\PRFWinTitle  = ReadPreferenceString("WinPrefTitle", "Prefs")
  GLOB\PRW\Fr3D         = ReadPreferenceString("FPrefPattern", "Patterns")
  s = "With these patterns you can define which projects and files will not be shown! "
  s + "Just write the words which shall not be shown into the text fields. "
  s + "Several words can be separated with a ',' (write in lower case).%%"
  s + "Example: kopie,readme%%"
  s + "First box for project patterns and second for file patterns."
  GLOB\PRW\GadTP1       = ReadPreferenceString("TPrefPattern", s)
  GLOB\PRW\GadTP1       = ReplaceString(GLOB\PRW\GadTP1, "%%", #CRLF$)
  s = "In this box you can type in, which file type extensions shall be shown in the list. "
  s + "Just write them like *.ext1|*.ex2 or *.* for all (without blanks)%%"
  s + "Example: *.txt|*.pb"
  GLOB\PRW\GadTP2       = ReadPreferenceString("TPrefFilePattern", s)
  GLOB\PRW\GadTP2       = ReplaceString(GLOB\PRW\GadTP2, "%%", #CRLF$)
  
  GLOB\PRW\NewInputTitle  = ReadPreferenceString("NewInputTitle", "New File")
  s = "Create New File:%%Write the name of the new file into the box. "
  s + "It will be created in the current selected projects directory.%%"
  s + "(including type extension)"
  GLOB\PRW\NewInputText   = ReadPreferenceString("NewInputText", s)
  GLOB\PRW\NewInputText   = ReplaceString(GLOB\PRW\NewInputText, "%%", #CRLF$)
  GLOB\PRW\DeleteMsgTitle = ReadPreferenceString("DeleteMsgTitle", "Delete File")
  s = "Do you really want to delete this file?"
  GLOB\PRW\DeleteMsgText  = ReadPreferenceString("DeleteMsgText", s)
  GLOB\PRW\DeleteMsgText  = ReplaceString(GLOB\PRW\DeleteMsgText, "%%", #CRLF$)
  GLOB\PRW\SaveMsgTitle   = ReadPreferenceString("SaveMsgTitle", "Overwrite")
  s = "Do you want to overwrite this file?"
  GLOB\PRW\SaveMsgText    = ReadPreferenceString("SaveMsgText", s)
  GLOB\PRW\SaveMsgText    = ReplaceString(GLOB\PRW\SaveMsgText, "%%", #CRLF$)
  
  GLOB\GUI\GBChangeDir\Text = ReadPreferenceString("BChangeDir", "Chg Dir")
  GLOB\GUI\GBUpdate\Text    = ReadPreferenceString("BUpdate", "Update")
  GLOB\GUI\GBSetPrefs\Text  = ReadPreferenceString("BPreferences", "Prefs")
  GLOB\GUI\GBOpenDir\Text   = ReadPreferenceString("BOpenDir", "OpenDir")
  GLOB\GUI\GBRun\Text       = ReadPreferenceString("BRun", "Run")
  
  GLOB\GUI\GBNew\Text       = ReadPreferenceString("BNew", "New")
  GLOB\GUI\GBDelete\Text    = ReadPreferenceString("BDelete", "Delete")
  GLOB\GUI\GBSave\Text      = ReadPreferenceString("BSave", "Save")
  
  GLOB\GUI\GCShowOnlyWF\Text  = ReadPreferenceString("CShowOnlyWF", "ShowOnlyWithFiles")
  GLOB\GUI\GCUsePattern\Text  = ReadPreferenceString("CUsePattern", "UsePatterns")
  GLOB\GUI\GCWithSubDirs\Text = ReadPreferenceString("CWithSubDirs", "ShowSubDirs")
  GLOB\GUI\GSSearchFor\Text   = ReadPreferenceString("SSearchFor", "search")
  
  ClosePreferences()
EndProcedure

Procedure PRFSavePreferences()
  Protected s.s
  
  CreatePreferences(GLOB\PRF\FileName)
  PreferenceGroup("GUI")
  WritePreferenceLong("PosX", GLOB\GUI\PosX)
  WritePreferenceLong("PosY", GLOB\GUI\PosY)
  WritePreferenceLong("Width", GLOB\GUI\Width)
  WritePreferenceLong("Height", GLOB\GUI\Height)
  WritePreferenceLong("Flags", GLOB\GUI\Flags)
  WritePreferenceLong("Maximize", GLOB\GUI\Maximize)
  WritePreferenceString("Title", GLOB\GUI\Title)
  
  PreferenceGroup("Main")
  WritePreferenceString("ProjectsDir", GLOB\MN\ProjectsDir)
  WritePreferenceLong("ShowOnlyWithFiles", GLOB\MN\ShowOnlyWithFiles)
  WritePreferenceString("FilePatterns", GLOB\MN\FilePatterns)
  WritePreferenceString("DontShowPrjPattern", GLOB\MN\DontShowPrjPattern)
  WritePreferenceString("DontShowFilePattern", GLOB\MN\DontShowFilePattern)
  WritePreferenceLong("UsePatterns", GLOB\MN\UsePatterns)
  WritePreferenceLong("ShowSubDirs", GLOB\MN\ShowSubDirs)
  
  PreferenceGroup("Language")
  WritePreferenceString("WinChangeDirTitle", GLOB\PRW\CHDIRTitle)
  WritePreferenceString("WinPrefTitle", GLOB\PRW\PRFWinTitle)
  WritePreferenceString("FPrefPattern", GLOB\PRW\Fr3D)
  WritePreferenceString("TPrefPattern", ReplaceString(GLOB\PRW\GadTP1, #CRLF$, "%%"))
  WritePreferenceString("TPrefFilePattern", ReplaceString(GLOB\PRW\GadTP2, #CRLF$, "%%"))
  
  WritePreferenceString("NewInputTitle", GLOB\PRW\NewInputTitle)
  WritePreferenceString("NewInputText", ReplaceString(GLOB\PRW\NewInputText, #CRLF$, "%%"))
  WritePreferenceString("DeleteMsgTitle", GLOB\PRW\DeleteMsgTitle)
  WritePreferenceString("DeleteMsgText", ReplaceString(GLOB\PRW\DeleteMsgText, #CRLF$, "%%"))
  WritePreferenceString("SaveMsgTitle", GLOB\PRW\SaveMsgTitle)
  WritePreferenceString("SaveMsgText", ReplaceString(GLOB\PRW\SaveMsgText, #CRLF$, "%%"))
  
  WritePreferenceString("BChangeDir", GLOB\GUI\GBChangeDir\Text)
  WritePreferenceString("BUpdate", GLOB\GUI\GBUpdate\Text)
  WritePreferenceString("BPreferences", GLOB\GUI\GBSetPrefs\Text)
  WritePreferenceString("BOpenDir", GLOB\GUI\GBOpenDir\Text)
  WritePreferenceString("BRun", GLOB\GUI\GBRun\Text)
  
  WritePreferenceString("BNew", GLOB\GUI\GBNew\Text)
  WritePreferenceString("BDelete", GLOB\GUI\GBDelete\Text)
  WritePreferenceString("BSave", GLOB\GUI\GBSave\Text)
  
  WritePreferenceString("CShowOnlyWF", GLOB\GUI\GCShowOnlyWF\Text)
  WritePreferenceString("CUsePattern", GLOB\GUI\GCUsePattern\Text)
  WritePreferenceString("CWithSubDirs", GLOB\GUI\GCWithSubDirs\Text)
  WritePreferenceString("SSearchFor", GLOB\GUI\GSSearchFor\Text)
  
  ClosePreferences()
EndProcedure





 
; jaPBe Version=2.5.4.22
; FoldLines=000200040006004C004E0082
; Build=0
; CompileThis=Project-Manager.pb
; FirstLine=0
; CursorPosition=6
; ExecutableFormat=Windows
; DontSaveDeclare
; EOF