
Procedure Tree_GetParent(Gadget, item) 
  sublevel = GetGadgetItemAttribute(Gadget, item, #PB_Tree_SubLevel) ; the first item with a sublevel smaller than this must be the parent 
  While item > 0 And GetGadgetItemAttribute(Gadget, item, #PB_Tree_SubLevel) >= sublevel 
    item - 1 
  Wend
  
  If item = 0 And GetGadgetItemAttribute(Gadget, item, #PB_Tree_SubLevel) >= sublevel 
    ProcedureReturn -1
  EndIf
  ProcedureReturn item 
EndProcedure

; #define TreeView_InsertItem(hwnd,lpis)  (HTREEITEM)SNDMSG((hwnd),TVM_INSERTITEM,0,(LPARAM)(LPTreeView_INSERTSTRUCT)(lpis))
Procedure TreeView_InsertItem(hGadget.l, lpis.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_INSERTITEM, 0, lpis)
EndProcedure
; #define TreeView_DeleteItem(hwnd,hitem)  (BOOL)SNDMSG((hwnd),TVM_DELETEITEM,0,(LPARAM)(HTREEITEM)(hitem))
Procedure TreeView_DeleteItem(hGadget.l, hItem.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_DELETEITEM, 0, hItem)
EndProcedure
; #define TreeView_DeleteAllItems(hwnd)  (BOOL)SNDMSG((hwnd),TVM_DELETEITEM,0,(LPARAM)TVI_ROOT)
Procedure TreeView_DeleteAllItems(hGadget)
  ProcedureReturn SendMessage_(hGadget, #TVM_DELETEITEM, 0, #TVI_ROOT)
EndProcedure
; #define TreeView_Expand(hwnd,hitem,code)  (BOOL)SNDMSG((hwnd),TVM_EXPAND,(WPARAM)(code),(LPARAM)(HTREEITEM)(hitem))
Procedure TreeView_Expand(hGadget.l, hItem.l, Flag.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_EXPAND, Flag, hItem)
EndProcedure
; #define TreeView_GetItemRect(hwnd,hitem,prc,code)  (*(HTREEITEM*)prc = (hitem), (BOOL)SNDMSG((hwnd),TVM_GETITEMRECT,(WPARAM)(code),(LPARAM)(RECT*)(prc)))
Procedure TreeView_GetItemRect(hGadget.l, hItem.l, prc.l, fItemRect.l)
  ;-?
  PokeL(prc, hItem)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETITEMRECT, fItemRect, prc)
EndProcedure
; #define TreeView_GetCount(hwnd)  (UINT)SNDMSG((hwnd),TVM_GETCOUNT,0,0)
Procedure TreeView_GetCount(hGadget.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETCOUNT, 0, 0)
EndProcedure
; #define TreeView_GetIndent(hwnd)  (UINT)SNDMSG((hwnd),TVM_GETINDENT,0,0)
Procedure TreeView_GetIndent(hGadget.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETINDENT, 0, 0)
EndProcedure
; #define TreeView_SetIndent(hwnd,indent)  (BOOL)SNDMSG((hwnd),TVM_SETINDENT,(WPARAM)(indent),0)
Procedure TreeView_SetIndent(hGadget.l, Indent.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_SETINDENT, Indent, 0)
EndProcedure
; #define TreeView_GetImageList(hwnd,iImage)  (HIMAGELIST)SNDMSG((hwnd),TVM_GETIMAGELIST,iImage,0)
Procedure TreeView_GetImageList(hGadget.l, iImage.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETIMAGELIST, iImage, 0)
EndProcedure
; #define TreeView_SetImageList(hwnd,himl,iImage)  (HIMAGELIST)SNDMSG((hwnd),TVM_SETIMAGELIST,iImage,(LPARAM)(HIMAGELIST)(himl))
Procedure TreeView_SetImageList(hGadget.l, himl.l, iImage.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_SETIMAGELIST, iImage, himl)
EndProcedure
; #define TreeView_GetNextItem(hwnd,hitem,code)  (HTREEITEM)SNDMSG((hwnd),TVM_GETNEXTITEM,(WPARAM)(code),(LPARAM)(HTREEITEM)(hitem))
Procedure TreeView_GetNextItem(hGadget.l, hItem.l, Flag.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETNEXTITEM, Flag, hItem)
EndProcedure
; #define TreeView_GetChild(hwnd,hitem)  TreeView_GetNextItem(hwnd,hitem,TVGN_CHILD)
Procedure TreeView_GetChild(hGadget.l, hItem.l)
  ProcedureReturn TreeView_GetNextItem(hGadget, hItem, #TVGN_CHILD)
EndProcedure
; #define TreeView_GetNextSibling(hwnd,hitem)  TreeView_GetNextItem(hwnd,hitem,TVGN_NEXT)
Procedure TreeView_GetNextSibling(hGadget.l, hItem.l)
  ProcedureReturn TreeView_GetNextItem(hGadget, hItem, #TVGN_NEXT)
EndProcedure
; #define TreeView_GetPrevSibling(hwnd,hitem)  TreeView_GetNextItem(hwnd,hitem,TVGN_PREVIOUS)
Procedure TreeView_GetPrevSibling(hGadget.l, hItem.l)
  ProcedureReturn TreeView_GetNextItem(hGadget, hItem, #TVGN_PREVIOUS)
EndProcedure
; #define TreeView_GetParent(hwnd,hitem)  TreeView_GetNextItem(hwnd,hitem,TVGN_PARENT)
Procedure TreeView_GetParent(hGadget.l, hItem)
  ProcedureReturn TreeView_GetNextItem(hGadget, hItem, #TVGN_PARENT)
EndProcedure
; #define TreeView_GetFirstVisible(hwnd)  TreeView_GetNextItem(hwnd,NULL,TVGN_FIRSTVISIBLE)
Procedure TreeView_GetFirstVisible(hGadget.l)
  ProcedureReturn TreeView_GetNextItem(hGadget, #Null, #TVGN_FIRSTVISIBLE)
EndProcedure
; #define TreeView_GetNextVisible(hwnd,hitem)  TreeView_GetNextItem(hwnd,hitem,TVGN_NEXTVISIBLE)
Procedure TreeView_GetNextVisible(hGadget.l, hItem.l)
  ProcedureReturn TreeView_GetNextItem(hGadget, hItem, #TVGN_NEXTVISIBLE)
EndProcedure
; #define TreeView_GetPrevVisible(hwnd,hitem)  TreeView_GetNextItem(hwnd,hitem,TVGN_PREVIOUSVISIBLE)
Procedure TreeView_GetPrevVisible(hGadget.l, hItem.l)
  ProcedureReturn TreeView_GetNextItem(hGadget, hItem, #TVGN_PREVIOUSVISIBLE)
EndProcedure
; #define TreeView_GetSelection(hwnd)  TreeView_GetNextItem(hwnd,NULL,TVGN_CARET)
Procedure TreeView_GetSelection(hGadget.l)
  ProcedureReturn TreeView_GetNextItem(hGadget, #Null, #TVGN_CARET)
EndProcedure
; #define TreeView_GetDropHilight(hwnd)  TreeView_GetNextItem(hwnd,NULL,TVGN_DROPHILITE)
Procedure TreeView_GetDropHilight(hGadget.l)
  ProcedureReturn TreeView_GetNextItem(hGadget, #Null, #TVGN_DROPHILITE)
EndProcedure
; #define TreeView_GetRoot(hwnd)  TreeView_GetNextItem(hwnd,NULL,TVGN_ROOT)
Procedure TreeView_GetRoot(hGadget.l)
  ProcedureReturn TreeView_GetNextItem(hGadget, #Null, #TVGN_ROOT)
EndProcedure
; #if (_WIN32_IE >= 0x0400)
; #define TreeView_GetLastVisible(hwnd)  TreeView_GetNextItem(hwnd,NULL,TVGN_LASTVISIBLE)
#TVGN_LASTVISIBLE = $A
Procedure TreeView_GetLastVisible(hGadget.l)
  ProcedureReturn TreeView_GetNextItem(hGadget, #Null, #TVGN_LASTVISIBLE)
EndProcedure
; #endif
; #define TreeView_Select(hwnd,hitem,code)  (BOOL)SNDMSG((hwnd),TVM_SELECTITEM,(WPARAM)(code),(LPARAM)(HTREEITEM)(hitem))
Procedure TreeView_Select(hGadget.l, hItem.l, Flag.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_SELECTITEM, Flag, hItem)
EndProcedure
; #define TreeView_SelectItem(hwnd,hitem)  TreeView_Select(hwnd,hitem,TVGN_CARET)
Procedure TreeView_SelectItem(hGadget.l, hItem.l)
  ProcedureReturn TreeView_Select(hGadget, hItem, #TVGN_CARET)
EndProcedure
; #define TreeView_SelectDropTarget(hwnd,hitem)  TreeView_Select(hwnd,hitem,TVGN_DROPHILITE)
Procedure TreeView_SelectDropTarget(hGadget.l, hItem.l)
  ProcedureReturn TreeView_Select(hGadget, hItem, #TVGN_DROPHILITE)
EndProcedure
; #define TreeView_SelectSetFirstVisible(hwnd,hitem)  TreeView_Select(hwnd,hitem,TVGN_FIRSTVISIBLE)
Procedure TreeView_SelectSetFirstVisible(hGadget.l, hItem.l)
  ProcedureReturn TreeView_Select(hGadget, hItem, #TVGN_FIRSTVISIBLE)
EndProcedure
; #define TreeView_GetItem(hwnd,pitem)  (BOOL)SNDMSG((hwnd),TVM_GETITEM,0,(LPARAM)(TreeView_ITEM*)(pitem))
Procedure TreeView_GetItem(hGadget.l, pitem)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETITEM, 0, pitem)
EndProcedure
; #define TreeView_SetItem(hwnd,pitem)  (BOOL)SNDMSG((hwnd),TVM_SETITEM,0,(LPARAM)(const TreeView_ITEM*)(pitem))
Procedure TreeView_SetItem(hGadget.l, pitem)
  ProcedureReturn SendMessage_(hGadget, #TVM_SETITEM, 0, pitem)
EndProcedure
; #define TreeView_EditLabel(hwnd,hitem)  (hwnd)SNDMSG((hwnd),TVM_EDITLABEL,0,(LPARAM)(HTREEITEM)(hitem))
Procedure TreeView_EditLabel(hGadget.l, hItem.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_EDITLABEL, 0, hItem)
EndProcedure
; #define TreeView_GetEditControl(hwnd)  (hwnd)SNDMSG((hwnd),TVM_GETEDITCONTROL,0,0)
Procedure TreeView_GetEditControl(hGadget.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETEDITCONTROL, 0, 0)
EndProcedure
; #define TreeView_GetVisibleCount(hwnd)  (UINT)SNDMSG((hwnd),TVM_GETVISIBLECOUNT,0,0)
Procedure TreeView_GetVisibleCount(hGadget.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETVISIBLECOUNT, 0, 0)
EndProcedure
; #define TreeView_HitTest(hwnd,lpht)  (HTREEITEM)SNDMSG((hwnd),TVM_HITTEST,0,(LPARAM)(LPTreeView_HITTESTINFO)(lpht))
Procedure TreeView_HitTest(hGadget.l, lpht.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_HITTEST, 0, lpht)
EndProcedure
; #define TreeView_CreateDragImage(hwnd,hitem)  (HIMAGELIST)SNDMSG((hwnd),TVM_CREATEDRAGIMAGE,0,(LPARAM)(HTREEITEM)(hitem))
Procedure TreeView_CreateDragImage(hGadget.l, hItem.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_CREATEDRAGIMAGE, 0, hItem)
EndProcedure
; #define TreeView_SortChildren(hwnd,hitem,recurse)  (BOOL)SNDMSG((hwnd),TVM_SORTCHILDREN,(WPARAM)(recurse),(LPARAM)(HTREEITEM)(hitem))
Procedure TreeView_SortChildren(hGadget.l, hItem.l, fRecurse.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_SORTCHILDREN, fRecurse, hItem)
EndProcedure
; #define TreeView_EnsureVisible(hwnd,hitem)  (BOOL)SNDMSG((hwnd),TVM_ENSUREVISIBLE,0,(LPARAM)(HTREEITEM)(hitem))
Procedure TreeView_EnsureVisible(hGadget.l, hItem.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_ENSUREVISIBLE, 0, hItem)
EndProcedure
; #define TreeView_SortChildrenCB(hwnd,psort,recurse)  (BOOL)SNDMSG((hwnd),TVM_SORTCHILDRENCB,(WPARAM)(recurse),(LPARAM)(LPTreeView_SORTCB)(psort))
Procedure TreeView_SortChildrenCB(hGadget.l, psort.l, fRecurse.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_SORTCHILDREN, fRecurse, psort)
EndProcedure
; #define TreeView_EndEditLabelNow(hwnd,fCancel)  (BOOL)SNDMSG((hwnd),TVM_ENDEDITLABELNOW,(WPARAM)(fCancel),0)
Procedure TreeView_EndEditLabelNow(hGadget.l, fCancel.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_ENDEDITLABELNOW, fCancel, 0)
EndProcedure
; #define TreeView_GetISearchString(hwnd,lpsz)  (BOOL)SNDMSG((hwnd),TVM_GETISEARCHSTRING,0,(LPARAM)(LPTSTR)(lpsz))
Procedure TreeView_GetISearchString(hGadget.l, lpsz.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETISEARCHSTRING, 0, lpsz)
EndProcedure
; #define TreeView_SetToolTips(hwnd,hwndTT)  (hwnd)SNDMSG((hwnd),TVM_SETTOOLTIPS,(WPARAM)(hwndTT),0)
#TVM_SETTOOLTIPS = $1100 + 24
Procedure TreeView_SetToolTips(hGadget.l, hwndTT.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_SETTOOLTIPS, hwndTT, 0)
EndProcedure
; #define TreeView_GetToolTips(hwnd)  (hwnd)SNDMSG((hwnd),TVM_GETTOOLTIPS,0,0)
#TVM_GETTOOLTIPS = $1100 + 25
Procedure TreeView_GetToolTips(hGadget.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETTOOLTIPS, 0, 0)
EndProcedure
; #if (_WIN32_IE >= 0x0400)
; #define TreeView_SetInsertMark(hwnd,hitem,fAfter)  (BOOL)SNDMSG((hwnd),TVM_SETINSERTMARK,(WPARAM)(fAfter),(LPARAM)(hitem))
#TVM_SETINSERTMARK = $1100 + 26
Procedure TreeView_SetInsertMark(hGadget.l, hItem.l, fAfter.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_SETINSERTMARK, fAfter, hItem)
EndProcedure
; #define TreeView_SetUnicodeFormat(hwnd,fUnicode)  (BOOL)SNDMSG((hwnd),TVM_SETUNICODEFORMAT,(WPARAM)(fUnicode),0)
#TVM_SETUNICODEFORMAT = $2000 + 5
Procedure TreeView_SetUnicodeFormat(hGadget.l, fUnicode.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_SETUNICODEFORMAT, fUnicode, 0)
EndProcedure
; #define TreeView_GetUnicodeFormat(hwnd)  (BOOL)SNDMSG((hwnd),TVM_GETUNICODEFORMAT,0,0)
#TVM_GETUNICODEFORMAT = $2000 + 5
Procedure TreeView_GetUnicodeFormat(hGadget.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETUNICODEFORMAT, 0, 0)
EndProcedure
; #define TreeView_SetItemHeight(hwnd,iHeight)  (int)SNDMSG((hwnd),TVM_SETITEMHEIGHT,(WPARAM)(iHeight),0)
#TVM_SETITEMHEIGHT = $1100 + 27
Procedure TreeView_SetItemHeight(hGadget.l, iHeight.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_SETITEMHEIGHT, iHeight, 0)
EndProcedure
; #define TreeView_GetItemHeight(hwnd)  (int)SNDMSG((hwnd),TVM_GETITEMHEIGHT,0,0)
#TVM_GETITEMHEIGHT = $1100 + 28
Procedure TreeView_GetItemHeight(hGadget.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETITEMHEIGHT, 0, 0)
EndProcedure
; #define TreeView_SetBkColor(hwnd,clr)  (COLORREF)SNDMSG((hwnd),TVM_SETBKCOLOR,0,(LPARAM)(clr))
#TVM_SETBKCOLOR = $1100 + 29
Procedure TreeView_SetBkColor(hGadget.l, clr.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_SETBKCOLOR, 0, clr)
EndProcedure
; #define TreeView_SetTextColor(hwnd,clr)  (COLORREF)SNDMSG((hwnd),TVM_SETTEXTCOLOR,0,(LPARAM)(clr))
#TVM_SETTEXTCOLOR = $1100 + 30
Procedure TreeView_SetTextColor(hGadget.l, clr.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_SETTEXTCOLOR, 0, clr)
EndProcedure
; #define TreeView_GetBkColor(hwnd)  (COLORREF)SNDMSG((hwnd),TVM_GETBKCOLOR,0,0)
#TVM_GETBKCOLOR = $1100 + 31
Procedure TreeView_GetBkColor(hGadget.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETBKCOLOR, 0, 0)
EndProcedure
; #define TreeView_GetTextColor(hwnd)  (COLORREF)SNDMSG((hwnd),TVM_GETTEXTCOLOR,0,0)
#TVM_GETTEXTCOLOR = $1100 + 32
Procedure TreeView_GetTextColor(hGadget.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETTEXTCOLOR, 0, 0)
EndProcedure
; #define TreeView_SetScrollTime(hwnd,uTime)  (UINT)SNDMSG((hwnd),TVM_SETSCROLLTIME,uTime,0)
#TVM_SETSCROLLTIME = $1100 + 33
Procedure TreeView_SetScrollTime(hGadget.l, uTime.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_SETSCROLLTIME, uTime, 0)
EndProcedure
; #define TreeView_GetScrollTime(hwnd)  (UINT)SNDMSG((hwnd),TVM_GETSCROLLTIME,0,0)
#TVM_GETSCROLLTIME = $1100 + 34
Procedure TreeView_GetScrollTime(hGadget.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETSCROLLTIME, 0, 0)
EndProcedure
; #define TreeView_SetInsertMarkColor(hwnd,clr)  (COLORREF)SNDMSG((hwnd),TVM_SETINSERTMARKCOLOR,0,(LPARAM)(clr))
#TVM_SETINSERTMARKCOLOR = $1100 + 37
Procedure TreeView_SetInsertMarkColor(hGadget.l, clr.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_SETINSERTMARKCOLOR, 0, clr)
EndProcedure
; #define TreeView_GetInsertMarkColor(hwnd)  (COLORREF)SNDMSG((hwnd),TVM_GETINSERTMARKCOLOR,0,0)
#TVM_GETINSERTMARKCOLOR = $1100 + 38
Procedure TreeView_GetInsertMarkColor(hGadget.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETINSERTMARKCOLOR, 0, 0)
EndProcedure
; #endif
; #if (_WIN32_IE >= 0x0500)
; #define TreeView_SetItemState(hwnd,hti,Data,_mask)  { TVITEM _ms_TVi; _ms_TVi.mask = TVIF_STATE; _ms_TVi.hItem = hti; _ms_TVi.stateMask = _mask; _ms_TVi.state = data; SNDMSG((hwnd),TVM_SETITEM,0,(LPARAM)(TreeView_ITEM*)&_ms_TVi); }
Structure TVITEM
  mask.l
  hItem.l
  state.l
  stateMask.l
  pszText.l
  cchTextMax.l
  iImage.l
  iSelectedImage.l
  cChildren.l
  LPARAM.l
EndStructure
Procedure TreeView_SetItemState(hGadget.l, hItem.l, Datan.l, _mask.l)
  _ms_TVi.TVITEM
  _ms_TVi\mask = #TVIF_STATE
  _ms_TVi\hItem = hItem
  _ms_TVi\stateMask = _mask
  _ms_TVi\state = Datan
  ProcedureReturn SendMessage_(hGadget, #TVM_SETITEM, 0, @_ms_TVi)
EndProcedure
; #define TreeView_SetCheckState(hwnd,hti,fCheck)  TreeView_SetItemState(hwnd,hti,INDEXTOSTATEIMAGEMASK((fCheck)?2:1),TVIS_STATEIMAGEMASK)
Procedure TreeView_SetCheckState(hGadget.l, hItem.l, fCheck.l)
  ;- ?
  If fCheck
    ProcedureReturn TreeView_SetItemState(hGadget, hItem, 2<<12, #TVIS_STATEIMAGEMASK)
  Else
    ProcedureReturn TreeView_SetItemState(hGadget, hItem, 1<<12, #TVIS_STATEIMAGEMASK)
  EndIf
EndProcedure
; #define TreeView_GetItemState(hwnd,hti,mask)  (UINT)SNDMSG((hwnd),TVM_GETITEMSTATE,(WPARAM)(hti),(LPARAM)(mask))
#TVM_GETITEMSTATE = $1100 + 39
Procedure TreeView_GetItemState(hGadget.l, hItem.l, mask.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETITEMSTATE, hItem, mask)
EndProcedure
; #define TreeView_GetCheckState(hwnd,hti)  ((((UINT)(SNDMSG((hwnd),TVM_GETITEMSTATE,(WPARAM)(hti),TVIS_STATEIMAGEMASK)))>>12)-1)
Procedure TreeView_GetCheckState(hGadget.l, hItem.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETITEMSTATE, hItem, #TVIS_STATEIMAGEMASK) >> 12 - 1
EndProcedure
; #define TreeView_SetLineColor(hwnd,clr)  (COLORREF)SNDMSG((hwnd),TVM_SETLINECOLOR,0,(LPARAM)(clr))
#TVM_SETLINECOLOR = $1100 + 40
Procedure TreeView_SetLineColor(hGadget.l, clr.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_SETLINECOLOR, 0, clr)
EndProcedure
; #define TreeView_GetLineColor(hwnd)  (COLORREF)SNDMSG((hwnd),TVM_GETLINECOLOR,0,0)
#TVM_GETLINECOLOR = $1100 + 40
Procedure TreeView_GetLineColor(hGadget.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_GETLINECOLOR, 0, 0)
EndProcedure
; #endif
; #if (_WIN32_WINNT >= 0x0501)
; #define TreeView_MapHTREEITEMToAccID(hwnd,HTREEITEM)  (UINT)SNDMSG((hwnd),TVM_MAPHTREEITEMTOACCID,(WPARAM)HTREEITEM,0)
#TVM_MAPHTREEITEMTOACCID = $1100 + 43
Procedure TreeView_MapHTREEITEMToAccID(hGadget.l, HTREEITEM.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_MAPHTREEITEMTOACCID, HTREEITEM, 0)
EndProcedure
; #define TreeView_MapAccIDToHTREEITEM(hwnd,id)  (HTREEITEM)SNDMSG((hwnd),TVM_MAPACCIDTOHTREEITEM,id,0)
#TVM_MAPACCIDTOHTREEITEM = $1100 + 42
Procedure TreeView_MapAccIDToHTREEITEM(hGadget.l, id.l)
  ProcedureReturn SendMessage_(hGadget, #TVM_MAPACCIDTOHTREEITEM, ID, 0)
EndProcedure
; #endif


 
; jaPBe Version=3.6.8.556
; FoldLines=000E00100012001400160018001A001C001E0022002400260028002A002C002E
; FoldLines=00300032003400360038003A003C003E00400042004400460048004A004C004E
; FoldLines=00500052005400560058005A005C005E0060006200660068006B006D006F0071
; FoldLines=0073007500770079007B007D007F00810083008500870089008B008D008F0091
; FoldLines=0093009500970099009B009D009F00A100A300A500A700A900AC00AE00B100B3
; FoldLines=00B700B900BC00BE00C100C300C600C800CB00CD00D000D200D500D700DA00DC
; FoldLines=00DF00E100E400E600E900EB00EE00F000F300F500F901040105010C010E0115
; FoldLines=0118011A011C011E0121012301260128012D012F01320134
; Build=0
; CompileThis=Project-Manager.pb
; FirstLine=0
; CursorPosition=8
; ExecutableFormat=Windows
; DontSaveDeclare
; EOF