;-------------- FILE: /usr/share/gir-1.0/Clutter-1.0.gir --------------

; ATTENTION: instances of gulong/ulong/long will be translated to
; a INTEGER/.i. This is right on Linux but probably should be a
; LONG/.l on Windows. If you are brave enough, take a look at
; the TypeTranslator class and the attribute c_types, which
; contains the translation table. There you can fix it.

;- NAMESPACE: Clutter from "libclutter-glx-1.0.so.0"

Enumeration ; Gravity
	#CLUTTER_GRAVITY_NONE = 0
	#CLUTTER_GRAVITY_NORTH = 1
	#CLUTTER_GRAVITY_NORTH_EAST = 2
	#CLUTTER_GRAVITY_EAST = 3
	#CLUTTER_GRAVITY_SOUTH_EAST = 4
	#CLUTTER_GRAVITY_SOUTH = 5
	#CLUTTER_GRAVITY_SOUTH_WEST = 6
	#CLUTTER_GRAVITY_WEST = 7
	#CLUTTER_GRAVITY_NORTH_WEST = 8
	#CLUTTER_GRAVITY_CENTER = 9
EndEnumeration

Enumeration ; TextureQuality
	#CLUTTER_TEXTURE_QUALITY_LOW = 0
	#CLUTTER_TEXTURE_QUALITY_MEDIUM = 1
	#CLUTTER_TEXTURE_QUALITY_HIGH = 2
EndEnumeration

Enumeration ; InitError
	#CLUTTER_INIT_SUCCESS = 1
	#CLUTTER_INIT_ERROR_UNKNOWN = 0
	#CLUTTER_INIT_ERROR_THREADS = -1
	#CLUTTER_INIT_ERROR_BACKEND = -2
	#CLUTTER_INIT_ERROR_INTERNAL = -3
EndEnumeration

Enumeration ; PickMode
	#CLUTTER_PICK_NONE = 0
	#CLUTTER_PICK_REACTIVE = 1
	#CLUTTER_PICK_ALL = 2
EndEnumeration

Enumeration ; Interpolation
	#CLUTTER_INTERPOLATION_LINEAR = 0
	#CLUTTER_INTERPOLATION_CUBIC = 1
EndEnumeration

Enumeration ; RotateAxis
	#CLUTTER_X_AXIS = 0
	#CLUTTER_Y_AXIS = 1
	#CLUTTER_Z_AXIS = 2
EndEnumeration

Enumeration ; TimelineDirection
	#CLUTTER_TIMELINE_FORWARD = 0
	#CLUTTER_TIMELINE_BACKWARD = 1
EndEnumeration

Enumeration ; EventType
	#CLUTTER_NOTHING = 0
	#CLUTTER_KEY_PRESS = 1
	#CLUTTER_KEY_RELEASE = 2
	#CLUTTER_MOTION = 3
	#CLUTTER_ENTER = 4
	#CLUTTER_LEAVE = 5
	#CLUTTER_BUTTON_PRESS = 6
	#CLUTTER_BUTTON_RELEASE = 7
	#CLUTTER_SCROLL = 8
	#CLUTTER_STAGE_STATE = 9
	#CLUTTER_DESTROY_NOTIFY = 10
	#CLUTTER_CLIENT_MESSAGE = 11
	#CLUTTER_DELETE = 12
EndEnumeration

Enumeration ; AnimationMode
	#CLUTTER_CUSTOM_MODE = 0
	#CLUTTER_LINEAR = 1
	#CLUTTER_EASE_IN_QUAD = 2
	#CLUTTER_EASE_OUT_QUAD = 3
	#CLUTTER_EASE_IN_OUT_QUAD = 4
	#CLUTTER_EASE_IN_CUBIC = 5
	#CLUTTER_EASE_OUT_CUBIC = 6
	#CLUTTER_EASE_IN_OUT_CUBIC = 7
	#CLUTTER_EASE_IN_QUART = 8
	#CLUTTER_EASE_OUT_QUART = 9
	#CLUTTER_EASE_IN_OUT_QUART = 10
	#CLUTTER_EASE_IN_QUINT = 11
	#CLUTTER_EASE_OUT_QUINT = 12
	#CLUTTER_EASE_IN_OUT_QUINT = 13
	#CLUTTER_EASE_IN_SINE = 14
	#CLUTTER_EASE_OUT_SINE = 15
	#CLUTTER_EASE_IN_OUT_SINE = 16
	#CLUTTER_EASE_IN_EXPO = 17
	#CLUTTER_EASE_OUT_EXPO = 18
	#CLUTTER_EASE_IN_OUT_EXPO = 19
	#CLUTTER_EASE_IN_CIRC = 20
	#CLUTTER_EASE_OUT_CIRC = 21
	#CLUTTER_EASE_IN_OUT_CIRC = 22
	#CLUTTER_EASE_IN_ELASTIC = 23
	#CLUTTER_EASE_OUT_ELASTIC = 24
	#CLUTTER_EASE_IN_OUT_ELASTIC = 25
	#CLUTTER_EASE_IN_BACK = 26
	#CLUTTER_EASE_OUT_BACK = 27
	#CLUTTER_EASE_IN_OUT_BACK = 28
	#CLUTTER_EASE_IN_BOUNCE = 29
	#CLUTTER_EASE_OUT_BOUNCE = 30
	#CLUTTER_EASE_IN_OUT_BOUNCE = 31
	#CLUTTER_ANIMATION_LAST = 32
EndEnumeration

Enumeration ; AlignAxis
	#CLUTTER_ALIGN_X_AXIS = 0
	#CLUTTER_ALIGN_Y_AXIS = 1
EndEnumeration

Enumeration ; UnitType
	#CLUTTER_UNIT_PIXEL = 0
	#CLUTTER_UNIT_EM = 1
	#CLUTTER_UNIT_MM = 2
	#CLUTTER_UNIT_POINT = 3
	#CLUTTER_UNIT_CM = 4
EndEnumeration

Enumeration ; InputMode
	#CLUTTER_INPUT_MODE_MASTER = 0
	#CLUTTER_INPUT_MODE_SLAVE = 1
	#CLUTTER_INPUT_MODE_FLOATING = 2
EndEnumeration

Enumeration ; DragAxis
	#CLUTTER_DRAG_AXIS_NONE = 0
	#CLUTTER_DRAG_X_AXIS = 1
	#CLUTTER_DRAG_Y_AXIS = 2
EndEnumeration

Enumeration ; ShaderError
	#CLUTTER_SHADER_ERROR_NO_ASM = 0
	#CLUTTER_SHADER_ERROR_NO_GLSL = 1
	#CLUTTER_SHADER_ERROR_COMPILE = 2
EndEnumeration

Enumeration ; TableAlignment
	#CLUTTER_TABLE_ALIGNMENT_START = 0
	#CLUTTER_TABLE_ALIGNMENT_CENTER = 1
	#CLUTTER_TABLE_ALIGNMENT_END = 2
EndEnumeration

Enumeration ; X11FilterReturn
	#CLUTTER_X11_FILTER_CONTINUE = 0
	#CLUTTER_X11_FILTER_TRANSLATE = 1
	#CLUTTER_X11_FILTER_REMOVE = 2
EndEnumeration

Enumeration ; RequestMode
	#CLUTTER_REQUEST_HEIGHT_FOR_WIDTH = 0
	#CLUTTER_REQUEST_WIDTH_FOR_HEIGHT = 1
EndEnumeration

Enumeration ; X11XInputEventTypes
	#CLUTTER_X11_XINPUT_KEY_PRESS_EVENT = 0
	#CLUTTER_X11_XINPUT_KEY_RELEASE_EVENT = 1
	#CLUTTER_X11_XINPUT_BUTTON_PRESS_EVENT = 2
	#CLUTTER_X11_XINPUT_BUTTON_RELEASE_EVENT = 3
	#CLUTTER_X11_XINPUT_MOTION_NOTIFY_EVENT = 4
	#CLUTTER_X11_XINPUT_LAST_EVENT = 5
EndEnumeration

Enumeration ; StaticColor
	#CLUTTER_COLOR_WHITE = 0
	#CLUTTER_COLOR_BLACK = 1
	#CLUTTER_COLOR_RED = 2
	#CLUTTER_COLOR_DARK_RED = 3
	#CLUTTER_COLOR_GREEN = 4
	#CLUTTER_COLOR_DARK_GREEN = 5
	#CLUTTER_COLOR_BLUE = 6
	#CLUTTER_COLOR_DARK_BLUE = 7
	#CLUTTER_COLOR_CYAN = 8
	#CLUTTER_COLOR_DARK_CYAN = 9
	#CLUTTER_COLOR_MAGENTA = 10
	#CLUTTER_COLOR_DARK_MAGENTA = 11
	#CLUTTER_COLOR_YELLOW = 12
	#CLUTTER_COLOR_DARK_YELLOW = 13
	#CLUTTER_COLOR_GRAY = 14
	#CLUTTER_COLOR_DARK_GRAY = 15
	#CLUTTER_COLOR_LIGHT_GRAY = 16
	#CLUTTER_COLOR_BUTTER = 17
	#CLUTTER_COLOR_BUTTER_LIGHT = 18
	#CLUTTER_COLOR_BUTTER_DARK = 19
	#CLUTTER_COLOR_ORANGE = 20
	#CLUTTER_COLOR_ORANGE_LIGHT = 21
	#CLUTTER_COLOR_ORANGE_DARK = 22
	#CLUTTER_COLOR_CHOCOLATE = 23
	#CLUTTER_COLOR_CHOCOLATE_LIGHT = 24
	#CLUTTER_COLOR_CHOCOLATE_DARK = 25
	#CLUTTER_COLOR_CHAMELEON = 26
	#CLUTTER_COLOR_CHAMELEON_LIGHT = 27
	#CLUTTER_COLOR_CHAMELEON_DARK = 28
	#CLUTTER_COLOR_SKY_BLUE = 29
	#CLUTTER_COLOR_SKY_BLUE_LIGHT = 30
	#CLUTTER_COLOR_SKY_BLUE_DARK = 31
	#CLUTTER_COLOR_PLUM = 32
	#CLUTTER_COLOR_PLUM_LIGHT = 33
	#CLUTTER_COLOR_PLUM_DARK = 34
	#CLUTTER_COLOR_SCARLET_RED = 35
	#CLUTTER_COLOR_SCARLET_RED_LIGHT = 36
	#CLUTTER_COLOR_SCARLET_RED_DARK = 37
	#CLUTTER_COLOR_ALUMINIUM_1 = 38
	#CLUTTER_COLOR_ALUMINIUM_2 = 39
	#CLUTTER_COLOR_ALUMINIUM_3 = 40
	#CLUTTER_COLOR_ALUMINIUM_4 = 41
	#CLUTTER_COLOR_ALUMINIUM_5 = 42
	#CLUTTER_COLOR_ALUMINIUM_6 = 43
	#CLUTTER_COLOR_TRANSPARENT = 44
EndEnumeration

Enumeration ; PathNodeType
	#CLUTTER_PATH_MOVE_TO = 0
	#CLUTTER_PATH_LINE_TO = 1
	#CLUTTER_PATH_CURVE_TO = 2
	#CLUTTER_PATH_CLOSE = 3
	#CLUTTER_PATH_REL_MOVE_TO = 32
	#CLUTTER_PATH_REL_LINE_TO = 33
	#CLUTTER_PATH_REL_CURVE_TO = 34
EndEnumeration

Enumeration ; BoxAlignment
	#CLUTTER_BOX_ALIGNMENT_START = 0
	#CLUTTER_BOX_ALIGNMENT_END = 1
	#CLUTTER_BOX_ALIGNMENT_CENTER = 2
EndEnumeration

Enumeration ; SnapEdge
	#CLUTTER_SNAP_EDGE_TOP = 0
	#CLUTTER_SNAP_EDGE_RIGHT = 1
	#CLUTTER_SNAP_EDGE_BOTTOM = 2
	#CLUTTER_SNAP_EDGE_LEFT = 3
EndEnumeration

Enumeration ; InputAxis
	#CLUTTER_INPUT_AXIS_IGNORE = 0
	#CLUTTER_INPUT_AXIS_X = 1
	#CLUTTER_INPUT_AXIS_Y = 2
	#CLUTTER_INPUT_AXIS_PRESSURE = 3
	#CLUTTER_INPUT_AXIS_XTILT = 4
	#CLUTTER_INPUT_AXIS_YTILT = 5
	#CLUTTER_INPUT_AXIS_WHEEL = 6
EndEnumeration

Enumeration ; TextDirection
	#CLUTTER_TEXT_DIRECTION_DEFAULT = 0
	#CLUTTER_TEXT_DIRECTION_LTR = 1
	#CLUTTER_TEXT_DIRECTION_RTL = 2
EndEnumeration

Enumeration ; ScrollDirection
	#CLUTTER_SCROLL_UP = 0
	#CLUTTER_SCROLL_DOWN = 1
	#CLUTTER_SCROLL_LEFT = 2
	#CLUTTER_SCROLL_RIGHT = 3
EndEnumeration

Enumeration ; RotateDirection
	#CLUTTER_ROTATE_CW = 0
	#CLUTTER_ROTATE_CCW = 1
EndEnumeration

Enumeration ; FlowOrientation
	#CLUTTER_FLOW_HORIZONTAL = 0
	#CLUTTER_FLOW_VERTICAL = 1
EndEnumeration

Enumeration ; BinAlignment
	#CLUTTER_BIN_ALIGNMENT_FIXED = 0
	#CLUTTER_BIN_ALIGNMENT_FILL = 1
	#CLUTTER_BIN_ALIGNMENT_START = 2
	#CLUTTER_BIN_ALIGNMENT_END = 3
	#CLUTTER_BIN_ALIGNMENT_CENTER = 4
EndEnumeration

Enumeration ; TextureError
	#CLUTTER_TEXTURE_ERROR_OUT_OF_MEMORY = 0
	#CLUTTER_TEXTURE_ERROR_NO_YUV = 1
	#CLUTTER_TEXTURE_ERROR_BAD_FORMAT = 2
EndEnumeration

Enumeration ; ScriptError
	#CLUTTER_SCRIPT_ERROR_INVALID_TYPE_FUNCTION = 0
	#CLUTTER_SCRIPT_ERROR_INVALID_PROPERTY = 1
	#CLUTTER_SCRIPT_ERROR_INVALID_VALUE = 2
EndEnumeration

Enumeration ; InputDeviceType
	#CLUTTER_POINTER_DEVICE = 0
	#CLUTTER_KEYBOARD_DEVICE = 1
	#CLUTTER_EXTENSION_DEVICE = 2
	#CLUTTER_JOYSTICK_DEVICE = 3
	#CLUTTER_TABLET_DEVICE = 4
	#CLUTTER_TOUCHPAD_DEVICE = 5
	#CLUTTER_TOUCHSCREEN_DEVICE = 6
	#CLUTTER_PEN_DEVICE = 7
	#CLUTTER_ERASER_DEVICE = 8
	#CLUTTER_CURSOR_DEVICE = 9
	#CLUTTER_N_DEVICE_TYPES = 10
EndEnumeration

Enumeration ; ShaderType
	#CLUTTER_VERTEX_SHADER = 0
	#CLUTTER_FRAGMENT_SHADER = 1
EndEnumeration

Enumeration ; BindCoordinate
	#CLUTTER_BIND_X = 0
	#CLUTTER_BIND_Y = 1
	#CLUTTER_BIND_WIDTH = 2
	#CLUTTER_BIND_HEIGHT = 3
	#CLUTTER_BIND_POSITION = 4
	#CLUTTER_BIND_SIZE = 5
EndEnumeration

CompilerIf Defined(ClutterActionClass, #PB_Structure)
CompilerElse
Structure ClutterActionClass
	*parent_class
	*_clutter_action1
	*_clutter_action2
	*_clutter_action3
	*_clutter_action4
	*_clutter_action5
	*_clutter_action6
	*_clutter_action7
	*_clutter_action8
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterActorBox, #PB_Structure)
CompilerElse
Structure ClutterActorBox
	x1.f
	y1.f
	x2.f
	y2.f
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterActorClass, #PB_Structure)
CompilerElse
Structure ClutterActorClass
	*parent_class
	*show
	*show_all
	*hide
	*hide_all
	*realize
	*unrealize
	*map
	*unmap
	*paint
	*parent_set
	*destroy
	*pick
	*queue_redraw
	*get_preferred_width
	*get_preferred_height
	*allocate
	*apply_transform
	*event
	*button_press_event
	*button_release_event
	*scroll_event
	*key_press_event
	*key_release_event
	*motion_event
	*enter_event
	*leave_event
	*captured_event
	*key_focus_in
	*key_focus_out
	*queue_relayout
	*get_accessible
	*get_paint_volume
	*_padding_dummy[29]
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterActorMetaClass, #PB_Structure)
CompilerElse
Structure ClutterActorMetaClass
	*parent_class
	*set_actor
	*_clutter_meta1
	*_clutter_meta2
	*_clutter_meta3
	*_clutter_meta4
	*_clutter_meta5
	*_clutter_meta6
	*_clutter_meta7
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterActorMetaPrivate, #PB_Structure)
CompilerElse
Structure ClutterActorMetaPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterActorPrivate, #PB_Structure)
CompilerElse
Structure ClutterActorPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterAlignConstraintClass, #PB_Structure)
CompilerElse
Structure ClutterAlignConstraintClass
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterAlphaClass, #PB_Structure)
CompilerElse
Structure ClutterAlphaClass
	*parent_class
	*_clutter_alpha_1
	*_clutter_alpha_2
	*_clutter_alpha_3
	*_clutter_alpha_4
	*_clutter_alpha_5
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterAlphaPrivate, #PB_Structure)
CompilerElse
Structure ClutterAlphaPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterAnimatableIface, #PB_Structure)
CompilerElse
Structure ClutterAnimatableIface
	*parent_iface
	*animate_property
	*find_property
	*get_initial_state
	*set_final_state
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterAnimationClass, #PB_Structure)
CompilerElse
Structure ClutterAnimationClass
	*parent_class
	*started
	*completed
	*_clutter_reserved1
	*_clutter_reserved2
	*_clutter_reserved3
	*_clutter_reserved4
	*_clutter_reserved5
	*_clutter_reserved6
	*_clutter_reserved7
	*_clutter_reserved8
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterAnimationPrivate, #PB_Structure)
CompilerElse
Structure ClutterAnimationPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterAnimatorClass, #PB_Structure)
CompilerElse
Structure ClutterAnimatorClass
	*parent_class
	*_padding_dummy[16]
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterAnimatorKey, #PB_Structure)
CompilerElse
Structure ClutterAnimatorKey
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterAnimatorPrivate, #PB_Structure)
CompilerElse
Structure ClutterAnimatorPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterAnyEvent, #PB_Structure)
CompilerElse
Structure ClutterAnyEvent
	type.l
	time.l
	*flags
	*stage
	*source
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBackendClass, #PB_Structure)
CompilerElse
Structure ClutterBackendClass
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBehaviourClass, #PB_Structure)
CompilerElse
Structure ClutterBehaviourClass
	*parent_class
	*alpha_notify
	*applied
	*removed
	*_clutter_behaviour1
	*_clutter_behaviour2
	*_clutter_behaviour3
	*_clutter_behaviour4
	*_clutter_behaviour5
	*_clutter_behaviour6
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBehaviourDepthClass, #PB_Structure)
CompilerElse
Structure ClutterBehaviourDepthClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBehaviourDepthPrivate, #PB_Structure)
CompilerElse
Structure ClutterBehaviourDepthPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBehaviourEllipseClass, #PB_Structure)
CompilerElse
Structure ClutterBehaviourEllipseClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBehaviourEllipsePrivate, #PB_Structure)
CompilerElse
Structure ClutterBehaviourEllipsePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBehaviourOpacityClass, #PB_Structure)
CompilerElse
Structure ClutterBehaviourOpacityClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBehaviourOpacityPrivate, #PB_Structure)
CompilerElse
Structure ClutterBehaviourOpacityPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBehaviourPathClass, #PB_Structure)
CompilerElse
Structure ClutterBehaviourPathClass
	*parent_class
	*knot_reached
	*_clutter_path_1
	*_clutter_path_2
	*_clutter_path_3
	*_clutter_path_4
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBehaviourPathPrivate, #PB_Structure)
CompilerElse
Structure ClutterBehaviourPathPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBehaviourPrivate, #PB_Structure)
CompilerElse
Structure ClutterBehaviourPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBehaviourRotateClass, #PB_Structure)
CompilerElse
Structure ClutterBehaviourRotateClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBehaviourRotatePrivate, #PB_Structure)
CompilerElse
Structure ClutterBehaviourRotatePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBehaviourScaleClass, #PB_Structure)
CompilerElse
Structure ClutterBehaviourScaleClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBehaviourScalePrivate, #PB_Structure)
CompilerElse
Structure ClutterBehaviourScalePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBinLayoutClass, #PB_Structure)
CompilerElse
Structure ClutterBinLayoutClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBinLayoutPrivate, #PB_Structure)
CompilerElse
Structure ClutterBinLayoutPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBindConstraintClass, #PB_Structure)
CompilerElse
Structure ClutterBindConstraintClass
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBindingPoolClass, #PB_Structure)
CompilerElse
Structure ClutterBindingPoolClass
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBlurEffectClass, #PB_Structure)
CompilerElse
Structure ClutterBlurEffectClass
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBoxClass, #PB_Structure)
CompilerElse
Structure ClutterBoxClass
	*parent_class
	*clutter_padding_1
	*clutter_padding_2
	*clutter_padding_3
	*clutter_padding_4
	*clutter_padding_5
	*clutter_padding_6
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBoxLayoutClass, #PB_Structure)
CompilerElse
Structure ClutterBoxLayoutClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBoxLayoutPrivate, #PB_Structure)
CompilerElse
Structure ClutterBoxLayoutPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterBoxPrivate, #PB_Structure)
CompilerElse
Structure ClutterBoxPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterButtonEvent, #PB_Structure)
CompilerElse
Structure ClutterButtonEvent
	type.l
	time.l
	*flags
	*stage
	*source
	x.f
	y.f
	*modifier_state
	button.l
	click_count.l
	axes.d
	*device
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterCairoTextureClass, #PB_Structure)
CompilerElse
Structure ClutterCairoTextureClass
	*parent_class
	*create_surface
	*_clutter_cairo_2
	*_clutter_cairo_3
	*_clutter_cairo_4
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterCairoTexturePrivate, #PB_Structure)
CompilerElse
Structure ClutterCairoTexturePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterChildMetaClass, #PB_Structure)
CompilerElse
Structure ClutterChildMetaClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterClickActionClass, #PB_Structure)
CompilerElse
Structure ClutterClickActionClass
	*parent_class
	*clicked
	*_clutter_click_action1
	*_clutter_click_action2
	*_clutter_click_action3
	*_clutter_click_action4
	*_clutter_click_action5
	*_clutter_click_action6
	*_clutter_click_action7
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterClickActionPrivate, #PB_Structure)
CompilerElse
Structure ClutterClickActionPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterCloneClass, #PB_Structure)
CompilerElse
Structure ClutterCloneClass
	*parent_class
	*_clutter_actor_clone1
	*_clutter_actor_clone2
	*_clutter_actor_clone3
	*_clutter_actor_clone4
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterClonePrivate, #PB_Structure)
CompilerElse
Structure ClutterClonePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterColor, #PB_Structure)
CompilerElse
Structure ClutterColor
	red.a
	green.a
	blue.a
	alpha.a
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterColorizeEffectClass, #PB_Structure)
CompilerElse
Structure ClutterColorizeEffectClass
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterConstraintClass, #PB_Structure)
CompilerElse
Structure ClutterConstraintClass
	*parent_class
	*update_allocation
	*_clutter_constraint1
	*_clutter_constraint2
	*_clutter_constraint3
	*_clutter_constraint4
	*_clutter_constraint5
	*_clutter_constraint6
	*_clutter_constraint7
	*_clutter_constraint8
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterContainerIface, #PB_Structure)
CompilerElse
Structure ClutterContainerIface
	*g_iface
	*add
	*remove
	*foreach
	*foreach_with_internals
	*raise
	*lower
	*sort_depth_order
	*child_meta_type
	*create_child_meta
	*destroy_child_meta
	*get_child_meta
	*actor_added
	*actor_removed
	*child_notify
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterCrossingEvent, #PB_Structure)
CompilerElse
Structure ClutterCrossingEvent
	type.l
	time.l
	*flags
	*stage
	*source
	x.f
	y.f
	*device
	*related
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterDeformEffectClass, #PB_Structure)
CompilerElse
Structure ClutterDeformEffectClass
	*parent_class
	*deform_vertex
	*_clutter_deform1
	*_clutter_deform2
	*_clutter_deform3
	*_clutter_deform4
	*_clutter_deform5
	*_clutter_deform6
	*_clutter_deform7
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterDeformEffectPrivate, #PB_Structure)
CompilerElse
Structure ClutterDeformEffectPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterDesaturateEffectClass, #PB_Structure)
CompilerElse
Structure ClutterDesaturateEffectClass
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterDeviceManagerClass, #PB_Structure)
CompilerElse
Structure ClutterDeviceManagerClass
	*parent_class
	*get_devices
	*get_core_device
	*get_device
	*add_device
	*remove_device
	*_padding[8]
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterDeviceManagerPrivate, #PB_Structure)
CompilerElse
Structure ClutterDeviceManagerPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterDragActionClass, #PB_Structure)
CompilerElse
Structure ClutterDragActionClass
	*parent_class
	*drag_begin
	*drag_motion
	*drag_end
	*_clutter_drag_action1
	*_clutter_drag_action2
	*_clutter_drag_action3
	*_clutter_drag_action4
	*_clutter_drag_action5
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterDragActionPrivate, #PB_Structure)
CompilerElse
Structure ClutterDragActionPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterEffectClass, #PB_Structure)
CompilerElse
Structure ClutterEffectClass
	*parent_class
	*pre_paint
	*post_paint
	*get_paint_volume
	*_clutter_effect2
	*_clutter_effect3
	*_clutter_effect4
	*_clutter_effect5
	*_clutter_effect6
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterFixedLayoutClass, #PB_Structure)
CompilerElse
Structure ClutterFixedLayoutClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterFlowLayoutClass, #PB_Structure)
CompilerElse
Structure ClutterFlowLayoutClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterFlowLayoutPrivate, #PB_Structure)
CompilerElse
Structure ClutterFlowLayoutPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterFog, #PB_Structure)
CompilerElse
Structure ClutterFog
	z_near.f
	z_far.f
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterGeometry, #PB_Structure)
CompilerElse
Structure ClutterGeometry
	x.l
	y.l
	width.l
	height.l
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterGroupClass, #PB_Structure)
CompilerElse
Structure ClutterGroupClass
	*parent_class
	*_clutter_reserved1
	*_clutter_reserved2
	*_clutter_reserved3
	*_clutter_reserved4
	*_clutter_reserved5
	*_clutter_reserved6
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterGroupPrivate, #PB_Structure)
CompilerElse
Structure ClutterGroupPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterInputDeviceClass, #PB_Structure)
CompilerElse
Structure ClutterInputDeviceClass
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterIntervalClass, #PB_Structure)
CompilerElse
Structure ClutterIntervalClass
	*parent_class
	*validate
	*compute_value
	*_clutter_reserved1
	*_clutter_reserved2
	*_clutter_reserved3
	*_clutter_reserved4
	*_clutter_reserved5
	*_clutter_reserved6
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterIntervalPrivate, #PB_Structure)
CompilerElse
Structure ClutterIntervalPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterKeyEvent, #PB_Structure)
CompilerElse
Structure ClutterKeyEvent
	type.l
	time.l
	*flags
	*stage
	*source
	*modifier_state
	keyval.l
	hardware_keycode.u
	*unicode_value
	*device
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterKnot, #PB_Structure)
CompilerElse
Structure ClutterKnot
	x.l
	y.l
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterLayoutManagerClass, #PB_Structure)
CompilerElse
Structure ClutterLayoutManagerClass
	*parent_class
	*get_preferred_width
	*get_preferred_height
	*allocate
	*set_container
	*get_child_meta_type
	*create_child_meta
	*begin_animation
	*get_animation_progress
	*end_animation
	*layout_changed
	*_clutter_padding_1
	*_clutter_padding_2
	*_clutter_padding_3
	*_clutter_padding_4
	*_clutter_padding_5
	*_clutter_padding_6
	*_clutter_padding_7
	*_clutter_padding_8
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterLayoutMetaClass, #PB_Structure)
CompilerElse
Structure ClutterLayoutMetaClass
	*parent_class
	*_clutter_padding1
	*_clutter_padding2
	*_clutter_padding3
	*_clutter_padding4
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterListModelClass, #PB_Structure)
CompilerElse
Structure ClutterListModelClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterListModelPrivate, #PB_Structure)
CompilerElse
Structure ClutterListModelPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterMediaIface, #PB_Structure)
CompilerElse
Structure ClutterMediaIface
	*base_iface
	*eos
	*error
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterModelClass, #PB_Structure)
CompilerElse
Structure ClutterModelClass
	*parent_class
	*get_n_rows
	*get_n_columns
	*get_column_name
	*get_column_type
	*insert_row
	*remove_row
	*get_iter_at_row
	*resort
	*row_added
	*row_removed
	*row_changed
	*sort_changed
	*filter_changed
	*_clutter_model_1
	*_clutter_model_2
	*_clutter_model_3
	*_clutter_model_4
	*_clutter_model_5
	*_clutter_model_6
	*_clutter_model_7
	*_clutter_model_8
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterModelIterClass, #PB_Structure)
CompilerElse
Structure ClutterModelIterClass
	*parent_class
	*get_value
	*set_value
	*is_first
	*is_last
	*next
	*prev
	*get_model
	*get_row
	*copy
	*_clutter_model_iter_1
	*_clutter_model_iter_2
	*_clutter_model_iter_3
	*_clutter_model_iter_4
	*_clutter_model_iter_5
	*_clutter_model_iter_6
	*_clutter_model_iter_7
	*_clutter_model_iter_8
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterModelIterPrivate, #PB_Structure)
CompilerElse
Structure ClutterModelIterPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterModelPrivate, #PB_Structure)
CompilerElse
Structure ClutterModelPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterMotionEvent, #PB_Structure)
CompilerElse
Structure ClutterMotionEvent
	type.l
	time.l
	*flags
	*stage
	*source
	x.f
	y.f
	*modifier_state
	axes.d
	*device
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterOffscreenEffectClass, #PB_Structure)
CompilerElse
Structure ClutterOffscreenEffectClass
	*parent_class
	*create_texture
	*paint_target
	*_clutter_offscreen1
	*_clutter_offscreen2
	*_clutter_offscreen3
	*_clutter_offscreen4
	*_clutter_offscreen5
	*_clutter_offscreen6
	*_clutter_offscreen7
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterOffscreenEffectPrivate, #PB_Structure)
CompilerElse
Structure ClutterOffscreenEffectPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterPageTurnEffectClass, #PB_Structure)
CompilerElse
Structure ClutterPageTurnEffectClass
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterPaintVolume, #PB_Structure)
CompilerElse
Structure ClutterPaintVolume
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterParamSpecUnits, #PB_Structure)
CompilerElse
Structure ClutterParamSpecUnits
	*parent_instance
	default_type.l
	default_value.f
	minimum.f
	maximum.f
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterPathClass, #PB_Structure)
CompilerElse
Structure ClutterPathClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterPathConstraintClass, #PB_Structure)
CompilerElse
Structure ClutterPathConstraintClass
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterPathNode, #PB_Structure)
CompilerElse
Structure ClutterPathNode
	type.l
	*points[3]
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterPathPrivate, #PB_Structure)
CompilerElse
Structure ClutterPathPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterPerspective, #PB_Structure)
CompilerElse
Structure ClutterPerspective
	fovy.f
	aspect.f
	z_near.f
	z_far.f
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterRectangleClass, #PB_Structure)
CompilerElse
Structure ClutterRectangleClass
	*parent_class
	*_clutter_rectangle1
	*_clutter_rectangle2
	*_clutter_rectangle3
	*_clutter_rectangle4
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterRectanglePrivate, #PB_Structure)
CompilerElse
Structure ClutterRectanglePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterScoreClass, #PB_Structure)
CompilerElse
Structure ClutterScoreClass
	*parent_class
	*timeline_started
	*timeline_completed
	*started
	*completed
	*paused
	*_clutter_score_1
	*_clutter_score_2
	*_clutter_score_3
	*_clutter_score_4
	*_clutter_score_5
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterScorePrivate, #PB_Structure)
CompilerElse
Structure ClutterScorePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterScriptClass, #PB_Structure)
CompilerElse
Structure ClutterScriptClass
	*parent_class
	*get_type_from_name
	*_clutter_reserved1
	*_clutter_reserved2
	*_clutter_reserved3
	*_clutter_reserved4
	*_clutter_reserved5
	*_clutter_reserved6
	*_clutter_reserved7
	*_clutter_reserved8
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterScriptPrivate, #PB_Structure)
CompilerElse
Structure ClutterScriptPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterScriptableIface, #PB_Structure)
CompilerElse
Structure ClutterScriptableIface
	*g_iface
	*set_id
	*get_id
	*parse_custom_node
	*set_custom_property
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterScrollEvent, #PB_Structure)
CompilerElse
Structure ClutterScrollEvent
	type.l
	time.l
	*flags
	*stage
	*source
	x.f
	y.f
	direction.l
	*modifier_state
	axes.d
	*device
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterSettingsClass, #PB_Structure)
CompilerElse
Structure ClutterSettingsClass
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterShaderClass, #PB_Structure)
CompilerElse
Structure ClutterShaderClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterShaderEffectClass, #PB_Structure)
CompilerElse
Structure ClutterShaderEffectClass
	*parent_class
	*_clutter_shader1
	*_clutter_shader2
	*_clutter_shader3
	*_clutter_shader4
	*_clutter_shader5
	*_clutter_shader6
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterShaderEffectPrivate, #PB_Structure)
CompilerElse
Structure ClutterShaderEffectPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterShaderFloat, #PB_Structure)
CompilerElse
Structure ClutterShaderFloat
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterShaderInt, #PB_Structure)
CompilerElse
Structure ClutterShaderInt
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterShaderMatrix, #PB_Structure)
CompilerElse
Structure ClutterShaderMatrix
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterShaderPrivate, #PB_Structure)
CompilerElse
Structure ClutterShaderPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterSnapConstraintClass, #PB_Structure)
CompilerElse
Structure ClutterSnapConstraintClass
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterStageClass, #PB_Structure)
CompilerElse
Structure ClutterStageClass
	*parent_class
	*fullscreen
	*unfullscreen
	*activate
	*deactivate
	*delete_event
	*_padding_dummy[31]
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterStageManagerClass, #PB_Structure)
CompilerElse
Structure ClutterStageManagerClass
	*parent_class
	*stage_added
	*stage_removed
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterStagePrivate, #PB_Structure)
CompilerElse
Structure ClutterStagePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterStageStateEvent, #PB_Structure)
CompilerElse
Structure ClutterStageStateEvent
	type.l
	time.l
	*flags
	*stage
	*source
	*changed_mask
	*new_state
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterStageWindowIface, #PB_Structure)
CompilerElse
Structure ClutterStageWindowIface
	*parent_iface
	*get_wrapper
	*set_title
	*set_fullscreen
	*set_cursor_visible
	*set_user_resizable
	*realize
	*unrealize
	*show
	*hide
	*resize
	*get_geometry
	*get_pending_swaps
	*add_redraw_clip
	*has_redraw_clips
	*ignoring_redraw_clips
	*set_accept_focus
	*redraw
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterStateClass, #PB_Structure)
CompilerElse
Structure ClutterStateClass
	*parent_class
	*completed
	*_padding_dummy[8]
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterStateKey, #PB_Structure)
CompilerElse
Structure ClutterStateKey
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterStatePrivate, #PB_Structure)
CompilerElse
Structure ClutterStatePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterTableLayoutClass, #PB_Structure)
CompilerElse
Structure ClutterTableLayoutClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterTableLayoutPrivate, #PB_Structure)
CompilerElse
Structure ClutterTableLayoutPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterTextClass, #PB_Structure)
CompilerElse
Structure ClutterTextClass
	*parent_class
	*text_changed
	*activate
	*cursor_event
	*_clutter_reserved1
	*_clutter_reserved2
	*_clutter_reserved3
	*_clutter_reserved4
	*_clutter_reserved5
	*_clutter_reserved6
	*_clutter_reserved7
	*_clutter_reserved8
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterTextPrivate, #PB_Structure)
CompilerElse
Structure ClutterTextPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterTextureClass, #PB_Structure)
CompilerElse
Structure ClutterTextureClass
	*parent_class
	*size_change
	*pixbuf_change
	*load_finished
	*_clutter_texture1
	*_clutter_texture2
	*_clutter_texture3
	*_clutter_texture4
	*_clutter_texture5
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterTexturePrivate, #PB_Structure)
CompilerElse
Structure ClutterTexturePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterTimelineClass, #PB_Structure)
CompilerElse
Structure ClutterTimelineClass
	*parent_class
	*started
	*completed
	*paused
	*new_frame
	*marker_reached
	*_clutter_timeline_1
	*_clutter_timeline_2
	*_clutter_timeline_3
	*_clutter_timeline_4
	*_clutter_timeline_5
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterTimelinePrivate, #PB_Structure)
CompilerElse
Structure ClutterTimelinePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterTimeoutPool, #PB_Structure)
CompilerElse
Structure ClutterTimeoutPool
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterUnits, #PB_Structure)
CompilerElse
Structure ClutterUnits
	unit_type.l
	value.f
	pixels.f
	pixels_set.l
	serial.l
	__padding_1.l
	__padding_2.q
EndStructure
CompilerEndIf

CompilerIf Defined(ClutterVertex, #PB_Structure)
CompilerElse
Structure ClutterVertex
	x.f
	y.f
	z.f
EndStructure
CompilerEndIf
ImportC "/usr/lib/libclutter-glx-1.0.so.0"
	clutter_actor_add_action(*actor, *action)
	clutter_actor_add_action_with_name(*actor, name.p-utf8, *action)
	clutter_actor_add_constraint(*actor, *constraint)
	clutter_actor_add_constraint_with_name(*actor, name.p-utf8, *constraint)
	clutter_actor_add_effect(*actor, *effect)
	clutter_actor_add_effect_with_name(*actor, name.p-utf8, *effect)
	clutter_actor_allocate(*actor, *box, *flags)
	clutter_actor_allocate_align_fill(*actor, *box, x_align.d, y_align.d, x_fill.l, y_fill.l, *flags)
	clutter_actor_allocate_available_size(*actor, x.f, y.f, available_width.f, available_height.f, *flags)
	clutter_actor_allocate_preferred_size(*actor, *flags)
	clutter_actor_animate.i(*actor, mode.i, duration.l, first_property_name.p-utf8, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_actor_animate_with_alpha.i(*actor, *alpha, first_property_name.p-utf8, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_actor_animate_with_alphav.i(*actor, *alpha, n_properties.l, properties.p-utf8, *values)
	clutter_actor_animate_with_timeline.i(*actor, mode.i, *timeline, first_property_name.p-utf8, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_actor_animate_with_timelinev.i(*actor, mode.i, *timeline, n_properties.l, properties.p-utf8, *values)
	clutter_actor_animatev.i(*actor, mode.i, duration.l, n_properties.l, properties.p-utf8, *values)
	clutter_actor_apply_relative_transform_to_point(*actor, *ancestor, *point, *vertex)
	clutter_actor_apply_transform_to_point(*actor, *point, *vertex)
	clutter_actor_clear_actions(*actor)
	clutter_actor_clear_constraints(*actor)
	clutter_actor_clear_effects(*actor)
	clutter_actor_contains.l(*actor, *descendant)
	clutter_actor_create_pango_context.i(*actor)
	clutter_actor_create_pango_layout.i(*actor, text.p-utf8)
	clutter_actor_destroy(*actor)
	clutter_actor_detach_animation(*actor)
	clutter_actor_event.l(*actor, *event, capture.l)
	clutter_actor_get_abs_allocation_vertices(*actor, *verts)
	clutter_actor_get_accessible.i(*actor)
	clutter_actor_get_action.i(*actor, name.p-utf8)
	clutter_actor_get_actions.i(*actor)
	clutter_actor_get_allocation_box(*actor, *box)
	clutter_actor_get_allocation_geometry(*actor, *geom)
	clutter_actor_get_allocation_vertices(*actor, *ancestor, *verts)
	clutter_actor_get_anchor_point(*actor, anchor_x.f, anchor_y.f)
	clutter_actor_get_anchor_point_gravity.l(*actor)
	clutter_actor_get_animation.i(*actor)
	clutter_actor_get_clip(*actor, xoff.f, yoff.f, width.f, height.f)
	clutter_actor_get_clip_to_allocation.l(*actor)
	clutter_actor_get_constraint.i(*actor, name.p-utf8)
	clutter_actor_get_constraints.i(*actor)
	clutter_actor_get_depth.f(*actor)
	clutter_actor_get_effect.i(*actor, name.p-utf8)
	clutter_actor_get_effects.i(*actor)
	clutter_actor_get_fixed_position_set.l(*actor)
	clutter_actor_get_flags.i(*actor)
	clutter_actor_get_geometry(*actor, *geometry)
	clutter_actor_get_gid.l(*actor)
	clutter_actor_get_height.f(*actor)
	clutter_actor_get_name.i(*actor)
	clutter_actor_get_opacity.a(*actor)
	clutter_actor_get_paint_box.l(*actor, *box)
	clutter_actor_get_paint_opacity.a(*actor)
	clutter_actor_get_paint_visibility.l(*actor)
	clutter_actor_get_paint_volume.i(*actor)
	clutter_actor_get_pango_context.i(*actor)
	clutter_actor_get_parent.i(*actor)
	clutter_actor_get_position(*actor, x.f, y.f)
	clutter_actor_get_preferred_height(*actor, for_width.f, min_height_p.f, natural_height_p.f)
	clutter_actor_get_preferred_size(*actor, min_width_p.f, min_height_p.f, natural_width_p.f, natural_height_p.f)
	clutter_actor_get_preferred_width(*actor, for_height.f, min_width_p.f, natural_width_p.f)
	clutter_actor_get_reactive.l(*actor)
	clutter_actor_get_request_mode.l(*actor)
	clutter_actor_get_rotation.d(*actor, axis.l, x.f, y.f, z.f)
	clutter_actor_get_scale(*actor, scale_x.d, scale_y.d)
	clutter_actor_get_scale_center(*actor, center_x.f, center_y.f)
	clutter_actor_get_scale_gravity.l(*actor)
	clutter_actor_get_shader.i(*actor)
	clutter_actor_get_size(*actor, width.f, height.f)
	clutter_actor_get_stage.i(*actor)
	clutter_actor_get_text_direction.l(*actor)
	clutter_actor_get_transformation_matrix(*actor, *matrix)
	clutter_actor_get_transformed_paint_volume.i(*actor, *relative_to_ancestor)
	clutter_actor_get_transformed_position(*actor, x.f, y.f)
	clutter_actor_get_transformed_size(*actor, width.f, height.f)
	clutter_actor_get_width.f(*actor)
	clutter_actor_get_x.f(*actor)
	clutter_actor_get_y.f(*actor)
	clutter_actor_get_z_rotation_gravity.l(*actor)
	clutter_actor_grab_key_focus(*actor)
	clutter_actor_has_allocation.l(*actor)
	clutter_actor_has_clip.l(*actor)
	clutter_actor_has_key_focus.l(*actor)
	clutter_actor_has_pointer.l(*actor)
	clutter_actor_hide(*actor)
	clutter_actor_hide_all(*actor)
	clutter_actor_is_in_clone_paint.l(*actor)
	clutter_actor_is_rotated.l(*actor)
	clutter_actor_is_scaled.l(*actor)
	clutter_actor_lower(*actor, *above)
	clutter_actor_lower_bottom(*actor)
	clutter_actor_map(*actor)
	clutter_actor_move_anchor_point(*actor, anchor_x.f, anchor_y.f)
	clutter_actor_move_anchor_point_from_gravity(*actor, gravity.l)
	clutter_actor_move_by(*actor, dx.f, dy.f)
	clutter_actor_paint(*actor)
	clutter_actor_pop_internal(*actor)
	clutter_actor_push_internal(*actor)
	clutter_actor_queue_redraw(*actor)
	clutter_actor_queue_relayout(*actor)
	clutter_actor_raise(*actor, *below)
	clutter_actor_raise_top(*actor)
	clutter_actor_realize(*actor)
	clutter_actor_remove_action(*actor, *action)
	clutter_actor_remove_action_by_name(*actor, name.p-utf8)
	clutter_actor_remove_clip(*actor)
	clutter_actor_remove_constraint(*actor, *constraint)
	clutter_actor_remove_constraint_by_name(*actor, name.p-utf8)
	clutter_actor_remove_effect(*actor, *effect)
	clutter_actor_remove_effect_by_name(*actor, name.p-utf8)
	clutter_actor_reparent(*actor, *new_parent)
	clutter_actor_set_anchor_point(*actor, anchor_x.f, anchor_y.f)
	clutter_actor_set_anchor_point_from_gravity(*actor, gravity.l)
	clutter_actor_set_clip(*actor, xoff.f, yoff.f, width.f, height.f)
	clutter_actor_set_clip_to_allocation(*actor, clip_set.l)
	clutter_actor_set_depth(*actor, depth.f)
	clutter_actor_set_fixed_position_set(*actor, is_set.l)
	clutter_actor_set_flags(*actor, *flags)
	clutter_actor_set_geometry(*actor, *geometry)
	clutter_actor_set_height(*actor, height.f)
	clutter_actor_set_name(*actor, name.p-utf8)
	clutter_actor_set_opacity(*actor, opacity.a)
	clutter_actor_set_parent(*actor, *parent)
	clutter_actor_set_position(*actor, x.f, y.f)
	clutter_actor_set_reactive(*actor, reactive.l)
	clutter_actor_set_request_mode(*actor, mode.l)
	clutter_actor_set_rotation(*actor, axis.l, angle.d, x.f, y.f, z.f)
	clutter_actor_set_scale(*actor, scale_x.d, scale_y.d)
	clutter_actor_set_scale_full(*actor, scale_x.d, scale_y.d, center_x.f, center_y.f)
	clutter_actor_set_scale_with_gravity(*actor, scale_x.d, scale_y.d, gravity.l)
	clutter_actor_set_shader.l(*actor, *shader)
	clutter_actor_set_shader_param(*actor, param.p-utf8, *value)
	clutter_actor_set_shader_param_float(*actor, param.p-utf8, value.f)
	clutter_actor_set_shader_param_int(*actor, param.p-utf8, value.l)
	clutter_actor_set_size(*actor, width.f, height.f)
	clutter_actor_set_text_direction(*actor, text_dir.l)
	clutter_actor_set_width(*actor, width.f)
	clutter_actor_set_x(*actor, x.f)
	clutter_actor_set_y(*actor, y.f)
	clutter_actor_set_z_rotation_from_gravity(*actor, angle.d, gravity.l)
	clutter_actor_should_pick_paint.l(*actor)
	clutter_actor_show(*actor)
	clutter_actor_show_all(*actor)
	clutter_actor_transform_stage_point.l(*actor, x.f, y.f, x_out.f, y_out.f)
	clutter_actor_unmap(*actor)
	clutter_actor_unparent(*actor)
	clutter_actor_unrealize(*actor)
	clutter_actor_unset_flags(*actor, *flags)
	clutter_actor_meta_get_actor.i(*actormeta)
	clutter_actor_meta_get_enabled.l(*actormeta)
	clutter_actor_meta_get_name.i(*actormeta)
	clutter_actor_meta_set_enabled(*actormeta, is_enabled.l)
	clutter_actor_meta_set_name(*actormeta, name.p-utf8)
	clutter_align_constraint_new.i(*source, axis.l, factor.f)
	clutter_align_constraint_get_align_axis.l(*alignconstraint)
	clutter_align_constraint_get_factor.f(*alignconstraint)
	clutter_align_constraint_get_source.i(*alignconstraint)
	clutter_align_constraint_set_align_axis(*alignconstraint, axis.l)
	clutter_align_constraint_set_factor(*alignconstraint, factor.f)
	clutter_align_constraint_set_source(*alignconstraint, *source)
	clutter_alpha_new.i()
	clutter_alpha_new_full.i(*timeline, mode.i)
	clutter_alpha_new_with_func.i(*timeline, *func, *data_, *destroy)
	clutter_alpha_get_alpha.d(*alpha)
	clutter_alpha_get_mode.i(*alpha)
	clutter_alpha_get_timeline.i(*alpha)
	clutter_alpha_set_closure(*alpha, *closure)
	clutter_alpha_set_func(*alpha, *func, *data_, *destroy)
	clutter_alpha_set_mode(*alpha, mode.i)
	clutter_alpha_set_timeline(*alpha, *timeline)
	clutter_animation_new.i()
	clutter_animation_bind.i(*animation, property_name.p-utf8, *final)
	clutter_animation_bind_interval.i(*animation, property_name.p-utf8, *interval)
	clutter_animation_completed(*animation)
	clutter_animation_get_alpha.i(*animation)
	clutter_animation_get_duration.l(*animation)
	clutter_animation_get_interval.i(*animation, property_name.p-utf8)
	clutter_animation_get_loop.l(*animation)
	clutter_animation_get_mode.i(*animation)
	clutter_animation_get_object.i(*animation)
	clutter_animation_get_timeline.i(*animation)
	clutter_animation_has_property.l(*animation, property_name.p-utf8)
	clutter_animation_set_alpha(*animation, *alpha)
	clutter_animation_set_duration(*animation, msecs.l)
	clutter_animation_set_loop(*animation, loop.l)
	clutter_animation_set_mode(*animation, mode.i)
	clutter_animation_set_object(*animation, *object)
	clutter_animation_set_timeline(*animation, *timeline)
	clutter_animation_unbind_property(*animation, property_name.p-utf8)
	clutter_animation_update.i(*animation, property_name.p-utf8, *final)
	clutter_animation_update_interval(*animation, property_name.p-utf8, *interval)
	clutter_animator_new.i()
	clutter_animator_compute_value.l(*animator, *object, property_name.p-utf8, progress.d, *value)
	clutter_animator_get_duration.l(*animator)
	clutter_animator_get_keys.i(*animator, *object, property_name.p-utf8, progress.d)
	clutter_animator_get_timeline.i(*animator)
	clutter_animator_property_get_ease_in.l(*animator, *object, property_name.p-utf8)
	clutter_animator_property_get_interpolation.l(*animator, *object, property_name.p-utf8)
	clutter_animator_property_set_ease_in(*animator, *object, property_name.p-utf8, ease_in.l)
	clutter_animator_property_set_interpolation(*animator, *object, property_name.p-utf8, interpolation.l)
	clutter_animator_remove_key(*animator, *object, property_name.p-utf8, progress.d)
	clutter_animator_set(*animator, *first_object, first_property_name.p-utf8, first_mode.l, first_progress.d, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_animator_set_duration(*animator, duration.l)
	clutter_animator_set_key.i(*animator, *object, property_name.p-utf8, mode.l, progress.d, *value)
	clutter_animator_set_timeline(*animator, *timeline)
	clutter_animator_start.i(*animator)
	clutter_backend_get_double_click_distance.l(*backend)
	clutter_backend_get_double_click_time.l(*backend)
	clutter_backend_get_font_name.i(*backend)
	clutter_backend_get_font_options.i(*backend)
	clutter_backend_get_resolution.d(*backend)
	clutter_backend_set_double_click_distance(*backend, distance.l)
	clutter_backend_set_double_click_time(*backend, msec.l)
	clutter_backend_set_font_name(*backend, font_name.p-utf8)
	clutter_backend_set_font_options(*backend, *options)
	clutter_backend_set_resolution(*backend, dpi.d)
	clutter_behaviour_actors_foreach(*behaviour, *func, *data_)
	clutter_behaviour_apply(*behaviour, *actor)
	clutter_behaviour_get_actors.i(*behaviour)
	clutter_behaviour_get_alpha.i(*behaviour)
	clutter_behaviour_get_n_actors.l(*behaviour)
	clutter_behaviour_get_nth_actor.i(*behaviour, index_.l)
	clutter_behaviour_is_applied.l(*behaviour, *actor)
	clutter_behaviour_remove(*behaviour, *actor)
	clutter_behaviour_remove_all(*behaviour)
	clutter_behaviour_set_alpha(*behaviour, *alpha)
	clutter_behaviour_depth_new.i(*alpha, depth_start.l, depth_end.l)
	clutter_behaviour_depth_get_bounds(*behaviourdepth, depth_start.l, depth_end.l)
	clutter_behaviour_depth_set_bounds(*behaviourdepth, depth_start.l, depth_end.l)
	clutter_behaviour_ellipse_new.i(*alpha, x.l, y.l, width.l, height.l, direction.l, start.d, end_.d)
	clutter_behaviour_ellipse_get_angle_end.d(*behaviourellipse)
	clutter_behaviour_ellipse_get_angle_start.d(*behaviourellipse)
	clutter_behaviour_ellipse_get_angle_tilt.d(*behaviourellipse, axis.l)
	clutter_behaviour_ellipse_get_center(*behaviourellipse, x.l, y.l)
	clutter_behaviour_ellipse_get_direction.l(*behaviourellipse)
	clutter_behaviour_ellipse_get_height.l(*behaviourellipse)
	clutter_behaviour_ellipse_get_tilt(*behaviourellipse, angle_tilt_x.d, angle_tilt_y.d, angle_tilt_z.d)
	clutter_behaviour_ellipse_get_width.l(*behaviourellipse)
	clutter_behaviour_ellipse_set_angle_end(*behaviourellipse, angle_end.d)
	clutter_behaviour_ellipse_set_angle_start(*behaviourellipse, angle_start.d)
	clutter_behaviour_ellipse_set_angle_tilt(*behaviourellipse, axis.l, angle_tilt.d)
	clutter_behaviour_ellipse_set_center(*behaviourellipse, x.l, y.l)
	clutter_behaviour_ellipse_set_direction(*behaviourellipse, direction.l)
	clutter_behaviour_ellipse_set_height(*behaviourellipse, height.l)
	clutter_behaviour_ellipse_set_tilt(*behaviourellipse, angle_tilt_x.d, angle_tilt_y.d, angle_tilt_z.d)
	clutter_behaviour_ellipse_set_width(*behaviourellipse, width.l)
	clutter_behaviour_opacity_new.i(*alpha, opacity_start.a, opacity_end.a)
	clutter_behaviour_opacity_get_bounds(*behaviouropacity, opacity_start.a, opacity_end.a)
	clutter_behaviour_opacity_set_bounds(*behaviouropacity, opacity_start.a, opacity_end.a)
	clutter_behaviour_path_new.i(*alpha, *path)
	clutter_behaviour_path_new_with_description.i(*alpha, desc.p-utf8)
	clutter_behaviour_path_new_with_knots.i(*alpha, *knots, n_knots.l)
	clutter_behaviour_path_get_path.i(*behaviourpath)
	clutter_behaviour_path_set_path(*behaviourpath, *path)
	clutter_behaviour_rotate_new.i(*alpha, axis.l, direction.l, angle_start.d, angle_end.d)
	clutter_behaviour_rotate_get_axis.l(*behaviourrotate)
	clutter_behaviour_rotate_get_bounds(*behaviourrotate, angle_start.d, angle_end.d)
	clutter_behaviour_rotate_get_center(*behaviourrotate, x.l, y.l, z.l)
	clutter_behaviour_rotate_get_direction.l(*behaviourrotate)
	clutter_behaviour_rotate_set_axis(*behaviourrotate, axis.l)
	clutter_behaviour_rotate_set_bounds(*behaviourrotate, angle_start.d, angle_end.d)
	clutter_behaviour_rotate_set_center(*behaviourrotate, x.l, y.l, z.l)
	clutter_behaviour_rotate_set_direction(*behaviourrotate, direction.l)
	clutter_behaviour_scale_new.i(*alpha, x_scale_start.d, y_scale_start.d, x_scale_end.d, y_scale_end.d)
	clutter_behaviour_scale_get_bounds(*behaviourscale, x_scale_start.d, y_scale_start.d, x_scale_end.d, y_scale_end.d)
	clutter_behaviour_scale_set_bounds(*behaviourscale, x_scale_start.d, y_scale_start.d, x_scale_end.d, y_scale_end.d)
	clutter_bin_layout_new.i(x_align.l, y_align.l)
	clutter_bin_layout_add(*binlayout, *child, x_align.l, y_align.l)
	clutter_bin_layout_get_alignment(*binlayout, *child, x_align.l, y_align.l)
	clutter_bin_layout_set_alignment(*binlayout, *child, x_align.l, y_align.l)
	clutter_bind_constraint_new.i(*source, coordinate.l, offset.f)
	clutter_bind_constraint_get_coordinate.l(*bindconstraint)
	clutter_bind_constraint_get_offset.f(*bindconstraint)
	clutter_bind_constraint_get_source.i(*bindconstraint)
	clutter_bind_constraint_set_coordinate(*bindconstraint, coordinate.l)
	clutter_bind_constraint_set_offset(*bindconstraint, offset.f)
	clutter_bind_constraint_set_source(*bindconstraint, *source)
	clutter_binding_pool_new.i(name.p-utf8)
	clutter_binding_pool_activate.l(*bindingpool, key_val.l, *modifiers, *gobject)
	clutter_binding_pool_block_action(*bindingpool, action_name.p-utf8)
	clutter_binding_pool_find_action.i(*bindingpool, key_val.l, *modifiers)
	clutter_binding_pool_install_action(*bindingpool, action_name.p-utf8, key_val.l, *modifiers, *callback, *data_, *notify)
	clutter_binding_pool_install_closure(*bindingpool, action_name.p-utf8, key_val.l, *modifiers, *closure)
	clutter_binding_pool_override_action(*bindingpool, key_val.l, *modifiers, *callback, *data_, *notify)
	clutter_binding_pool_override_closure(*bindingpool, key_val.l, *modifiers, *closure)
	clutter_binding_pool_remove_action(*bindingpool, key_val.l, *modifiers)
	clutter_binding_pool_unblock_action(*bindingpool, action_name.p-utf8)
	clutter_blur_effect_new.i()
	clutter_box_new.i(*manager)
	clutter_box_get_color(*box, *color)
	clutter_box_get_layout_manager.i(*box)
	clutter_box_pack(*box, *actor, first_property.p-utf8, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_box_pack_after(*box, *actor, *sibling, first_property.p-utf8, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_box_pack_at(*box, *actor, position.l, first_property.p-utf8, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_box_pack_before(*box, *actor, *sibling, first_property.p-utf8, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_box_packv(*box, *actor, n_properties.l, properties.p-utf8, *values)
	clutter_box_set_color(*box, *color)
	clutter_box_set_layout_manager(*box, *manager)
	clutter_box_layout_new.i()
	clutter_box_layout_get_alignment(*boxlayout, *actor, x_align.l, y_align.l)
	clutter_box_layout_get_easing_duration.l(*boxlayout)
	clutter_box_layout_get_easing_mode.i(*boxlayout)
	clutter_box_layout_get_expand.l(*boxlayout, *actor)
	clutter_box_layout_get_fill(*boxlayout, *actor, x_fill.l, y_fill.l)
	clutter_box_layout_get_homogeneous.l(*boxlayout)
	clutter_box_layout_get_pack_start.l(*boxlayout)
	clutter_box_layout_get_spacing.l(*boxlayout)
	clutter_box_layout_get_use_animations.l(*boxlayout)
	clutter_box_layout_get_vertical.l(*boxlayout)
	clutter_box_layout_pack(*boxlayout, *actor, expand.l, x_fill.l, y_fill.l, x_align.l, y_align.l)
	clutter_box_layout_set_alignment(*boxlayout, *actor, x_align.l, y_align.l)
	clutter_box_layout_set_easing_duration(*boxlayout, msecs.l)
	clutter_box_layout_set_easing_mode(*boxlayout, mode.i)
	clutter_box_layout_set_expand(*boxlayout, *actor, expand.l)
	clutter_box_layout_set_fill(*boxlayout, *actor, x_fill.l, y_fill.l)
	clutter_box_layout_set_homogeneous(*boxlayout, homogeneous.l)
	clutter_box_layout_set_pack_start(*boxlayout, pack_start.l)
	clutter_box_layout_set_spacing(*boxlayout, spacing.l)
	clutter_box_layout_set_use_animations(*boxlayout, animate.l)
	clutter_box_layout_set_vertical(*boxlayout, vertical.l)
	clutter_cairo_texture_new.i(width.l, height.l)
	clutter_cairo_texture_clear(*cairotexture)
	clutter_cairo_texture_create.i(*cairotexture)
	clutter_cairo_texture_create_region.i(*cairotexture, x_offset.l, y_offset.l, width.l, height.l)
	clutter_cairo_texture_get_surface_size(*cairotexture, width.l, height.l)
	clutter_cairo_texture_set_surface_size(*cairotexture, width.l, height.l)
	clutter_child_meta_get_actor.i(*childmeta)
	clutter_child_meta_get_container.i(*childmeta)
	clutter_click_action_new.i()
	clutter_click_action_get_button.l(*clickaction)
	clutter_click_action_get_state.i(*clickaction)
	clutter_click_action_release(*clickaction)
	clutter_clone_new.i(*source)
	clutter_clone_get_source.i(*clone)
	clutter_clone_set_source(*clone, *source)
	clutter_colorize_effect_new.i(*tint)
	clutter_colorize_effect_get_tint(*colorizeeffect, *tint)
	clutter_colorize_effect_set_tint(*colorizeeffect, *tint)
	clutter_deform_effect_get_back_material.i(*deformeffect)
	clutter_deform_effect_get_n_tiles(*deformeffect, x_tiles.l, y_tiles.l)
	clutter_deform_effect_invalidate(*deformeffect)
	clutter_deform_effect_set_back_material(*deformeffect, *material)
	clutter_deform_effect_set_n_tiles(*deformeffect, x_tiles.l, y_tiles.l)
	clutter_desaturate_effect_new.i(factor.d)
	clutter_desaturate_effect_get_factor.d(*desaturateeffect)
	clutter_desaturate_effect_set_factor(*desaturateeffect, factor.d)
	clutter_device_manager_get_core_device.i(*devicemanager, device_type.l)
	clutter_device_manager_get_device.i(*devicemanager, device_id.l)
	clutter_device_manager_list_devices.i(*devicemanager)
	clutter_device_manager_peek_devices.i(*devicemanager)
	clutter_drag_action_new.i()
	clutter_drag_action_get_drag_axis.l(*dragaction)
	clutter_drag_action_get_drag_handle.i(*dragaction)
	clutter_drag_action_get_drag_threshold(*dragaction, x_threshold.l, y_threshold.l)
	clutter_drag_action_get_motion_coords(*dragaction, motion_x.f, motion_y.f)
	clutter_drag_action_get_press_coords(*dragaction, press_x.f, press_y.f)
	clutter_drag_action_set_drag_axis(*dragaction, axis.l)
	clutter_drag_action_set_drag_handle(*dragaction, *handle)
	clutter_drag_action_set_drag_threshold(*dragaction, x_threshold.l, y_threshold.l)
	clutter_fixed_layout_new.i()
	clutter_flow_layout_new.i(orientation.l)
	clutter_flow_layout_get_column_spacing.f(*flowlayout)
	clutter_flow_layout_get_column_width(*flowlayout, min_width.f, max_width.f)
	clutter_flow_layout_get_homogeneous.l(*flowlayout)
	clutter_flow_layout_get_orientation.l(*flowlayout)
	clutter_flow_layout_get_row_height(*flowlayout, min_height.f, max_height.f)
	clutter_flow_layout_get_row_spacing.f(*flowlayout)
	clutter_flow_layout_set_column_spacing(*flowlayout, spacing.f)
	clutter_flow_layout_set_column_width(*flowlayout, min_width.f, max_width.f)
	clutter_flow_layout_set_homogeneous(*flowlayout, homogeneous.l)
	clutter_flow_layout_set_orientation(*flowlayout, orientation.l)
	clutter_flow_layout_set_row_height(*flowlayout, min_height.f, max_height.f)
	clutter_flow_layout_set_row_spacing(*flowlayout, spacing.f)
	clutter_group_new.i()
	clutter_group_get_n_children.l(*group)
	clutter_group_get_nth_child.i(*group, index_.l)
	clutter_group_remove_all(*group)
	clutter_input_device_get_associated_device.i(*inputdevice)
	clutter_input_device_get_axis.l(*inputdevice, index_.l)
	clutter_input_device_get_axis_value.l(*inputdevice, axes.d, axis.l, value.d)
	clutter_input_device_get_device_coords(*inputdevice, x.l, y.l)
	clutter_input_device_get_device_id.l(*inputdevice)
	clutter_input_device_get_device_mode.l(*inputdevice)
	clutter_input_device_get_device_name.i(*inputdevice)
	clutter_input_device_get_device_type.l(*inputdevice)
	clutter_input_device_get_enabled.l(*inputdevice)
	clutter_input_device_get_has_cursor.l(*inputdevice)
	clutter_input_device_get_key.l(*inputdevice, index_.l, keyval.l, *modifiers)
	clutter_input_device_get_n_axes.l(*inputdevice)
	clutter_input_device_get_n_keys.l(*inputdevice)
	clutter_input_device_get_pointer_actor.i(*inputdevice)
	clutter_input_device_get_pointer_stage.i(*inputdevice)
	clutter_input_device_get_slave_devices.i(*inputdevice)
	clutter_input_device_set_enabled(*inputdevice, enabled.l)
	clutter_input_device_set_key(*inputdevice, index_.l, keyval.l, *modifiers)
	clutter_input_device_update_from_event(*inputdevice, *event, update_stage.l)
	clutter_interval_new.i(*gtype, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_interval_new_with_values.i(*gtype, *initial, *final)
	clutter_interval_clone.i(*interval)
	clutter_interval_compute.i(*interval, factor.d)
	clutter_interval_compute_value.l(*interval, factor.d, *value)
	clutter_interval_get_final_value(*interval, *value)
	clutter_interval_get_initial_value(*interval, *value)
	clutter_interval_get_interval(*interval, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_interval_get_value_type.i(*interval)
	clutter_interval_peek_final_value.i(*interval)
	clutter_interval_peek_initial_value.i(*interval)
	clutter_interval_set_final_value(*interval, *value)
	clutter_interval_set_initial_value(*interval, *value)
	clutter_interval_set_interval(*interval, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_interval_validate.l(*interval, *pspec)
	clutter_layout_manager_allocate(*layoutmanager, *container, *allocation, *flags)
	clutter_layout_manager_begin_animation.i(*layoutmanager, duration.l, mode.i)
	clutter_layout_manager_child_get(*layoutmanager, *container, *actor, first_property.p-utf8, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_layout_manager_child_get_property(*layoutmanager, *container, *actor, property_name.p-utf8, *value)
	clutter_layout_manager_child_set(*layoutmanager, *container, *actor, first_property.p-utf8, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_layout_manager_child_set_property(*layoutmanager, *container, *actor, property_name.p-utf8, *value)
	clutter_layout_manager_end_animation(*layoutmanager)
	clutter_layout_manager_find_child_property.i(*layoutmanager, name.p-utf8)
	clutter_layout_manager_get_animation_progress.d(*layoutmanager)
	clutter_layout_manager_get_child_meta.i(*layoutmanager, *container, *actor)
	clutter_layout_manager_get_preferred_height(*layoutmanager, *container, for_width.f, min_height_p.f, nat_height_p.f)
	clutter_layout_manager_get_preferred_width(*layoutmanager, *container, for_height.f, min_width_p.f, nat_width_p.f)
	clutter_layout_manager_layout_changed(*layoutmanager)
	clutter_layout_manager_list_child_properties.i(*layoutmanager, n_pspecs.l)
	clutter_layout_manager_set_container(*layoutmanager, *container)
	clutter_layout_meta_get_manager.i(*layoutmeta)
	clutter_list_model_new.i(n_columns.l, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_model_append(*model, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_model_appendv(*model, n_columns.l, columns.l, *values)
	clutter_model_filter_iter.l(*model, *iter)
	clutter_model_filter_row.l(*model, row.l)
	clutter_model_foreach(*model, *func, *user_data)
	clutter_model_get_column_name.i(*model, column.l)
	clutter_model_get_column_type.i(*model, column.l)
	clutter_model_get_filter_set.l(*model)
	clutter_model_get_first_iter.i(*model)
	clutter_model_get_iter_at_row.i(*model, row.l)
	clutter_model_get_last_iter.i(*model)
	clutter_model_get_n_columns.l(*model)
	clutter_model_get_n_rows.l(*model)
	clutter_model_get_sorting_column.l(*model)
	clutter_model_insert(*model, row.l, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_model_insert_value(*model, row.l, column.l, *value)
	clutter_model_insertv(*model, row.l, n_columns.l, columns.l, *values)
	clutter_model_prepend(*model, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_model_prependv(*model, n_columns.l, columns.l, *values)
	clutter_model_remove(*model, row.l)
	clutter_model_resort(*model)
	clutter_model_set_filter(*model, *func, *user_data, *notify)
	clutter_model_set_names(*model, n_columns.l, names.p-utf8)
	clutter_model_set_sort(*model, column.l, *func, *user_data, *notify)
	clutter_model_set_sorting_column(*model, column.l)
	clutter_model_set_types(*model, n_columns.l, *types)
	clutter_model_iter_copy.i(*modeliter)
	clutter_model_iter_get(*modeliter, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_model_iter_get_model.i(*modeliter)
	clutter_model_iter_get_row.l(*modeliter)
	clutter_model_iter_get_valist(*modeliter, *args)
	clutter_model_iter_get_value(*modeliter, column.l, *value)
	clutter_model_iter_is_first.l(*modeliter)
	clutter_model_iter_is_last.l(*modeliter)
	clutter_model_iter_next.i(*modeliter)
	clutter_model_iter_prev.i(*modeliter)
	clutter_model_iter_set(*modeliter, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_model_iter_set_valist(*modeliter, *args)
	clutter_model_iter_set_value(*modeliter, column.l, *value)
	clutter_offscreen_effect_create_texture.i(*offscreeneffect, width.f, height.f)
	clutter_offscreen_effect_get_target.i(*offscreeneffect)
	clutter_offscreen_effect_paint_target(*offscreeneffect)
	clutter_page_turn_effect_new.i(period.d, angle.d, radius.f)
	clutter_page_turn_effect_get_angle.d(*pageturneffect)
	clutter_page_turn_effect_get_period.d(*pageturneffect)
	clutter_page_turn_effect_get_radius.f(*pageturneffect)
	clutter_page_turn_effect_set_angle(*pageturneffect, angle.d)
	clutter_page_turn_effect_set_period(*pageturneffect, period.d)
	clutter_page_turn_effect_set_radius(*pageturneffect, radius.f)
	clutter_path_new.i()
	clutter_path_new_with_description.i(desc.p-utf8)
	clutter_path_add_cairo_path(*path, *cpath)
	clutter_path_add_close(*path)
	clutter_path_add_curve_to(*path, x_1.l, y_1.l, x_2.l, y_2.l, x_3.l, y_3.l)
	clutter_path_add_line_to(*path, x.l, y.l)
	clutter_path_add_move_to(*path, x.l, y.l)
	clutter_path_add_node(*path, *node)
	clutter_path_add_rel_curve_to(*path, x_1.l, y_1.l, x_2.l, y_2.l, x_3.l, y_3.l)
	clutter_path_add_rel_line_to(*path, x.l, y.l)
	clutter_path_add_rel_move_to(*path, x.l, y.l)
	clutter_path_add_string.l(*path, str.p-utf8)
	clutter_path_clear(*path)
	clutter_path_foreach(*path, *callback, *user_data)
	clutter_path_get_description.i(*path)
	clutter_path_get_length.l(*path)
	clutter_path_get_n_nodes.l(*path)
	clutter_path_get_node(*path, index_.l, *node)
	clutter_path_get_nodes.i(*path)
	clutter_path_get_position.l(*path, progress.d, *position)
	clutter_path_insert_node(*path, index_.l, *node)
	clutter_path_remove_node(*path, index_.l)
	clutter_path_replace_node(*path, index_.l, *node)
	clutter_path_set_description.l(*path, str.p-utf8)
	clutter_path_to_cairo_path(*path, *cr)
	clutter_path_constraint_new.i(*path, offset.f)
	clutter_path_constraint_get_offset.f(*pathconstraint)
	clutter_path_constraint_get_path.i(*pathconstraint)
	clutter_path_constraint_set_offset(*pathconstraint, offset.f)
	clutter_path_constraint_set_path(*pathconstraint, *path)
	clutter_rectangle_new.i()
	clutter_rectangle_new_with_color.i(*color)
	clutter_rectangle_get_border_color(*rectangle, *color)
	clutter_rectangle_get_border_width.l(*rectangle)
	clutter_rectangle_get_color(*rectangle, *color)
	clutter_rectangle_set_border_color(*rectangle, *color)
	clutter_rectangle_set_border_width(*rectangle, width.l)
	clutter_rectangle_set_color(*rectangle, *color)
	clutter_score_new.i()
	clutter_score_append.i(*score, *parent, *timeline)
	clutter_score_append_at_marker.i(*score, *parent, marker_name.p-utf8, *timeline)
	clutter_score_get_loop.l(*score)
	clutter_score_get_timeline.i(*score, id_.i)
	clutter_score_is_playing.l(*score)
	clutter_score_list_timelines.i(*score)
	clutter_score_pause(*score)
	clutter_score_remove(*score, id_.i)
	clutter_score_remove_all(*score)
	clutter_score_rewind(*score)
	clutter_score_set_loop(*score, loop.l)
	clutter_score_start(*score)
	clutter_score_stop(*score)
	clutter_script_new.i()
	clutter_script_add_search_paths(*script, paths.p-utf8, *n_paths)
	clutter_script_connect_signals(*script, *user_data)
	clutter_script_connect_signals_full(*script, *func, *user_data)
	clutter_script_ensure_objects(*script)
	clutter_script_get_object.i(*script, name.p-utf8)
	clutter_script_get_objects.l(*script, first_name.p-utf8, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_script_get_type_from_name.i(*script, type_name.p-utf8)
	clutter_script_list_objects.i(*script)
	clutter_script_load_from_data.l(*script, data_.p-utf8, length.i)
	clutter_script_load_from_file.l(*script, filename.p-utf8)
	clutter_script_lookup_filename.i(*script, filename.p-utf8)
	clutter_script_unmerge_objects(*script, merge_id.l)
	clutter_shader_new.i()
	clutter_shader_compile.l(*shader)
	clutter_shader_get_cogl_fragment_shader.i(*shader)
	clutter_shader_get_cogl_program.i(*shader)
	clutter_shader_get_cogl_vertex_shader.i(*shader)
	clutter_shader_get_fragment_source.i(*shader)
	clutter_shader_get_is_enabled.l(*shader)
	clutter_shader_get_vertex_source.i(*shader)
	clutter_shader_is_compiled.l(*shader)
	clutter_shader_release(*shader)
	clutter_shader_set_fragment_source(*shader, data_.p-utf8, length.i)
	clutter_shader_set_is_enabled(*shader, enabled.l)
	clutter_shader_set_uniform(*shader, name.p-utf8, *value)
	clutter_shader_set_vertex_source(*shader, data_.p-utf8, length.i)
	clutter_shader_effect_get_program.i(*shadereffect)
	clutter_shader_effect_get_shader.i(*shadereffect)
	clutter_shader_effect_set_shader_source.l(*shadereffect, source.p-utf8)
	clutter_shader_effect_set_uniform(*shadereffect, name.p-utf8, *gtype, *n_values, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_shader_effect_set_uniform_value(*shadereffect, name.p-utf8, *value)
	clutter_snap_constraint_new.i(*source, from_edge.l, to_edge.l, offset.f)
	clutter_snap_constraint_get_edges(*snapconstraint, from_edge.l, to_edge.l)
	clutter_snap_constraint_get_offset.f(*snapconstraint)
	clutter_snap_constraint_get_source.i(*snapconstraint)
	clutter_snap_constraint_set_edges(*snapconstraint, from_edge.l, to_edge.l)
	clutter_snap_constraint_set_offset(*snapconstraint, offset.f)
	clutter_snap_constraint_set_source(*snapconstraint, *source)
	clutter_stage_new.i()
	clutter_stage_ensure_current(*stage)
	clutter_stage_ensure_redraw(*stage)
	clutter_stage_ensure_viewport(*stage)
	clutter_stage_event.l(*stage, *event)
	clutter_stage_get_accept_focus.l(*stage)
	clutter_stage_get_actor_at_pos.i(*stage, pick_mode.l, x.l, y.l)
	clutter_stage_get_color(*stage, *color)
	clutter_stage_get_fog(*stage, *fog)
	clutter_stage_get_fullscreen.l(*stage)
	clutter_stage_get_key_focus.i(*stage)
	clutter_stage_get_minimum_size(*stage, width.l, height.l)
	clutter_stage_get_no_clear_hint.l(*stage)
	clutter_stage_get_perspective(*stage, *perspective)
	clutter_stage_get_throttle_motion_events.l(*stage)
	clutter_stage_get_title.i(*stage)
	clutter_stage_get_use_alpha.l(*stage)
	clutter_stage_get_use_fog.l(*stage)
	clutter_stage_get_user_resizable.l(*stage)
	clutter_stage_hide_cursor(*stage)
	clutter_stage_is_default.l(*stage)
	clutter_stage_queue_redraw(*stage)
	clutter_stage_read_pixels.a(*stage, x.l, y.l, width.l, height.l)
	clutter_stage_set_accept_focus(*stage, accept_focus.l)
	clutter_stage_set_color(*stage, *color)
	clutter_stage_set_fog(*stage, *fog)
	clutter_stage_set_fullscreen(*stage, fullscreen.l)
	clutter_stage_set_key_focus(*stage, *actor)
	clutter_stage_set_minimum_size(*stage, width.l, height.l)
	clutter_stage_set_no_clear_hint(*stage, no_clear.l)
	clutter_stage_set_perspective(*stage, *perspective)
	clutter_stage_set_throttle_motion_events(*stage, throttle.l)
	clutter_stage_set_title(*stage, title.p-utf8)
	clutter_stage_set_use_alpha(*stage, use_alpha.l)
	clutter_stage_set_use_fog(*stage, fog.l)
	clutter_stage_set_user_resizable(*stage, resizable.l)
	clutter_stage_show_cursor(*stage)
	clutter_stage_manager_get_default_stage.i(*stagemanager)
	clutter_stage_manager_list_stages.i(*stagemanager)
	clutter_stage_manager_peek_stages.i(*stagemanager)
	clutter_stage_manager_set_default_stage(*stagemanager, *stage)
	clutter_state_new.i()
	clutter_state_get_animator.i(*state, source_state_name.p-utf8, target_state_name.p-utf8)
	clutter_state_get_duration.l(*state, source_state_name.p-utf8, target_state_name.p-utf8)
	clutter_state_get_keys.i(*state, source_state_name.p-utf8, target_state_name.p-utf8, *object, property_name.p-utf8)
	clutter_state_get_state.i(*state)
	clutter_state_get_states.i(*state)
	clutter_state_get_timeline.i(*state)
	clutter_state_remove_key(*state, source_state_name.p-utf8, target_state_name.p-utf8, *object, property_name.p-utf8)
	clutter_state_set(*state, *source_state_name, target_state_name.p-utf8, *first_object, first_property_name.p-utf8, first_mode.i, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_state_set_animator(*state, source_state_name.p-utf8, target_state_name.p-utf8, *animator)
	clutter_state_set_duration(*state, source_state_name.p-utf8, target_state_name.p-utf8, duration.l)
	clutter_state_set_key.i(*state, source_state_name.p-utf8, target_state_name.p-utf8, *object, property_name.p-utf8, mode.l, *value, pre_delay.d, post_delay.d)
	clutter_state_set_state.i(*state, target_state_name.p-utf8)
	clutter_state_warp_to_state.i(*state, target_state_name.p-utf8)
	clutter_table_layout_new.i()
	clutter_table_layout_get_alignment(*tablelayout, *actor, x_align.l, y_align.l)
	clutter_table_layout_get_column_count.l(*tablelayout)
	clutter_table_layout_get_column_spacing.l(*tablelayout)
	clutter_table_layout_get_easing_duration.l(*tablelayout)
	clutter_table_layout_get_easing_mode.i(*tablelayout)
	clutter_table_layout_get_expand(*tablelayout, *actor, x_expand.l, y_expand.l)
	clutter_table_layout_get_fill(*tablelayout, *actor, x_fill.l, y_fill.l)
	clutter_table_layout_get_row_count.l(*tablelayout)
	clutter_table_layout_get_row_spacing.l(*tablelayout)
	clutter_table_layout_get_span(*tablelayout, *actor, column_span.l, row_span.l)
	clutter_table_layout_get_use_animations.l(*tablelayout)
	clutter_table_layout_pack(*tablelayout, *actor, column.l, row.l)
	clutter_table_layout_set_alignment(*tablelayout, *actor, x_align.l, y_align.l)
	clutter_table_layout_set_column_spacing(*tablelayout, spacing.l)
	clutter_table_layout_set_easing_duration(*tablelayout, msecs.l)
	clutter_table_layout_set_easing_mode(*tablelayout, mode.i)
	clutter_table_layout_set_expand(*tablelayout, *actor, x_expand.l, y_expand.l)
	clutter_table_layout_set_fill(*tablelayout, *actor, x_fill.l, y_fill.l)
	clutter_table_layout_set_row_spacing(*tablelayout, spacing.l)
	clutter_table_layout_set_span(*tablelayout, *actor, column_span.l, row_span.l)
	clutter_table_layout_set_use_animations(*tablelayout, animate.l)
	clutter_text_new.i()
	clutter_text_new_full.i(font_name.p-utf8, text.p-utf8, *color)
	clutter_text_new_with_text.i(font_name.p-utf8, text.p-utf8)
	clutter_text_activate.l(*text)
	clutter_text_delete_chars(*text, n_chars.l)
	clutter_text_delete_selection.l(*text)
	clutter_text_delete_text(*text, start_pos.i, end_pos.i)
	clutter_text_get_activatable.l(*text)
	clutter_text_get_attributes.i(*text)
	clutter_text_get_chars.i(*text, start_pos.i, end_pos.i)
	clutter_text_get_color(*text, *color)
	clutter_text_get_cursor_color(*text, *color)
	clutter_text_get_cursor_position.l(*text)
	clutter_text_get_cursor_size.l(*text)
	clutter_text_get_cursor_visible.l(*text)
	clutter_text_get_editable.l(*text)
	clutter_text_get_ellipsize.i(*text)
	clutter_text_get_font_description.i(*text)
	clutter_text_get_font_name.i(*text)
	clutter_text_get_justify.l(*text)
	clutter_text_get_layout.i(*text)
	clutter_text_get_line_alignment.i(*text)
	clutter_text_get_line_wrap.l(*text)
	clutter_text_get_line_wrap_mode.i(*text)
	clutter_text_get_max_length.l(*text)
	clutter_text_get_password_char.i(*text)
	clutter_text_get_selectable.l(*text)
	clutter_text_get_selection.i(*text)
	clutter_text_get_selection_bound.l(*text)
	clutter_text_get_selection_color(*text, *color)
	clutter_text_get_single_line_mode.l(*text)
	clutter_text_get_text.i(*text)
	clutter_text_get_use_markup.l(*text)
	clutter_text_insert_text(*text, text.p-utf8, position.i)
	clutter_text_insert_unichar(*text, *wc)
	clutter_text_position_to_coords.l(*text, position.l, x.f, y.f, line_height.f)
	clutter_text_set_activatable(*text, activatable.l)
	clutter_text_set_attributes(*text, *attrs)
	clutter_text_set_color(*text, *color)
	clutter_text_set_cursor_color(*text, *color)
	clutter_text_set_cursor_position(*text, position.l)
	clutter_text_set_cursor_size(*text, size.l)
	clutter_text_set_cursor_visible(*text, cursor_visible.l)
	clutter_text_set_editable(*text, editable.l)
	clutter_text_set_ellipsize(*text, *mode)
	clutter_text_set_font_description(*text, *font_desc)
	clutter_text_set_font_name(*text, font_name.p-utf8)
	clutter_text_set_justify(*text, justify.l)
	clutter_text_set_line_alignment(*text, *alignment)
	clutter_text_set_line_wrap(*text, line_wrap.l)
	clutter_text_set_line_wrap_mode(*text, *wrap_mode)
	clutter_text_set_markup(*text, markup.p-utf8)
	clutter_text_set_max_length(*text, max.l)
	clutter_text_set_password_char(*text, *wc)
	clutter_text_set_preedit_string(*text, preedit_str.p-utf8, *preedit_attrs, cursor_pos.l)
	clutter_text_set_selectable(*text, selectable.l)
	clutter_text_set_selection(*text, start_pos.i, end_pos.i)
	clutter_text_set_selection_bound(*text, selection_bound.l)
	clutter_text_set_selection_color(*text, *color)
	clutter_text_set_single_line_mode(*text, single_line.l)
	clutter_text_set_text(*text, text.p-utf8)
	clutter_text_set_use_markup(*text, setting.l)
	clutter_texture_new.i()
	clutter_texture_new_from_actor.i(*actor)
	clutter_texture_new_from_file.i(filename.p-utf8)
	clutter_texture_get_base_size(*texture, width.l, height.l)
	clutter_texture_get_cogl_material.i(*texture)
	clutter_texture_get_cogl_texture.i(*texture)
	clutter_texture_get_filter_quality.l(*texture)
	clutter_texture_get_keep_aspect_ratio.l(*texture)
	clutter_texture_get_load_async.l(*texture)
	clutter_texture_get_load_data_async.l(*texture)
	clutter_texture_get_max_tile_waste.l(*texture)
	clutter_texture_get_pick_with_alpha.l(*texture)
	clutter_texture_get_pixel_format.i(*texture)
	clutter_texture_get_repeat(*texture, repeat_x.l, repeat_y.l)
	clutter_texture_get_sync_size.l(*texture)
	clutter_texture_set_area_from_rgb_data.l(*texture, data_.a, has_alpha.l, x.l, y.l, width.l, height.l, rowstride.l, bpp.l, *flags)
	clutter_texture_set_cogl_material(*texture, *cogl_material)
	clutter_texture_set_cogl_texture(*texture, *cogl_tex)
	clutter_texture_set_filter_quality(*texture, filter_quality.l)
	clutter_texture_set_from_file.l(*texture, filename.p-utf8)
	clutter_texture_set_from_rgb_data.l(*texture, data_.a, has_alpha.l, width.l, height.l, rowstride.l, bpp.l, *flags)
	clutter_texture_set_from_yuv_data.l(*texture, data_.a, width.l, height.l, *flags)
	clutter_texture_set_keep_aspect_ratio(*texture, keep_aspect.l)
	clutter_texture_set_load_async(*texture, load_async.l)
	clutter_texture_set_load_data_async(*texture, load_async.l)
	clutter_texture_set_pick_with_alpha(*texture, pick_with_alpha.l)
	clutter_texture_set_repeat(*texture, repeat_x.l, repeat_y.l)
	clutter_texture_set_sync_size(*texture, sync_size.l)
	clutter_timeline_new.i(msecs.l)
	clutter_timeline_add_marker_at_time(*timeline, marker_name.p-utf8, msecs.l)
	clutter_timeline_advance(*timeline, msecs.l)
	clutter_timeline_advance_to_marker(*timeline, marker_name.p-utf8)
	clutter_timeline_clone.i(*timeline)
	clutter_timeline_get_auto_reverse.l(*timeline)
	clutter_timeline_get_delay.l(*timeline)
	clutter_timeline_get_delta.l(*timeline)
	clutter_timeline_get_direction.l(*timeline)
	clutter_timeline_get_duration.l(*timeline)
	clutter_timeline_get_elapsed_time.l(*timeline)
	clutter_timeline_get_loop.l(*timeline)
	clutter_timeline_get_progress.d(*timeline)
	clutter_timeline_has_marker.l(*timeline, marker_name.p-utf8)
	clutter_timeline_is_playing.l(*timeline)
	clutter_timeline_list_markers.i(*timeline, msecs.l, *n_markers)
	clutter_timeline_pause(*timeline)
	clutter_timeline_remove_marker(*timeline, marker_name.p-utf8)
	clutter_timeline_rewind(*timeline)
	clutter_timeline_set_auto_reverse(*timeline, reverse.l)
	clutter_timeline_set_delay(*timeline, msecs.l)
	clutter_timeline_set_direction(*timeline, direction.l)
	clutter_timeline_set_duration(*timeline, msecs.l)
	clutter_timeline_set_loop(*timeline, loop.l)
	clutter_timeline_skip(*timeline, msecs.l)
	clutter_timeline_start(*timeline)
	clutter_timeline_stop(*timeline)
	clutter_actor_box_new.i(x_1.f, y_1.f, x_2.f, y_2.f)
	clutter_actor_box_clamp_to_pixel(*actorbox)
	clutter_actor_box_contains.l(*actorbox, x.f, y.f)
	clutter_actor_box_copy.i(*actorbox)
	clutter_actor_box_equal.l(*actorbox, *box_b)
	clutter_actor_box_free(*actorbox)
	clutter_actor_box_from_vertices(*actorbox, *verts)
	clutter_actor_box_get_area.f(*actorbox)
	clutter_actor_box_get_height.f(*actorbox)
	clutter_actor_box_get_origin(*actorbox, x.f, y.f)
	clutter_actor_box_get_size(*actorbox, width.f, height.f)
	clutter_actor_box_get_width.f(*actorbox)
	clutter_actor_box_get_x.f(*actorbox)
	clutter_actor_box_get_y.f(*actorbox)
	clutter_actor_box_interpolate(*actorbox, *final, progress.d, *result)
	clutter_actor_box_set_origin(*actorbox, x.f, y.f)
	clutter_actor_box_set_size(*actorbox, width.f, height.f)
	clutter_actor_box_union(*actorbox, *b, *result)
	clutter_animator_key_get_mode.i(*animatorkey)
	clutter_animator_key_get_object.i(*animatorkey)
	clutter_animator_key_get_progress.d(*animatorkey)
	clutter_animator_key_get_property_name.i(*animatorkey)
	clutter_animator_key_get_property_type.i(*animatorkey)
	clutter_animator_key_get_value.l(*animatorkey, *value)
	clutter_color_new.i(red.a, green.a, blue.a, alpha.a)
	clutter_color_add(*color, *b, *result)
	clutter_color_copy.i(*color)
	clutter_color_darken(*color, *result)
	clutter_color_free(*color)
	clutter_color_from_hls(*color, hue.f, luminance.f, saturation.f)
	clutter_color_from_pixel(*color, pixel.l)
	clutter_color_from_string.l(*color, str.p-utf8)
	clutter_color_interpolate(*color, *final, progress.d, *result)
	clutter_color_lighten(*color, *result)
	clutter_color_shade(*color, factor.d, *result)
	clutter_color_subtract(*color, *b, *result)
	clutter_color_to_hls(*color, hue.f, luminance.f, saturation.f)
	clutter_color_to_pixel.l(*color)
	clutter_color_to_string.i(*color)
	clutter_geometry_intersects.l(*geometry, *geometry1)
	clutter_geometry_union(*geometry, *geometry_b, *result)
	clutter_knot_copy.i(*knot)
	clutter_knot_equal.l(*knot, *knot_b)
	clutter_knot_free(*knot)
	clutter_paint_volume_copy.i(*paintvolume)
	clutter_paint_volume_free(*paintvolume)
	clutter_paint_volume_get_depth.f(*paintvolume)
	clutter_paint_volume_get_height.f(*paintvolume)
	clutter_paint_volume_get_origin(*paintvolume, *vertex)
	clutter_paint_volume_get_width.f(*paintvolume)
	clutter_paint_volume_set_depth(*paintvolume, depth.f)
	clutter_paint_volume_set_from_allocation.l(*paintvolume, *actor)
	clutter_paint_volume_set_height(*paintvolume, height.f)
	clutter_paint_volume_set_origin(*paintvolume, *origin)
	clutter_paint_volume_set_width(*paintvolume, width.f)
	clutter_paint_volume_union(*paintvolume, *another_pv)
	clutter_path_node_copy.i(*pathnode)
	clutter_path_node_equal.l(*pathnode, *node_b)
	clutter_path_node_free(*pathnode)
	clutter_state_key_get_mode.i(*statekey)
	clutter_state_key_get_object.i(*statekey)
	clutter_state_key_get_post_delay.d(*statekey)
	clutter_state_key_get_pre_delay.d(*statekey)
	clutter_state_key_get_property_name.i(*statekey)
	clutter_state_key_get_property_type.i(*statekey)
	clutter_state_key_get_source_state_name.i(*statekey)
	clutter_state_key_get_target_state_name.i(*statekey)
	clutter_state_key_get_value.l(*statekey, *value)
	clutter_timeout_pool_add.l(*timeoutpool, fps.l, *func, *data_, *notify)
	clutter_timeout_pool_remove(*timeoutpool, id_.l)
	clutter_units_copy.i(*units)
	clutter_units_free(*units)
	clutter_units_from_cm(*units, cm.f)
	clutter_units_from_em(*units, em.f)
	clutter_units_from_em_for_font(*units, font_name.p-utf8, em.f)
	clutter_units_from_mm(*units, mm.f)
	clutter_units_from_pixels(*units, px.l)
	clutter_units_from_pt(*units, pt.f)
	clutter_units_from_string.l(*units, str.p-utf8)
	clutter_units_get_unit_type.l(*units)
	clutter_units_get_unit_value.f(*units)
	clutter_units_to_pixels.f(*units)
	clutter_units_to_string.i(*units)
	clutter_vertex_new.i(x.f, y.f, z.f)
	clutter_vertex_copy.i(*vertex)
	clutter_vertex_equal.l(*vertex, *vertex_b)
	clutter_vertex_free(*vertex)
	clutter_animatable_animate_property.l(*animatable, *animation, property_name.p-utf8, *initial_value, *final_value, progress.d, *value)
	clutter_animatable_find_property.i(*animatable, property_name.p-utf8)
	clutter_animatable_get_initial_state(*animatable, property_name.p-utf8, *value)
	clutter_animatable_set_final_state(*animatable, property_name.p-utf8, *value)
	clutter_container_add(*container, *first_actor, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_container_add_actor(*container, *actor)
	clutter_container_add_valist(*container, *first_actor, *var_args)
	clutter_container_child_get(*container, *actor, first_prop.p-utf8, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_container_child_get_property(*container, *child, property.p-utf8, *value)
	clutter_container_child_notify(*container, *child, *pspec)
	clutter_container_child_set(*container, *actor, first_prop.p-utf8, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_container_child_set_property(*container, *child, property.p-utf8, *value)
	clutter_container_create_child_meta(*container, *actor)
	clutter_container_destroy_child_meta(*container, *actor)
	clutter_container_find_child_by_name.i(*container, child_name.p-utf8)
	clutter_container_foreach(*container, *callback, *user_data)
	clutter_container_foreach_with_internals(*container, *callback, *user_data)
	clutter_container_get_child_meta.i(*container, *actor)
	clutter_container_get_children.i(*container)
	clutter_container_lower_child(*container, *actor, *sibling)
	clutter_container_raise_child(*container, *actor, *sibling)
	clutter_container_remove(*container, *first_actor, *_=0,*__=0,*___=0,*____=0,*_____=0,*______=0)
	clutter_container_remove_actor(*container, *actor)
	clutter_container_remove_valist(*container, *first_actor, *var_args)
	clutter_container_sort_depth_order(*container)
	clutter_media_get_audio_volume.d(*media)
	clutter_media_get_buffer_fill.d(*media)
	clutter_media_get_can_seek.l(*media)
	clutter_media_get_duration.d(*media)
	clutter_media_get_playing.l(*media)
	clutter_media_get_progress.d(*media)
	clutter_media_get_subtitle_font_name.i(*media)
	clutter_media_get_subtitle_uri.i(*media)
	clutter_media_get_uri.i(*media)
	clutter_media_set_audio_volume(*media, volume.d)
	clutter_media_set_filename(*media, filename.p-utf8)
	clutter_media_set_playing(*media, playing.l)
	clutter_media_set_progress(*media, progress.d)
	clutter_media_set_subtitle_font_name(*media, font_name.p-utf8)
	clutter_media_set_subtitle_uri(*media, uri.p-utf8)
	clutter_media_set_uri(*media, uri.p-utf8)
	clutter_scriptable_get_id.i(*scriptable)
	clutter_scriptable_parse_custom_node.l(*scriptable, *script, *value, name.p-utf8, *node)
	clutter_scriptable_set_custom_property(*scriptable, *script, name.p-utf8, *value)
	clutter_scriptable_set_id(*scriptable, id_.p-utf8)
	clutter_alpha_register_closure.i(*closure)
	clutter_alpha_register_func.i(*func, *data_)
	clutter_binding_pool_find.i(name.p-utf8)
	clutter_binding_pool_get_for_class.i(*klass)
	clutter_device_manager_get_default.i()
	clutter_interval_register_progress_func(*value_type, *func)
	clutter_list_model_newv.i(n_columns.l, *types, names.p-utf8)
	clutter_settings_get_default.i()
	clutter_stage_get_default.i()
	clutter_stage_manager_get_default.i()
	clutter_base_init()
	clutter_cairo_set_source_color(*cr, *color)
	clutter_check_version.l(major.l, minor.l, micro.l)
	clutter_clear_glyph_cache()
	clutter_color_equal.l(*v1, *v2)
	clutter_color_get_static.i(color.l)
	clutter_color_hash.l(*v)
	clutter_container_class_find_child_property.i(*klass, property_name.p-utf8)
	clutter_container_class_list_child_properties.i(*klass, n_properties.l)
	clutter_do_event(*event)
	clutter_event_get.i()
	clutter_event_peek.i()
	clutter_events_pending.l()
	clutter_feature_available.l(*feature)
	clutter_feature_get_all.i()
	clutter_frame_source_add.l(fps.l, *func, *data_)
	clutter_frame_source_add_full.l(priority.l, fps.l, *func, *data_, *notify)
	clutter_get_accessibility_enabled.l()
	clutter_get_actor_by_gid.i(id_.l)
	clutter_get_current_event.i()
	clutter_get_current_event_time.l()
	clutter_get_debug_enabled.l()
	clutter_get_default_backend.i()
	clutter_get_default_frame_rate.l()
	clutter_get_default_text_direction.l()
	clutter_get_font_flags.i()
	clutter_get_font_map.i()
	clutter_get_input_device_for_id.i(id_.l)
	clutter_get_keyboard_grab.i()
	clutter_get_motion_events_enabled.l()
	clutter_get_option_group.i()
	clutter_get_option_group_without_init.i()
	clutter_get_pointer_grab.i()
	clutter_get_script_id.i(*gobject)
	clutter_get_show_fps.l()
	clutter_get_timestamp.i()
	clutter_grab_keyboard(*actor)
	clutter_grab_pointer(*actor)
	clutter_grab_pointer_for_device(*actor, id_.l)
	clutter_init.l(argc.l, argv.p-utf8)
	clutter_init_error_quark.i()
	clutter_init_with_args.l(argc.l, argv.p-utf8, parameter_string.p-utf8, *entries, translation_domain.p-utf8)
	clutter_keysym_to_unicode.l(keyval.l)
	clutter_main()
	clutter_main_level.l()
	clutter_main_quit()
	clutter_param_spec_color.i(name.p-utf8, nick.p-utf8, blurb.p-utf8, *default_value, *flags)
	clutter_param_spec_fixed.i(name.p-utf8, nick.p-utf8, blurb.p-utf8, *minimum, *maximum, *default_value, *flags)
	clutter_param_spec_units.i(name.p-utf8, nick.p-utf8, blurb.p-utf8, default_type.l, minimum.f, maximum.f, default_value.f, *flags)
	clutter_redraw(*stage)
	clutter_script_error_quark.i()
	clutter_set_default_frame_rate(frames_per_sec.l)
	clutter_set_font_flags(*flags)
	clutter_set_motion_events_enabled(enable.l)
	clutter_shader_error_quark.i()
	clutter_shader_float_get_type.i()
	clutter_shader_int_get_type.i()
	clutter_shader_matrix_get_type.i()
	clutter_texture_error_quark.i()
	clutter_threads_add_frame_source.l(fps.l, *func, *data_)
	clutter_threads_add_frame_source_full.l(priority.l, fps.l, *func, *data_, *notify)
	clutter_threads_add_idle.l(*func, *data_)
	clutter_threads_add_idle_full.l(priority.l, *func, *data_, *notify)
	clutter_threads_add_repaint_func.l(*func, *data_, *notify)
	clutter_threads_add_timeout.l(interval.l, *func, *data_)
	clutter_threads_add_timeout_full.l(priority.l, interval.l, *func, *data_, *notify)
	clutter_threads_enter()
	clutter_threads_init()
	clutter_threads_leave()
	clutter_threads_remove_repaint_func(handle_id.l)
	clutter_threads_set_lock_functions(*enter_fn, *leave_fn)
	clutter_timeout_pool_new.i(priority.l)
	clutter_ungrab_keyboard()
	clutter_ungrab_pointer()
	clutter_ungrab_pointer_for_device(id_.l)
	clutter_util_next_p2.l(a.l)
	clutter_value_get_color.i(*value)
	clutter_value_get_fixed.i(*value)
	clutter_value_get_shader_float.f(*value, *length)
	clutter_value_get_shader_int.l(*value, *length)
	clutter_value_get_shader_matrix.f(*value, *length)
	clutter_value_get_units.i(*value)
	clutter_value_set_color(*value, *color)
	clutter_value_set_fixed(*value, *fixed_)
	clutter_value_set_shader_float(*value, size.l, floats.f)
	clutter_value_set_shader_int(*value, size.l, ints.l)
	clutter_value_set_shader_matrix(*value, size.l, matrix.f)
	clutter_value_set_units(*value, *units)
EndImport


