;-------------- FILE: /usr/share/gir-1.0/Json-1.0.gir --------------

; ATTENTION: instances of gulong/ulong/long will be translated to
; a INTEGER/.i. This is right on Linux but probably should be a
; LONG/.l on Windows. If you are brave enough, take a look at
; the TypeTranslator class and the attribute c_types, which
; contains the translation table. There you can fix it.

;- NAMESPACE: Json from "libjson-glib-1.0.so.0"

Enumeration ; PathError
	#JSON_PATH_ERROR_INVALID_QUERY = 0
EndEnumeration

Enumeration ; ReaderError
	#JSON_READER_ERROR_NO_ARRAY = 0
	#JSON_READER_ERROR_INVALID_INDEX = 1
	#JSON_READER_ERROR_NO_OBJECT = 2
	#JSON_READER_ERROR_INVALID_MEMBER = 3
EndEnumeration

Enumeration ; NodeType
	#JSON_NODE_OBJECT = 0
	#JSON_NODE_ARRAY = 1
	#JSON_NODE_VALUE = 2
	#JSON_NODE_NULL = 3
EndEnumeration

Enumeration ; ParserError
	#JSON_PARSER_ERROR_PARSE = 0
	#JSON_PARSER_ERROR_TRAILING_COMMA = 1
	#JSON_PARSER_ERROR_MISSING_COMMA = 2
	#JSON_PARSER_ERROR_MISSING_COLON = 3
	#JSON_PARSER_ERROR_INVALID_BAREWORD = 4
	#JSON_PARSER_ERROR_UNKNOWN = 5
EndEnumeration

CompilerIf Defined(JsonArray, #PB_Structure)
CompilerElse
Structure JsonArray
EndStructure
CompilerEndIf

CompilerIf Defined(JsonBuilderClass, #PB_Structure)
CompilerElse
Structure JsonBuilderClass
	*parent_class
	*_json_reserved1
	*_json_reserved2
EndStructure
CompilerEndIf

CompilerIf Defined(JsonBuilderPrivate, #PB_Structure)
CompilerElse
Structure JsonBuilderPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(JsonGeneratorClass, #PB_Structure)
CompilerElse
Structure JsonGeneratorClass
	*parent_class
	*_json_reserved1
	*_json_reserved2
	*_json_reserved3
	*_json_reserved4
EndStructure
CompilerEndIf

CompilerIf Defined(JsonGeneratorPrivate, #PB_Structure)
CompilerElse
Structure JsonGeneratorPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(JsonNode, #PB_Structure)
CompilerElse
Structure JsonNode
EndStructure
CompilerEndIf

CompilerIf Defined(JsonObject, #PB_Structure)
CompilerElse
Structure JsonObject
EndStructure
CompilerEndIf

CompilerIf Defined(JsonParserClass, #PB_Structure)
CompilerElse
Structure JsonParserClass
	*parent_class
	*parse_start
	*object_start
	*object_member
	*object_end
	*array_start
	*array_element
	*array_end
	*parse_end
	*error
	*_json_reserved1
	*_json_reserved2
	*_json_reserved3
	*_json_reserved4
	*_json_reserved5
	*_json_reserved6
	*_json_reserved7
	*_json_reserved8
EndStructure
CompilerEndIf

CompilerIf Defined(JsonParserPrivate, #PB_Structure)
CompilerElse
Structure JsonParserPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(JsonPathClass, #PB_Structure)
CompilerElse
Structure JsonPathClass
EndStructure
CompilerEndIf

CompilerIf Defined(JsonReaderClass, #PB_Structure)
CompilerElse
Structure JsonReaderClass
	*parent_class
	*_json_padding0
	*_json_padding1
	*_json_padding2
	*_json_padding3
	*_json_padding4
EndStructure
CompilerEndIf

CompilerIf Defined(JsonReaderPrivate, #PB_Structure)
CompilerElse
Structure JsonReaderPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(JsonSerializableIface, #PB_Structure)
CompilerElse
Structure JsonSerializableIface
	*g_iface
	*serialize_property
	*deserialize_property
	*find_property
	*list_properties
	*set_property
	*get_property
EndStructure
CompilerEndIf
ImportC "/usr/lib/libjson-glib-1.0.so.0"
	json_builder_new.i()
	json_builder_add_boolean_value.i(*builder, value.l)
	json_builder_add_double_value.i(*builder, value.d)
	json_builder_add_int_value.i(*builder, value.q)
	json_builder_add_null_value.i(*builder)
	json_builder_add_string_value.i(*builder, value.p-utf8)
	json_builder_add_value.i(*builder, *node)
	json_builder_begin_array.i(*builder)
	json_builder_begin_object.i(*builder)
	json_builder_end_array.i(*builder)
	json_builder_end_object.i(*builder)
	json_builder_get_root.i(*builder)
	json_builder_reset(*builder)
	json_builder_set_member_name.i(*builder, member_name.p-utf8)
	json_generator_new.i()
	json_generator_get_indent.l(*generator)
	json_generator_get_indent_char.i(*generator)
	json_generator_get_pretty.l(*generator)
	json_generator_get_root.i(*generator)
	json_generator_set_indent(*generator, indent_level.l)
	json_generator_set_indent_char(*generator, *indent_char)
	json_generator_set_pretty(*generator, is_pretty.l)
	json_generator_set_root(*generator, *node)
	json_generator_to_data.i(*generator, *length)
	json_generator_to_file.l(*generator, filename.p-utf8)
	json_generator_to_stream.l(*generator, *stream, *cancellable)
	json_parser_new.i()
	json_parser_get_current_line.l(*parser)
	json_parser_get_current_pos.l(*parser)
	json_parser_get_root.i(*parser)
	json_parser_has_assignment.l(*parser, variable_name.p-utf8)
	json_parser_load_from_data.l(*parser, data_.p-utf8, length.i)
	json_parser_load_from_file.l(*parser, filename.p-utf8)
	json_parser_load_from_stream.l(*parser, *stream, *cancellable)
	json_parser_load_from_stream_async(*parser, *stream, *cancellable, *callback, *user_data)
	json_parser_load_from_stream_finish.l(*parser, *result)
	json_path_new.i()
	json_path_compile.l(*path, expression.p-utf8)
	json_path_match.i(*path, *root)
	json_reader_new.i(*node)
	json_reader_count_elements.l(*reader)
	json_reader_count_members.l(*reader)
	json_reader_end_element(*reader)
	json_reader_end_member(*reader)
	json_reader_get_boolean_value.l(*reader)
	json_reader_get_double_value.d(*reader)
	json_reader_get_error.i(*reader)
	json_reader_get_int_value.q(*reader)
	json_reader_get_member_name.i(*reader)
	json_reader_get_null_value.l(*reader)
	json_reader_get_string_value.i(*reader)
	json_reader_get_value.i(*reader)
	json_reader_is_array.l(*reader)
	json_reader_is_object.l(*reader)
	json_reader_is_value.l(*reader)
	json_reader_list_members.i(*reader)
	json_reader_read_element.l(*reader, index_.l)
	json_reader_read_member.l(*reader, member_name.p-utf8)
	json_reader_set_root(*reader, *root)
	json_array_new.i()
	json_array_sized_new.i(n_elements.l)
	json_array_add_array_element(*array, *value)
	json_array_add_boolean_element(*array, value.l)
	json_array_add_double_element(*array, value.d)
	json_array_add_element(*array, *node)
	json_array_add_int_element(*array, value.q)
	json_array_add_null_element(*array)
	json_array_add_object_element(*array, *value)
	json_array_add_string_element(*array, value.p-utf8)
	json_array_dup_element.i(*array, index_.l)
	json_array_foreach_element(*array, *func, *data_)
	json_array_get_array_element.i(*array, index_.l)
	json_array_get_boolean_element.l(*array, index_.l)
	json_array_get_double_element.d(*array, index_.l)
	json_array_get_element.i(*array, index_.l)
	json_array_get_elements.i(*array)
	json_array_get_int_element.q(*array, index_.l)
	json_array_get_length.l(*array)
	json_array_get_null_element.l(*array, index_.l)
	json_array_get_object_element.i(*array, index_.l)
	json_array_get_string_element.i(*array, index_.l)
	json_array_ref.i(*array)
	json_array_remove_element(*array, index_.l)
	json_array_unref(*array)
	json_node_new.i(type.l)
	json_node_copy.i(*node)
	json_node_dup_array.i(*node)
	json_node_dup_object.i(*node)
	json_node_dup_string.i(*node)
	json_node_free(*node)
	json_node_get_array.i(*node)
	json_node_get_boolean.l(*node)
	json_node_get_double.d(*node)
	json_node_get_int.q(*node)
	json_node_get_node_type.l(*node)
	json_node_get_object.i(*node)
	json_node_get_parent.i(*node)
	json_node_get_string.i(*node)
	json_node_get_value(*node, *value)
	json_node_get_value_type.i(*node)
	json_node_is_null.l(*node)
	json_node_set_array(*node, *array)
	json_node_set_boolean(*node, value.l)
	json_node_set_double(*node, value.d)
	json_node_set_int(*node, value.q)
	json_node_set_object(*node, *object)
	json_node_set_parent(*node, *parent)
	json_node_set_string(*node, value.p-utf8)
	json_node_set_value(*node, *value)
	json_node_take_array(*node, *array)
	json_node_take_object(*node, *object)
	json_node_type_name.i(*node)
	json_object_new.i()
	json_object_add_member(*object, member_name.p-utf8, *node)
	json_object_dup_member.i(*object, member_name.p-utf8)
	json_object_foreach_member(*object, *func, *data_)
	json_object_get_array_member.i(*object, member_name.p-utf8)
	json_object_get_boolean_member.l(*object, member_name.p-utf8)
	json_object_get_double_member.d(*object, member_name.p-utf8)
	json_object_get_int_member.q(*object, member_name.p-utf8)
	json_object_get_member.i(*object, member_name.p-utf8)
	json_object_get_members.i(*object)
	json_object_get_null_member.l(*object, member_name.p-utf8)
	json_object_get_object_member.i(*object, member_name.p-utf8)
	json_object_get_size.l(*object)
	json_object_get_string_member.i(*object, member_name.p-utf8)
	json_object_get_values.i(*object)
	json_object_has_member.l(*object, member_name.p-utf8)
	json_object_ref.i(*object)
	json_object_remove_member(*object, member_name.p-utf8)
	json_object_set_array_member(*object, member_name.p-utf8, *value)
	json_object_set_boolean_member(*object, member_name.p-utf8, value.l)
	json_object_set_double_member(*object, member_name.p-utf8, value.d)
	json_object_set_int_member(*object, member_name.p-utf8, value.q)
	json_object_set_member(*object, member_name.p-utf8, *node)
	json_object_set_null_member(*object, member_name.p-utf8)
	json_object_set_object_member(*object, member_name.p-utf8, *value)
	json_object_set_string_member(*object, member_name.p-utf8, value.p-utf8)
	json_object_unref(*object)
	json_serializable_default_deserialize_property.l(*serializable, property_name.p-utf8, *value, *pspec, *property_node)
	json_serializable_default_serialize_property.i(*serializable, property_name.p-utf8, *value, *pspec)
	json_serializable_deserialize_property.l(*serializable, property_name.p-utf8, *value, *pspec, *property_node)
	json_serializable_find_property.i(*serializable, name.p-utf8)
	json_serializable_get_property(*serializable, *pspec, *value)
	json_serializable_list_properties.i(*serializable, n_pspecs.l)
	json_serializable_serialize_property.i(*serializable, property_name.p-utf8, *value, *pspec)
	json_serializable_set_property(*serializable, *pspec, *value)
	json_parser_error_quark.i()
	json_path_error_quark.i()
	json_path_query.i(expression.p-utf8, *root)
	json_reader_error_quark.i()
	json_boxed_can_deserialize.l(*gboxed_type, node_type.l)
	json_boxed_can_serialize.l(*gboxed_type, node_type.l)
	json_boxed_deserialize.i(*gboxed_type, *node)
	json_boxed_register_deserialize_func(*gboxed_type, node_type.l, *deserialize_func)
	json_boxed_register_serialize_func(*gboxed_type, node_type.l, *serialize_func)
	json_boxed_serialize.i(*gboxed_type, *boxed)
	json_construct_gobject.i(*gtype, data_.p-utf8, *length)
	json_gobject_deserialize.i(*gtype, *node)
	json_gobject_from_data.i(*gtype, data_.p-utf8, length.i)
	json_gobject_serialize.i(*gobject)
	json_gobject_to_data.i(*gobject, *length)
	json_gvariant_deserialize.i(*json_node, signature.p-utf8)
	json_gvariant_deserialize_data.i(json.p-utf8, length.i, signature.p-utf8)
	json_gvariant_serialize.i(*variant)
	json_gvariant_serialize_data.i(*variant, *length)
	json_serialize_gobject.i(*gobject, *length)
EndImport


