;-------------- FILE: /usr/share/gir-1.0/WebKit-1.0.gir --------------

; ATTENTION: instances of gulong/ulong/long will be translated to
; a INTEGER/.i. This is right on Linux but probably should be a
; LONG/.l on Windows. If you are brave enough, take a look at
; the TypeTranslator class and the attribute c_types, which
; contains the translation table. There you can fix it.

;- NAMESPACE: WebKit from "libwebkitgtk-1.0.so.0"

Enumeration ; SelectionAffinity
	#WEBKIT_SELECTION_AFFINITY_UPSTREAM = 0
	#WEBKIT_SELECTION_AFFINITY_DOWNSTREAM = 1
EndEnumeration

Enumeration ; LoadStatus
	#WEBKIT_LOAD_PROVISIONAL = 0
	#WEBKIT_LOAD_COMMITTED = 1
	#WEBKIT_LOAD_FINISHED = 2
	#WEBKIT_LOAD_FIRST_VISUALLY_NON_EMPTY_LAYOUT = 3
	#WEBKIT_LOAD_FAILED = 4
EndEnumeration

Enumeration ; InsertAction
	#WEBKIT_INSERT_ACTION_TYPED = 0
	#WEBKIT_INSERT_ACTION_PASTED = 1
	#WEBKIT_INSERT_ACTION_DROPPED = 2
EndEnumeration

Enumeration ; WebViewTargetInfo
	#WEBKIT_WEB_VIEW_TARGET_INFO_HTML = 0
	#WEBKIT_WEB_VIEW_TARGET_INFO_TEXT = 1
	#WEBKIT_WEB_VIEW_TARGET_INFO_IMAGE = 2
	#WEBKIT_WEB_VIEW_TARGET_INFO_URI_LIST = 3
	#WEBKIT_WEB_VIEW_TARGET_INFO_NETSCAPE_URL = 4
EndEnumeration

Enumeration ; NetworkError
	#WEBKIT_NETWORK_ERROR_FAILED = 399
	#WEBKIT_NETWORK_ERROR_TRANSPORT = 300
	#WEBKIT_NETWORK_ERROR_UNKNOWN_PROTOCOL = 301
	#WEBKIT_NETWORK_ERROR_CANCELLED = 302
	#WEBKIT_NETWORK_ERROR_FILE_DOES_NOT_EXIST = 303
EndEnumeration

Enumeration ; EditingBehavior
	#WEBKIT_EDITING_BEHAVIOR_MAC = 0
	#WEBKIT_EDITING_BEHAVIOR_WINDOWS = 1
	#WEBKIT_EDITING_BEHAVIOR_UNIX = 2
EndEnumeration

Enumeration ; DownloadError
	#WEBKIT_DOWNLOAD_ERROR_CANCELLED_BY_USER = 0
	#WEBKIT_DOWNLOAD_ERROR_DESTINATION = 1
	#WEBKIT_DOWNLOAD_ERROR_NETWORK = 2
EndEnumeration

Enumeration ; PluginError
	#WEBKIT_PLUGIN_ERROR_FAILED = 299
	#WEBKIT_PLUGIN_ERROR_CANNOT_FIND_PLUGIN = 200
	#WEBKIT_PLUGIN_ERROR_CANNOT_LOAD_PLUGIN = 201
	#WEBKIT_PLUGIN_ERROR_JAVA_UNAVAILABLE = 202
	#WEBKIT_PLUGIN_ERROR_CONNECTION_CANCELLED = 203
	#WEBKIT_PLUGIN_ERROR_WILL_HANDLE_LOAD = 204
EndEnumeration

Enumeration ; WebNavigationReason
	#WEBKIT_WEB_NAVIGATION_REASON_LINK_CLICKED = 0
	#WEBKIT_WEB_NAVIGATION_REASON_FORM_SUBMITTED = 1
	#WEBKIT_WEB_NAVIGATION_REASON_BACK_FORWARD = 2
	#WEBKIT_WEB_NAVIGATION_REASON_RELOAD = 3
	#WEBKIT_WEB_NAVIGATION_REASON_FORM_RESUBMITTED = 4
	#WEBKIT_WEB_NAVIGATION_REASON_OTHER = 5
EndEnumeration

Enumeration ; NavigationResponse
	#WEBKIT_NAVIGATION_RESPONSE_ACCEPT = 0
	#WEBKIT_NAVIGATION_RESPONSE_IGNORE = 1
	#WEBKIT_NAVIGATION_RESPONSE_DOWNLOAD = 2
EndEnumeration

Enumeration ; CacheModel
	#WEBKIT_CACHE_MODEL_DEFAULT = 0
	#WEBKIT_CACHE_MODEL_DOCUMENT_VIEWER = 1
	#WEBKIT_CACHE_MODEL_WEB_BROWSER = 2
	#WEBKIT_CACHE_MODEL_DOCUMENT_BROWSER = 3
EndEnumeration

Enumeration ; DownloadStatus
	#WEBKIT_DOWNLOAD_STATUS_ERROR = -1
	#WEBKIT_DOWNLOAD_STATUS_CREATED = 0
	#WEBKIT_DOWNLOAD_STATUS_STARTED = 1
	#WEBKIT_DOWNLOAD_STATUS_CANCELLED = 2
	#WEBKIT_DOWNLOAD_STATUS_FINISHED = 3
EndEnumeration

Enumeration ; PolicyError
	#WEBKIT_POLICY_ERROR_FAILED = 199
	#WEBKIT_POLICY_ERROR_CANNOT_SHOW_MIME_TYPE = 100
	#WEBKIT_POLICY_ERROR_CANNOT_SHOW_URL = 101
	#WEBKIT_POLICY_ERROR_FRAME_LOAD_INTERRUPTED_BY_POLICY_CHANGE = 102
	#WEBKIT_POLICY_ERROR_CANNOT_USE_RESTRICTED_PORT = 103
EndEnumeration

Enumeration ; WebViewViewMode
	#WEBKIT_WEB_VIEW_VIEW_MODE_WINDOWED = 0
	#WEBKIT_WEB_VIEW_VIEW_MODE_FLOATING = 1
	#WEBKIT_WEB_VIEW_VIEW_MODE_FULLSCREEN = 2
	#WEBKIT_WEB_VIEW_VIEW_MODE_MAXIMIZED = 3
	#WEBKIT_WEB_VIEW_VIEW_MODE_MINIMIZED = 4
EndEnumeration

CompilerIf Defined(WebKitDOMAttrClass, #PB_Structure)
CompilerElse
Structure WebKitDOMAttrClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMBarInfoClass, #PB_Structure)
CompilerElse
Structure WebKitDOMBarInfoClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMBlobClass, #PB_Structure)
CompilerElse
Structure WebKitDOMBlobClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMCDATASectionClass, #PB_Structure)
CompilerElse
Structure WebKitDOMCDATASectionClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMCSSRuleClass, #PB_Structure)
CompilerElse
Structure WebKitDOMCSSRuleClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMCSSRuleListClass, #PB_Structure)
CompilerElse
Structure WebKitDOMCSSRuleListClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMCSSStyleDeclarationClass, #PB_Structure)
CompilerElse
Structure WebKitDOMCSSStyleDeclarationClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMCSSStyleSheetClass, #PB_Structure)
CompilerElse
Structure WebKitDOMCSSStyleSheetClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMCSSValueClass, #PB_Structure)
CompilerElse
Structure WebKitDOMCSSValueClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMCharacterDataClass, #PB_Structure)
CompilerElse
Structure WebKitDOMCharacterDataClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMCommentClass, #PB_Structure)
CompilerElse
Structure WebKitDOMCommentClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMConsoleClass, #PB_Structure)
CompilerElse
Structure WebKitDOMConsoleClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMDOMApplicationCacheClass, #PB_Structure)
CompilerElse
Structure WebKitDOMDOMApplicationCacheClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMDOMImplementationClass, #PB_Structure)
CompilerElse
Structure WebKitDOMDOMImplementationClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMDOMMimeTypeArrayClass, #PB_Structure)
CompilerElse
Structure WebKitDOMDOMMimeTypeArrayClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMDOMMimeTypeClass, #PB_Structure)
CompilerElse
Structure WebKitDOMDOMMimeTypeClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMDOMPluginArrayClass, #PB_Structure)
CompilerElse
Structure WebKitDOMDOMPluginArrayClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMDOMPluginClass, #PB_Structure)
CompilerElse
Structure WebKitDOMDOMPluginClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMDOMSelectionClass, #PB_Structure)
CompilerElse
Structure WebKitDOMDOMSelectionClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMDOMSettableTokenListClass, #PB_Structure)
CompilerElse
Structure WebKitDOMDOMSettableTokenListClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMDOMStringListClass, #PB_Structure)
CompilerElse
Structure WebKitDOMDOMStringListClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMDOMStringMapClass, #PB_Structure)
CompilerElse
Structure WebKitDOMDOMStringMapClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMDOMTokenListClass, #PB_Structure)
CompilerElse
Structure WebKitDOMDOMTokenListClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMDOMWindowClass, #PB_Structure)
CompilerElse
Structure WebKitDOMDOMWindowClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMDatabaseClass, #PB_Structure)
CompilerElse
Structure WebKitDOMDatabaseClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMDocumentClass, #PB_Structure)
CompilerElse
Structure WebKitDOMDocumentClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMDocumentFragmentClass, #PB_Structure)
CompilerElse
Structure WebKitDOMDocumentFragmentClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMDocumentTypeClass, #PB_Structure)
CompilerElse
Structure WebKitDOMDocumentTypeClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMEntityReferenceClass, #PB_Structure)
CompilerElse
Structure WebKitDOMEntityReferenceClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMEventClass, #PB_Structure)
CompilerElse
Structure WebKitDOMEventClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMEventTargetClass, #PB_Structure)
CompilerElse
Structure WebKitDOMEventTargetClass
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMEventTargetIface, #PB_Structure)
CompilerElse
Structure WebKitDOMEventTargetIface
	*gIface
	*dispatch_event
	*add_event_listener
	*remove_event_listener
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMFileClass, #PB_Structure)
CompilerElse
Structure WebKitDOMFileClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMFileListClass, #PB_Structure)
CompilerElse
Structure WebKitDOMFileListClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLAnchorElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLAnchorElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLAppletElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLAppletElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLAreaElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLAreaElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLAudioElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLAudioElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLBRElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLBRElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLBaseElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLBaseElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLBaseFontElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLBaseFontElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLBlockquoteElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLBlockquoteElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLBodyElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLBodyElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLButtonElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLButtonElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLCanvasElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLCanvasElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLCollectionClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLCollectionClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLDListElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLDListElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLDetailsElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLDetailsElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLDirectoryElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLDirectoryElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLDivElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLDivElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLDocumentClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLDocumentClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLEmbedElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLEmbedElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLFieldSetElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLFieldSetElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLFontElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLFontElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLFormElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLFormElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLFrameElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLFrameElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLFrameSetElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLFrameSetElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLHRElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLHRElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLHeadElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLHeadElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLHeadingElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLHeadingElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLHtmlElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLHtmlElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLIFrameElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLIFrameElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLImageElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLImageElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLInputElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLInputElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLIsIndexElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLIsIndexElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLKeygenElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLKeygenElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLLIElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLLIElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLLabelElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLLabelElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLLegendElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLLegendElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLLinkElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLLinkElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLMapElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLMapElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLMarqueeElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLMarqueeElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLMediaElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLMediaElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLMenuElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLMenuElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLMetaElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLMetaElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLModElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLModElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLOListElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLOListElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLObjectElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLObjectElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLOptGroupElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLOptGroupElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLOptionElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLOptionElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLOptionsCollectionClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLOptionsCollectionClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLParagraphElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLParagraphElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLParamElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLParamElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLPreElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLPreElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLQuoteElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLQuoteElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLScriptElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLScriptElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLSelectElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLSelectElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLStyleElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLStyleElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLTableCaptionElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLTableCaptionElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLTableCellElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLTableCellElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLTableColElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLTableColElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLTableElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLTableElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLTableRowElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLTableRowElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLTableSectionElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLTableSectionElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLTextAreaElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLTextAreaElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLTitleElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLTitleElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLUListElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLUListElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHTMLVideoElementClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHTMLVideoElementClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMHistoryClass, #PB_Structure)
CompilerElse
Structure WebKitDOMHistoryClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMLocationClass, #PB_Structure)
CompilerElse
Structure WebKitDOMLocationClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMMediaErrorClass, #PB_Structure)
CompilerElse
Structure WebKitDOMMediaErrorClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMMediaListClass, #PB_Structure)
CompilerElse
Structure WebKitDOMMediaListClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMMediaQueryListClass, #PB_Structure)
CompilerElse
Structure WebKitDOMMediaQueryListClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMMemoryInfoClass, #PB_Structure)
CompilerElse
Structure WebKitDOMMemoryInfoClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMMessagePortClass, #PB_Structure)
CompilerElse
Structure WebKitDOMMessagePortClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMMouseEventClass, #PB_Structure)
CompilerElse
Structure WebKitDOMMouseEventClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMNamedNodeMapClass, #PB_Structure)
CompilerElse
Structure WebKitDOMNamedNodeMapClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMNavigatorClass, #PB_Structure)
CompilerElse
Structure WebKitDOMNavigatorClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMNodeClass, #PB_Structure)
CompilerElse
Structure WebKitDOMNodeClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMNodeFilterClass, #PB_Structure)
CompilerElse
Structure WebKitDOMNodeFilterClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMNodeIteratorClass, #PB_Structure)
CompilerElse
Structure WebKitDOMNodeIteratorClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMNodeListClass, #PB_Structure)
CompilerElse
Structure WebKitDOMNodeListClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMObjectClass, #PB_Structure)
CompilerElse
Structure WebKitDOMObjectClass
	*parentClass
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMObjectPrivate, #PB_Structure)
CompilerElse
Structure WebKitDOMObjectPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMProcessingInstructionClass, #PB_Structure)
CompilerElse
Structure WebKitDOMProcessingInstructionClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMRangeClass, #PB_Structure)
CompilerElse
Structure WebKitDOMRangeClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMScreenClass, #PB_Structure)
CompilerElse
Structure WebKitDOMScreenClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMStorageClass, #PB_Structure)
CompilerElse
Structure WebKitDOMStorageClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMStyleMediaClass, #PB_Structure)
CompilerElse
Structure WebKitDOMStyleMediaClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMStyleSheetClass, #PB_Structure)
CompilerElse
Structure WebKitDOMStyleSheetClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMStyleSheetListClass, #PB_Structure)
CompilerElse
Structure WebKitDOMStyleSheetListClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMTextClass, #PB_Structure)
CompilerElse
Structure WebKitDOMTextClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMTimeRangesClass, #PB_Structure)
CompilerElse
Structure WebKitDOMTimeRangesClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMTreeWalkerClass, #PB_Structure)
CompilerElse
Structure WebKitDOMTreeWalkerClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMUIEventClass, #PB_Structure)
CompilerElse
Structure WebKitDOMUIEventClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMValidityStateClass, #PB_Structure)
CompilerElse
Structure WebKitDOMValidityStateClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMWebKitAnimationClass, #PB_Structure)
CompilerElse
Structure WebKitDOMWebKitAnimationClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMWebKitAnimationListClass, #PB_Structure)
CompilerElse
Structure WebKitDOMWebKitAnimationListClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMWebKitPointClass, #PB_Structure)
CompilerElse
Structure WebKitDOMWebKitPointClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMXPathExpressionClass, #PB_Structure)
CompilerElse
Structure WebKitDOMXPathExpressionClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMXPathNSResolverClass, #PB_Structure)
CompilerElse
Structure WebKitDOMXPathNSResolverClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDOMXPathResultClass, #PB_Structure)
CompilerElse
Structure WebKitDOMXPathResultClass
	*parent_class
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDownloadClass, #PB_Structure)
CompilerElse
Structure WebKitDownloadClass
	*parent_class
	*_webkit_reserved0
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitDownloadPrivate, #PB_Structure)
CompilerElse
Structure WebKitDownloadPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitGeolocationPolicyDecisionClass, #PB_Structure)
CompilerElse
Structure WebKitGeolocationPolicyDecisionClass
	*parent_class
	*_webkit_reserved0
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitGeolocationPolicyDecisionPrivate, #PB_Structure)
CompilerElse
Structure WebKitGeolocationPolicyDecisionPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitHitTestResultClass, #PB_Structure)
CompilerElse
Structure WebKitHitTestResultClass
	*parent_class
	*_webkit_reserved0
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitHitTestResultPrivate, #PB_Structure)
CompilerElse
Structure WebKitHitTestResultPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitIconDatabaseClass, #PB_Structure)
CompilerElse
Structure WebKitIconDatabaseClass
	*parent_class
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
	*_webkit_reserved4
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitIconDatabasePrivate, #PB_Structure)
CompilerElse
Structure WebKitIconDatabasePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitNetworkRequestClass, #PB_Structure)
CompilerElse
Structure WebKitNetworkRequestClass
	*parent_class
	*_webkit_reserved0
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitNetworkRequestPrivate, #PB_Structure)
CompilerElse
Structure WebKitNetworkRequestPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitNetworkResponseClass, #PB_Structure)
CompilerElse
Structure WebKitNetworkResponseClass
	*parent_class
	*_webkit_reserved0
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitNetworkResponsePrivate, #PB_Structure)
CompilerElse
Structure WebKitNetworkResponsePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitSecurityOriginClass, #PB_Structure)
CompilerElse
Structure WebKitSecurityOriginClass
	*parent_class
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
	*_webkit_reserved4
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitSecurityOriginPrivate, #PB_Structure)
CompilerElse
Structure WebKitSecurityOriginPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitSoupAuthDialogClass, #PB_Structure)
CompilerElse
Structure WebKitSoupAuthDialogClass
	*parent_class
	*current_toplevel
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitViewportAttributesClass, #PB_Structure)
CompilerElse
Structure WebKitViewportAttributesClass
	*parent_class
	*_webkit_reserved0
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitViewportAttributesPrivate, #PB_Structure)
CompilerElse
Structure WebKitViewportAttributesPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebBackForwardListClass, #PB_Structure)
CompilerElse
Structure WebKitWebBackForwardListClass
	*parent_class
	*_webkit_reserved0
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebBackForwardListPrivate, #PB_Structure)
CompilerElse
Structure WebKitWebBackForwardListPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebDataSourceClass, #PB_Structure)
CompilerElse
Structure WebKitWebDataSourceClass
	*parent_class
	*_webkit_reserved0
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebDataSourcePrivate, #PB_Structure)
CompilerElse
Structure WebKitWebDataSourcePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebDatabaseClass, #PB_Structure)
CompilerElse
Structure WebKitWebDatabaseClass
	*parent_class
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
	*_webkit_reserved4
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebDatabasePrivate, #PB_Structure)
CompilerElse
Structure WebKitWebDatabasePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebFrameClass, #PB_Structure)
CompilerElse
Structure WebKitWebFrameClass
	*parent_class
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
	*_webkit_reserved4
	*_webkit_reserved5
	*_webkit_reserved6
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebFramePrivate, #PB_Structure)
CompilerElse
Structure WebKitWebFramePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebHistoryItemClass, #PB_Structure)
CompilerElse
Structure WebKitWebHistoryItemClass
	*parent_class
	*_webkit_reserved0
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebHistoryItemPrivate, #PB_Structure)
CompilerElse
Structure WebKitWebHistoryItemPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebInspectorClass, #PB_Structure)
CompilerElse
Structure WebKitWebInspectorClass
	*parent_class
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
	*_webkit_reserved4
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebInspectorPrivate, #PB_Structure)
CompilerElse
Structure WebKitWebInspectorPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebNavigationActionClass, #PB_Structure)
CompilerElse
Structure WebKitWebNavigationActionClass
	*parent_class
	*_webkit_reserved0
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebNavigationActionPrivate, #PB_Structure)
CompilerElse
Structure WebKitWebNavigationActionPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebPluginClass, #PB_Structure)
CompilerElse
Structure WebKitWebPluginClass
	*parentClass
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebPluginDatabaseClass, #PB_Structure)
CompilerElse
Structure WebKitWebPluginDatabaseClass
	*parentClass
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebPluginDatabasePrivate, #PB_Structure)
CompilerElse
Structure WebKitWebPluginDatabasePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebPluginPrivate, #PB_Structure)
CompilerElse
Structure WebKitWebPluginPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebPolicyDecisionClass, #PB_Structure)
CompilerElse
Structure WebKitWebPolicyDecisionClass
	*parent_class
	*_webkit_reserved0
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebPolicyDecisionPrivate, #PB_Structure)
CompilerElse
Structure WebKitWebPolicyDecisionPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebResourceClass, #PB_Structure)
CompilerElse
Structure WebKitWebResourceClass
	*parent_class
	*_webkit_reserved0
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebResourcePrivate, #PB_Structure)
CompilerElse
Structure WebKitWebResourcePrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebSettingsClass, #PB_Structure)
CompilerElse
Structure WebKitWebSettingsClass
	*parent_class
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
	*_webkit_reserved4
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebSettingsPrivate, #PB_Structure)
CompilerElse
Structure WebKitWebSettingsPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebViewClass, #PB_Structure)
CompilerElse
Structure WebKitWebViewClass
	*parent_class
	*create_web_view
	*web_view_ready
	*close_web_view
	*navigation_requested
	*window_object_cleared
	*choose_file
	*script_alert
	*script_confirm
	*script_prompt
	*console_message
	*select_all
	*cut_clipboard
	*copy_clipboard
	*paste_clipboard
	*move_cursor
	*set_scroll_adjustments
	*undo
	*redo
	*should_allow_editing_action
	*_webkit_reserved0
	*_webkit_reserved1
	*_webkit_reserved2
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebViewPrivate, #PB_Structure)
CompilerElse
Structure WebKitWebViewPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebWindowFeaturesClass, #PB_Structure)
CompilerElse
Structure WebKitWebWindowFeaturesClass
	*parent_class
	*_webkit_reserved1
	*_webkit_reserved2
	*_webkit_reserved3
	*_webkit_reserved4
EndStructure
CompilerEndIf

CompilerIf Defined(WebKitWebWindowFeaturesPrivate, #PB_Structure)
CompilerElse
Structure WebKitWebWindowFeaturesPrivate
EndStructure
CompilerEndIf

CompilerIf Defined(WebKit_WebPluginMIMEType, #PB_Structure)
CompilerElse
Structure WebKit_WebPluginMIMEType
	*name
	*description
	*extensions
EndStructure
CompilerEndIf
ImportC "/usr/lib/libwebkitgtk-1.0.so.0"
	webkit_dom_attr_get_is_id.l(*domattr)
	webkit_dom_attr_get_name.i(*domattr)
	webkit_dom_attr_get_owner_element.i(*domattr)
	webkit_dom_attr_get_specified.l(*domattr)
	webkit_dom_attr_get_value.i(*domattr)
	webkit_dom_attr_set_value(*domattr, value.p-utf8)
	webkit_dom_bar_info_get_visible.l(*dombarinfo)
	webkit_dom_blob_get_size.q(*domblob)
	webkit_dom_blob_slice.i(*domblob, start.q, length.q, content_type.p-utf8)
	webkit_dom_css_rule_get_css_text.i(*domcssrule)
	webkit_dom_css_rule_get_parent_rule.i(*domcssrule)
	webkit_dom_css_rule_get_parent_style_sheet.i(*domcssrule)
	webkit_dom_css_rule_set_css_text(*domcssrule, value.p-utf8)
	webkit_dom_css_rule_list_get_length.i(*domcssrulelist)
	webkit_dom_css_rule_list_item.i(*domcssrulelist, index.i)
	webkit_dom_css_style_declaration_get_css_text.i(*domcssstyledeclaration)
	webkit_dom_css_style_declaration_get_length.i(*domcssstyledeclaration)
	webkit_dom_css_style_declaration_get_parent_rule.i(*domcssstyledeclaration)
	webkit_dom_css_style_declaration_get_property_css_value.i(*domcssstyledeclaration, property_name.p-utf8)
	webkit_dom_css_style_declaration_get_property_priority.i(*domcssstyledeclaration, property_name.p-utf8)
	webkit_dom_css_style_declaration_get_property_shorthand.i(*domcssstyledeclaration, property_name.p-utf8)
	webkit_dom_css_style_declaration_get_property_value.i(*domcssstyledeclaration, property_name.p-utf8)
	webkit_dom_css_style_declaration_is_property_implicit.l(*domcssstyledeclaration, property_name.p-utf8)
	webkit_dom_css_style_declaration_item.i(*domcssstyledeclaration, index.i)
	webkit_dom_css_style_declaration_remove_property.i(*domcssstyledeclaration, property_name.p-utf8)
	webkit_dom_css_style_declaration_set_css_text(*domcssstyledeclaration, value.p-utf8)
	webkit_dom_css_style_declaration_set_property(*domcssstyledeclaration, property_name.p-utf8, value.p-utf8, priority.p-utf8)
	webkit_dom_css_style_sheet_add_rule.i(*domcssstylesheet, selector.p-utf8, style.p-utf8, index.i)
	webkit_dom_css_style_sheet_delete_rule(*domcssstylesheet, index.i)
	webkit_dom_css_style_sheet_get_css_rules.i(*domcssstylesheet)
	webkit_dom_css_style_sheet_get_owner_rule.i(*domcssstylesheet)
	webkit_dom_css_style_sheet_get_rules.i(*domcssstylesheet)
	webkit_dom_css_style_sheet_insert_rule.i(*domcssstylesheet, rule.p-utf8, index.i)
	webkit_dom_css_style_sheet_remove_rule(*domcssstylesheet, index.i)
	webkit_dom_css_value_get_css_text.i(*domcssvalue)
	webkit_dom_css_value_get_css_value_type.u(*domcssvalue)
	webkit_dom_css_value_set_css_text(*domcssvalue, value.p-utf8)
	webkit_dom_character_data_append_data(*domcharacterdata, data_.p-utf8)
	webkit_dom_character_data_delete_data(*domcharacterdata, offset.i, length.i)
	webkit_dom_character_data_get_data.i(*domcharacterdata)
	webkit_dom_character_data_get_length.i(*domcharacterdata)
	webkit_dom_character_data_insert_data(*domcharacterdata, offset.i, data_.p-utf8)
	webkit_dom_character_data_replace_data(*domcharacterdata, offset.i, length.i, data_.p-utf8)
	webkit_dom_character_data_set_data(*domcharacterdata, value.p-utf8)
	webkit_dom_character_data_substring_data.i(*domcharacterdata, offset.i, length.i)
	webkit_dom_console_get_memory.i(*domconsole)
	webkit_dom_console_group_end(*domconsole)
	webkit_dom_console_time(*domconsole, title.p-utf8)
	webkit_dom_dom_application_cache_dispatch_event.l(*domdomapplicationcache, *evt)
	webkit_dom_dom_application_cache_get_status.u(*domdomapplicationcache)
	webkit_dom_dom_application_cache_swap_cache(*domdomapplicationcache)
	webkit_dom_dom_application_cache_update(*domdomapplicationcache)
	webkit_dom_dom_implementation_create_css_style_sheet.i(*domdomimplementation, title.p-utf8, media.p-utf8)
	webkit_dom_dom_implementation_create_document.i(*domdomimplementation, namespace_uri.p-utf8, qualified_name.p-utf8, *doctype)
	webkit_dom_dom_implementation_create_document_type.i(*domdomimplementation, qualified_name.p-utf8, public_id.p-utf8, system_id.p-utf8)
	webkit_dom_dom_implementation_create_html_document.i(*domdomimplementation, title.p-utf8)
	webkit_dom_dom_implementation_has_feature.l(*domdomimplementation, feature.p-utf8, version.p-utf8)
	webkit_dom_dom_mime_type_get_description.i(*domdommimetype)
	webkit_dom_dom_mime_type_get_enabled_plugin.i(*domdommimetype)
	webkit_dom_dom_mime_type_get_suffixes.i(*domdommimetype)
	webkit_dom_dom_mime_type_array_get_length.i(*domdommimetypearray)
	webkit_dom_dom_mime_type_array_item.i(*domdommimetypearray, index.i)
	webkit_dom_dom_mime_type_array_named_item.i(*domdommimetypearray, name.p-utf8)
	webkit_dom_dom_plugin_get_description.i(*domdomplugin)
	webkit_dom_dom_plugin_get_filename.i(*domdomplugin)
	webkit_dom_dom_plugin_get_length.i(*domdomplugin)
	webkit_dom_dom_plugin_get_name.i(*domdomplugin)
	webkit_dom_dom_plugin_item.i(*domdomplugin, index.i)
	webkit_dom_dom_plugin_named_item.i(*domdomplugin, name.p-utf8)
	webkit_dom_dom_plugin_array_get_length.i(*domdompluginarray)
	webkit_dom_dom_plugin_array_item.i(*domdompluginarray, index.i)
	webkit_dom_dom_plugin_array_named_item.i(*domdompluginarray, name.p-utf8)
	webkit_dom_dom_plugin_array_refresh(*domdompluginarray, reload.l)
	webkit_dom_dom_selection_add_range(*domdomselection, *range)
	webkit_dom_dom_selection_collapse(*domdomselection, *node, index.i)
	webkit_dom_dom_selection_collapse_to_end(*domdomselection)
	webkit_dom_dom_selection_collapse_to_start(*domdomselection)
	webkit_dom_dom_selection_contains_node.l(*domdomselection, *node, allow_partial.l)
	webkit_dom_dom_selection_delete_from_document(*domdomselection)
	webkit_dom_dom_selection_empty(*domdomselection)
	webkit_dom_dom_selection_extend(*domdomselection, *node, offset.i)
	webkit_dom_dom_selection_get_anchor_node.i(*domdomselection)
	webkit_dom_dom_selection_get_anchor_offset.i(*domdomselection)
	webkit_dom_dom_selection_get_base_node.i(*domdomselection)
	webkit_dom_dom_selection_get_base_offset.i(*domdomselection)
	webkit_dom_dom_selection_get_extent_node.i(*domdomselection)
	webkit_dom_dom_selection_get_extent_offset.i(*domdomselection)
	webkit_dom_dom_selection_get_focus_node.i(*domdomselection)
	webkit_dom_dom_selection_get_focus_offset.i(*domdomselection)
	webkit_dom_dom_selection_get_is_collapsed.l(*domdomselection)
	webkit_dom_dom_selection_get_range_at.i(*domdomselection, index.i)
	webkit_dom_dom_selection_get_range_count.i(*domdomselection)
	webkit_dom_dom_selection_modify(*domdomselection, alter.p-utf8, direction.p-utf8, granularity.p-utf8)
	webkit_dom_dom_selection_remove_all_ranges(*domdomselection)
	webkit_dom_dom_selection_select_all_children(*domdomselection, *node)
	webkit_dom_dom_selection_set_base_and_extent(*domdomselection, *base_node, base_offset.i, *extent_node, extent_offset.i)
	webkit_dom_dom_selection_set_position(*domdomselection, *node, offset.i)
	webkit_dom_dom_settable_token_list_get_value.i(*domdomsettabletokenlist)
	webkit_dom_dom_settable_token_list_set_value(*domdomsettabletokenlist, value.p-utf8)
	webkit_dom_dom_string_list_contains.l(*domdomstringlist, string.p-utf8)
	webkit_dom_dom_string_list_get_length.i(*domdomstringlist)
	webkit_dom_dom_string_list_item.i(*domdomstringlist, index.i)
	webkit_dom_dom_token_list_add(*domdomtokenlist, token.p-utf8)
	webkit_dom_dom_token_list_contains.l(*domdomtokenlist, token.p-utf8)
	webkit_dom_dom_token_list_get_length.i(*domdomtokenlist)
	webkit_dom_dom_token_list_item.i(*domdomtokenlist, index.i)
	webkit_dom_dom_token_list_remove(*domdomtokenlist, token.p-utf8)
	webkit_dom_dom_token_list_toggle.l(*domdomtokenlist, token.p-utf8)
	webkit_dom_dom_window_alert(*domdomwindow, message.p-utf8)
	webkit_dom_dom_window_atob.i(*domdomwindow, string.p-utf8)
	webkit_dom_dom_window_blur(*domdomwindow)
	webkit_dom_dom_window_btoa.i(*domdomwindow, string.p-utf8)
	webkit_dom_dom_window_capture_events(*domdomwindow)
	webkit_dom_dom_window_clear_interval(*domdomwindow, handle.i)
	webkit_dom_dom_window_clear_timeout(*domdomwindow, handle.i)
	webkit_dom_dom_window_close(*domdomwindow)
	webkit_dom_dom_window_confirm.l(*domdomwindow, message.p-utf8)
	webkit_dom_dom_window_dispatch_event.l(*domdomwindow, *evt)
	webkit_dom_dom_window_find.l(*domdomwindow, string.p-utf8, case_sensitive.l, backwards.l, wrap.l, whole_word.l, search_in_frames.l, show_dialog.l)
	webkit_dom_dom_window_focus(*domdomwindow)
	webkit_dom_dom_window_get_application_cache.i(*domdomwindow)
	webkit_dom_dom_window_get_closed.l(*domdomwindow)
	webkit_dom_dom_window_get_computed_style.i(*domdomwindow, *element, pseudo_element.p-utf8)
	webkit_dom_dom_window_get_default_status.i(*domdomwindow)
	webkit_dom_dom_window_get_document.i(*domdomwindow)
	webkit_dom_dom_window_get_frame_element.i(*domdomwindow)
	webkit_dom_dom_window_get_history.i(*domdomwindow)
	webkit_dom_dom_window_get_local_storage.i(*domdomwindow)
	webkit_dom_dom_window_get_name.i(*domdomwindow)
	webkit_dom_dom_window_get_page_x_offset.i(*domdomwindow)
	webkit_dom_dom_window_get_page_y_offset.i(*domdomwindow)
	webkit_dom_dom_window_get_selection.i(*domdomwindow)
	webkit_dom_dom_window_get_session_storage.i(*domdomwindow)
	webkit_dom_dom_window_get_status.i(*domdomwindow)
	webkit_dom_dom_window_get_style_media.i(*domdomwindow)
	webkit_dom_dom_window_get_window.i(*domdomwindow)
	webkit_dom_dom_window_match_media.i(*domdomwindow, query.p-utf8)
	webkit_dom_dom_window_move_by(*domdomwindow, x.f, y.f)
	webkit_dom_dom_window_move_to(*domdomwindow, x.f, y.f)
	webkit_dom_dom_window_print(*domdomwindow)
	webkit_dom_dom_window_prompt.i(*domdomwindow, message.p-utf8, default_value.p-utf8)
	webkit_dom_dom_window_release_events(*domdomwindow)
	webkit_dom_dom_window_resize_by(*domdomwindow, x.f, y.f)
	webkit_dom_dom_window_resize_to(*domdomwindow, width.f, height.f)
	webkit_dom_dom_window_scroll(*domdomwindow, x.i, y.i)
	webkit_dom_dom_window_scroll_by(*domdomwindow, x.i, y.i)
	webkit_dom_dom_window_scroll_to(*domdomwindow, x.i, y.i)
	webkit_dom_dom_window_set_default_status(*domdomwindow, value.p-utf8)
	webkit_dom_dom_window_set_name(*domdomwindow, value.p-utf8)
	webkit_dom_dom_window_set_status(*domdomwindow, value.p-utf8)
	webkit_dom_dom_window_stop(*domdomwindow)
	webkit_dom_dom_window_webkit_convert_point_from_node_to_page.i(*domdomwindow, *node, *p)
	webkit_dom_dom_window_webkit_convert_point_from_page_to_node.i(*domdomwindow, *node, *p)
	webkit_dom_database_get_version.i(*domdatabase)
	webkit_dom_document_adopt_node.i(*domdocument, *source)
	webkit_dom_document_caret_range_from_point.i(*domdocument, x.i, y.i)
	webkit_dom_document_create_attribute.i(*domdocument, name.p-utf8)
	webkit_dom_document_create_attribute_ns.i(*domdocument, namespace_uri.p-utf8, qualified_name.p-utf8)
	webkit_dom_document_create_cdata_section.i(*domdocument, data_.p-utf8)
	webkit_dom_document_create_comment.i(*domdocument, data_.p-utf8)
	webkit_dom_document_create_css_style_declaration.i(*domdocument)
	webkit_dom_document_create_document_fragment.i(*domdocument)
	webkit_dom_document_create_element.i(*domdocument, tag_name.p-utf8)
	webkit_dom_document_create_element_ns.i(*domdocument, namespace_uri.p-utf8, qualified_name.p-utf8)
	webkit_dom_document_create_entity_reference.i(*domdocument, name.p-utf8)
	webkit_dom_document_create_event.i(*domdocument, event_type.p-utf8)
	webkit_dom_document_create_expression.i(*domdocument, expression.p-utf8, *resolver)
	webkit_dom_document_create_node_iterator.i(*domdocument, *root, what_to_show.i, *filter, expand_entity_references.l)
	webkit_dom_document_create_ns_resolver.i(*domdocument, *node_resolver)
	webkit_dom_document_create_processing_instruction.i(*domdocument, target.p-utf8, data_.p-utf8)
	webkit_dom_document_create_range.i(*domdocument)
	webkit_dom_document_create_text_node.i(*domdocument, data_.p-utf8)
	webkit_dom_document_create_tree_walker.i(*domdocument, *root, what_to_show.i, *filter, expand_entity_references.l)
	webkit_dom_document_element_from_point.i(*domdocument, x.i, y.i)
	webkit_dom_document_evaluate.i(*domdocument, expression.p-utf8, *context_node, *resolver, type.u, *in_result)
	webkit_dom_document_exec_command.l(*domdocument, command.p-utf8, user_interface.l, value.p-utf8)
	webkit_dom_document_get_anchors.i(*domdocument)
	webkit_dom_document_get_applets.i(*domdocument)
	webkit_dom_document_get_body.i(*domdocument)
	webkit_dom_document_get_character_set.i(*domdocument)
	webkit_dom_document_get_charset.i(*domdocument)
	webkit_dom_document_get_compat_mode.i(*domdocument)
	webkit_dom_document_get_cookie.i(*domdocument)
	webkit_dom_document_get_default_charset.i(*domdocument)
	webkit_dom_document_get_default_view.i(*domdocument)
	webkit_dom_document_get_doctype.i(*domdocument)
	webkit_dom_document_get_document_element.i(*domdocument)
	webkit_dom_document_get_document_uri.i(*domdocument)
	webkit_dom_document_get_domain.i(*domdocument)
	webkit_dom_document_get_element_by_id.i(*domdocument, element_id.p-utf8)
	webkit_dom_document_get_elements_by_class_name.i(*domdocument, tagname.p-utf8)
	webkit_dom_document_get_elements_by_name.i(*domdocument, element_name.p-utf8)
	webkit_dom_document_get_elements_by_tag_name.i(*domdocument, tagname.p-utf8)
	webkit_dom_document_get_elements_by_tag_name_ns.i(*domdocument, namespace_uri.p-utf8, local_name.p-utf8)
	webkit_dom_document_get_forms.i(*domdocument)
	webkit_dom_document_get_head.i(*domdocument)
	webkit_dom_document_get_images.i(*domdocument)
	webkit_dom_document_get_implementation.i(*domdocument)
	webkit_dom_document_get_input_encoding.i(*domdocument)
	webkit_dom_document_get_last_modified.i(*domdocument)
	webkit_dom_document_get_links.i(*domdocument)
	webkit_dom_document_get_override_style.i(*domdocument, *element, pseudo_element.p-utf8)
	webkit_dom_document_get_preferred_stylesheet_set.i(*domdocument)
	webkit_dom_document_get_ready_state.i(*domdocument)
	webkit_dom_document_get_referrer.i(*domdocument)
	webkit_dom_document_get_selected_stylesheet_set.i(*domdocument)
	webkit_dom_document_get_style_sheets.i(*domdocument)
	webkit_dom_document_get_title.i(*domdocument)
	webkit_dom_document_get_webkit_current_full_screen_element.i(*domdocument)
	webkit_dom_document_get_webkit_full_screen_keyboard_input_allowed.l(*domdocument)
	webkit_dom_document_get_webkit_is_full_screen.l(*domdocument)
	webkit_dom_document_get_xml_encoding.i(*domdocument)
	webkit_dom_document_get_xml_standalone.l(*domdocument)
	webkit_dom_document_get_xml_version.i(*domdocument)
	webkit_dom_document_import_node.i(*domdocument, *imported_node, deep.l)
	webkit_dom_document_query_command_enabled.l(*domdocument, command.p-utf8)
	webkit_dom_document_query_command_indeterm.l(*domdocument, command.p-utf8)
	webkit_dom_document_query_command_state.l(*domdocument, command.p-utf8)
	webkit_dom_document_query_command_supported.l(*domdocument, command.p-utf8)
	webkit_dom_document_query_command_value.i(*domdocument, command.p-utf8)
	webkit_dom_document_query_selector.i(*domdocument, selectors.p-utf8)
	webkit_dom_document_query_selector_all.i(*domdocument, selectors.p-utf8)
	webkit_dom_document_set_body(*domdocument, *value)
	webkit_dom_document_set_charset(*domdocument, value.p-utf8)
	webkit_dom_document_set_cookie(*domdocument, value.p-utf8)
	webkit_dom_document_set_document_uri(*domdocument, value.p-utf8)
	webkit_dom_document_set_selected_stylesheet_set(*domdocument, value.p-utf8)
	webkit_dom_document_set_title(*domdocument, value.p-utf8)
	webkit_dom_document_set_xml_standalone(*domdocument, value.l)
	webkit_dom_document_set_xml_version(*domdocument, value.p-utf8)
	webkit_dom_document_webkit_cancel_full_screen(*domdocument)
	webkit_dom_document_fragment_query_selector.i(*domdocumentfragment, selectors.p-utf8)
	webkit_dom_document_fragment_query_selector_all.i(*domdocumentfragment, selectors.p-utf8)
	webkit_dom_document_type_get_entities.i(*domdocumenttype)
	webkit_dom_document_type_get_internal_subset.i(*domdocumenttype)
	webkit_dom_document_type_get_name.i(*domdocumenttype)
	webkit_dom_document_type_get_notations.i(*domdocumenttype)
	webkit_dom_document_type_get_public_id.i(*domdocumenttype)
	webkit_dom_document_type_get_system_id.i(*domdocumenttype)
	webkit_dom_element_blur(*domelement)
	webkit_dom_element_contains.l(*domelement, *element)
	webkit_dom_element_focus(*domelement)
	webkit_dom_element_get_attribute.i(*domelement, name.p-utf8)
	webkit_dom_element_get_attribute_node.i(*domelement, name.p-utf8)
	webkit_dom_element_get_attribute_node_ns.i(*domelement, namespace_uri.p-utf8, local_name.p-utf8)
	webkit_dom_element_get_attribute_ns.i(*domelement, namespace_uri.p-utf8, local_name.p-utf8)
	webkit_dom_element_get_child_element_count.i(*domelement)
	webkit_dom_element_get_client_height.i(*domelement)
	webkit_dom_element_get_client_left.i(*domelement)
	webkit_dom_element_get_client_top.i(*domelement)
	webkit_dom_element_get_client_width.i(*domelement)
	webkit_dom_element_get_elements_by_class_name.i(*domelement, name.p-utf8)
	webkit_dom_element_get_elements_by_tag_name.i(*domelement, name.p-utf8)
	webkit_dom_element_get_elements_by_tag_name_ns.i(*domelement, namespace_uri.p-utf8, local_name.p-utf8)
	webkit_dom_element_get_first_element_child.i(*domelement)
	webkit_dom_element_get_last_element_child.i(*domelement)
	webkit_dom_element_get_next_element_sibling.i(*domelement)
	webkit_dom_element_get_offset_height.i(*domelement)
	webkit_dom_element_get_offset_left.i(*domelement)
	webkit_dom_element_get_offset_parent.i(*domelement)
	webkit_dom_element_get_offset_top.i(*domelement)
	webkit_dom_element_get_offset_width.i(*domelement)
	webkit_dom_element_get_previous_element_sibling.i(*domelement)
	webkit_dom_element_get_scroll_height.i(*domelement)
	webkit_dom_element_get_scroll_left.i(*domelement)
	webkit_dom_element_get_scroll_top.i(*domelement)
	webkit_dom_element_get_scroll_width.i(*domelement)
	webkit_dom_element_get_style.i(*domelement)
	webkit_dom_element_get_tag_name.i(*domelement)
	webkit_dom_element_has_attribute.l(*domelement, name.p-utf8)
	webkit_dom_element_has_attribute_ns.l(*domelement, namespace_uri.p-utf8, local_name.p-utf8)
	webkit_dom_element_query_selector.i(*domelement, selectors.p-utf8)
	webkit_dom_element_query_selector_all.i(*domelement, selectors.p-utf8)
	webkit_dom_element_remove_attribute(*domelement, name.p-utf8)
	webkit_dom_element_remove_attribute_node.i(*domelement, *old_attr)
	webkit_dom_element_remove_attribute_ns(*domelement, namespace_uri.p-utf8, local_name.p-utf8)
	webkit_dom_element_scroll_by_lines(*domelement, lines.i)
	webkit_dom_element_scroll_by_pages(*domelement, pages.i)
	webkit_dom_element_scroll_into_view(*domelement, align_with_top.l)
	webkit_dom_element_scroll_into_view_if_needed(*domelement, center_if_needed.l)
	webkit_dom_element_set_attribute(*domelement, name.p-utf8, value.p-utf8)
	webkit_dom_element_set_attribute_node.i(*domelement, *new_attr)
	webkit_dom_element_set_attribute_node_ns.i(*domelement, *new_attr)
	webkit_dom_element_set_attribute_ns(*domelement, namespace_uri.p-utf8, qualified_name.p-utf8, value.p-utf8)
	webkit_dom_element_set_scroll_left(*domelement, value.i)
	webkit_dom_element_set_scroll_top(*domelement, value.i)
	webkit_dom_element_webkit_get_animations.i(*domelement)
	webkit_dom_element_webkit_matches_selector.l(*domelement, selectors.p-utf8)
	webkit_dom_element_webkit_request_full_screen(*domelement, flags.u)
	webkit_dom_event_get_bubbles.l(*domevent)
	webkit_dom_event_get_cancel_bubble.l(*domevent)
	webkit_dom_event_get_cancelable.l(*domevent)
	webkit_dom_event_get_current_target.i(*domevent)
	webkit_dom_event_get_default_prevented.l(*domevent)
	webkit_dom_event_get_event_phase.u(*domevent)
	webkit_dom_event_get_return_value.l(*domevent)
	webkit_dom_event_get_src_element.i(*domevent)
	webkit_dom_event_get_target.i(*domevent)
	webkit_dom_event_get_time_stamp.l(*domevent)
	webkit_dom_event_init_event(*domevent, event_type_arg.p-utf8, can_bubble_arg.l, cancelable_arg.l)
	webkit_dom_event_prevent_default(*domevent)
	webkit_dom_event_set_cancel_bubble(*domevent, value.l)
	webkit_dom_event_set_return_value(*domevent, value.l)
	webkit_dom_event_stop_immediate_propagation(*domevent)
	webkit_dom_event_stop_propagation(*domevent)
	webkit_dom_file_get_file_name.i(*domfile)
	webkit_dom_file_get_file_size.q(*domfile)
	webkit_dom_file_get_name.i(*domfile)
	webkit_dom_file_list_get_length.i(*domfilelist)
	webkit_dom_file_list_item.i(*domfilelist, index.i)
	webkit_dom_html_anchor_element_get_access_key.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_charset.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_coords.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_hash.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_host.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_hostname.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_href.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_hreflang.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_name.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_origin.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_parameter.i(*domhtmlanchorelement, name.p-utf8)
	webkit_dom_html_anchor_element_get_pathname.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_port.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_protocol.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_rel.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_rev.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_search.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_shape.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_target.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_get_text.i(*domhtmlanchorelement)
	webkit_dom_html_anchor_element_set_access_key(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_anchor_element_set_charset(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_anchor_element_set_coords(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_anchor_element_set_hash(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_anchor_element_set_host(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_anchor_element_set_hostname(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_anchor_element_set_href(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_anchor_element_set_hreflang(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_anchor_element_set_name(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_anchor_element_set_pathname(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_anchor_element_set_port(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_anchor_element_set_protocol(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_anchor_element_set_rel(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_anchor_element_set_rev(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_anchor_element_set_search(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_anchor_element_set_shape(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_anchor_element_set_target(*domhtmlanchorelement, value.p-utf8)
	webkit_dom_html_applet_element_get_align.i(*domhtmlappletelement)
	webkit_dom_html_applet_element_get_alt.i(*domhtmlappletelement)
	webkit_dom_html_applet_element_get_archive.i(*domhtmlappletelement)
	webkit_dom_html_applet_element_get_code.i(*domhtmlappletelement)
	webkit_dom_html_applet_element_get_code_base.i(*domhtmlappletelement)
	webkit_dom_html_applet_element_get_height.i(*domhtmlappletelement)
	webkit_dom_html_applet_element_get_hspace.i(*domhtmlappletelement)
	webkit_dom_html_applet_element_get_name.i(*domhtmlappletelement)
	webkit_dom_html_applet_element_get_object.i(*domhtmlappletelement)
	webkit_dom_html_applet_element_get_vspace.i(*domhtmlappletelement)
	webkit_dom_html_applet_element_get_width.i(*domhtmlappletelement)
	webkit_dom_html_applet_element_set_align(*domhtmlappletelement, value.p-utf8)
	webkit_dom_html_applet_element_set_alt(*domhtmlappletelement, value.p-utf8)
	webkit_dom_html_applet_element_set_archive(*domhtmlappletelement, value.p-utf8)
	webkit_dom_html_applet_element_set_code(*domhtmlappletelement, value.p-utf8)
	webkit_dom_html_applet_element_set_code_base(*domhtmlappletelement, value.p-utf8)
	webkit_dom_html_applet_element_set_height(*domhtmlappletelement, value.p-utf8)
	webkit_dom_html_applet_element_set_hspace(*domhtmlappletelement, value.i)
	webkit_dom_html_applet_element_set_name(*domhtmlappletelement, value.p-utf8)
	webkit_dom_html_applet_element_set_object(*domhtmlappletelement, value.p-utf8)
	webkit_dom_html_applet_element_set_vspace(*domhtmlappletelement, value.i)
	webkit_dom_html_applet_element_set_width(*domhtmlappletelement, value.p-utf8)
	webkit_dom_html_area_element_get_access_key.i(*domhtmlareaelement)
	webkit_dom_html_area_element_get_alt.i(*domhtmlareaelement)
	webkit_dom_html_area_element_get_coords.i(*domhtmlareaelement)
	webkit_dom_html_area_element_get_hash.i(*domhtmlareaelement)
	webkit_dom_html_area_element_get_host.i(*domhtmlareaelement)
	webkit_dom_html_area_element_get_hostname.i(*domhtmlareaelement)
	webkit_dom_html_area_element_get_href.i(*domhtmlareaelement)
	webkit_dom_html_area_element_get_no_href.l(*domhtmlareaelement)
	webkit_dom_html_area_element_get_pathname.i(*domhtmlareaelement)
	webkit_dom_html_area_element_get_port.i(*domhtmlareaelement)
	webkit_dom_html_area_element_get_protocol.i(*domhtmlareaelement)
	webkit_dom_html_area_element_get_search.i(*domhtmlareaelement)
	webkit_dom_html_area_element_get_shape.i(*domhtmlareaelement)
	webkit_dom_html_area_element_get_target.i(*domhtmlareaelement)
	webkit_dom_html_area_element_set_access_key(*domhtmlareaelement, value.p-utf8)
	webkit_dom_html_area_element_set_alt(*domhtmlareaelement, value.p-utf8)
	webkit_dom_html_area_element_set_coords(*domhtmlareaelement, value.p-utf8)
	webkit_dom_html_area_element_set_href(*domhtmlareaelement, value.p-utf8)
	webkit_dom_html_area_element_set_no_href(*domhtmlareaelement, value.l)
	webkit_dom_html_area_element_set_shape(*domhtmlareaelement, value.p-utf8)
	webkit_dom_html_area_element_set_target(*domhtmlareaelement, value.p-utf8)
	webkit_dom_htmlbr_element_get_clear.i(*domhtmlbrelement)
	webkit_dom_htmlbr_element_set_clear(*domhtmlbrelement, value.p-utf8)
	webkit_dom_html_base_element_get_href.i(*domhtmlbaseelement)
	webkit_dom_html_base_element_get_target.i(*domhtmlbaseelement)
	webkit_dom_html_base_element_set_href(*domhtmlbaseelement, value.p-utf8)
	webkit_dom_html_base_element_set_target(*domhtmlbaseelement, value.p-utf8)
	webkit_dom_html_base_font_element_get_color.i(*domhtmlbasefontelement)
	webkit_dom_html_base_font_element_get_face.i(*domhtmlbasefontelement)
	webkit_dom_html_base_font_element_get_size.i(*domhtmlbasefontelement)
	webkit_dom_html_base_font_element_set_color(*domhtmlbasefontelement, value.p-utf8)
	webkit_dom_html_base_font_element_set_face(*domhtmlbasefontelement, value.p-utf8)
	webkit_dom_html_base_font_element_set_size(*domhtmlbasefontelement, value.i)
	webkit_dom_html_blockquote_element_get_cite.i(*domhtmlblockquoteelement)
	webkit_dom_html_blockquote_element_set_cite(*domhtmlblockquoteelement, value.p-utf8)
	webkit_dom_html_body_element_get_a_link.i(*domhtmlbodyelement)
	webkit_dom_html_body_element_get_background.i(*domhtmlbodyelement)
	webkit_dom_html_body_element_get_bg_color.i(*domhtmlbodyelement)
	webkit_dom_html_body_element_get_link.i(*domhtmlbodyelement)
	webkit_dom_html_body_element_get_text.i(*domhtmlbodyelement)
	webkit_dom_html_body_element_get_v_link.i(*domhtmlbodyelement)
	webkit_dom_html_body_element_set_a_link(*domhtmlbodyelement, value.p-utf8)
	webkit_dom_html_body_element_set_background(*domhtmlbodyelement, value.p-utf8)
	webkit_dom_html_body_element_set_bg_color(*domhtmlbodyelement, value.p-utf8)
	webkit_dom_html_body_element_set_link(*domhtmlbodyelement, value.p-utf8)
	webkit_dom_html_body_element_set_text(*domhtmlbodyelement, value.p-utf8)
	webkit_dom_html_body_element_set_v_link(*domhtmlbodyelement, value.p-utf8)
	webkit_dom_html_button_element_check_validity.l(*domhtmlbuttonelement)
	webkit_dom_html_button_element_click(*domhtmlbuttonelement)
	webkit_dom_html_button_element_get_access_key.i(*domhtmlbuttonelement)
	webkit_dom_html_button_element_get_autofocus.l(*domhtmlbuttonelement)
	webkit_dom_html_button_element_get_disabled.l(*domhtmlbuttonelement)
	webkit_dom_html_button_element_get_form.i(*domhtmlbuttonelement)
	webkit_dom_html_button_element_get_form_action.i(*domhtmlbuttonelement)
	webkit_dom_html_button_element_get_form_enctype.i(*domhtmlbuttonelement)
	webkit_dom_html_button_element_get_form_method.i(*domhtmlbuttonelement)
	webkit_dom_html_button_element_get_form_no_validate.l(*domhtmlbuttonelement)
	webkit_dom_html_button_element_get_form_target.i(*domhtmlbuttonelement)
	webkit_dom_html_button_element_get_labels.i(*domhtmlbuttonelement)
	webkit_dom_html_button_element_get_name.i(*domhtmlbuttonelement)
	webkit_dom_html_button_element_get_validation_message.i(*domhtmlbuttonelement)
	webkit_dom_html_button_element_get_validity.i(*domhtmlbuttonelement)
	webkit_dom_html_button_element_get_value.i(*domhtmlbuttonelement)
	webkit_dom_html_button_element_get_will_validate.l(*domhtmlbuttonelement)
	webkit_dom_html_button_element_set_access_key(*domhtmlbuttonelement, value.p-utf8)
	webkit_dom_html_button_element_set_autofocus(*domhtmlbuttonelement, value.l)
	webkit_dom_html_button_element_set_custom_validity(*domhtmlbuttonelement, error.p-utf8)
	webkit_dom_html_button_element_set_disabled(*domhtmlbuttonelement, value.l)
	webkit_dom_html_button_element_set_form_action(*domhtmlbuttonelement, value.p-utf8)
	webkit_dom_html_button_element_set_form_enctype(*domhtmlbuttonelement, value.p-utf8)
	webkit_dom_html_button_element_set_form_method(*domhtmlbuttonelement, value.p-utf8)
	webkit_dom_html_button_element_set_form_no_validate(*domhtmlbuttonelement, value.l)
	webkit_dom_html_button_element_set_form_target(*domhtmlbuttonelement, value.p-utf8)
	webkit_dom_html_button_element_set_name(*domhtmlbuttonelement, value.p-utf8)
	webkit_dom_html_button_element_set_value(*domhtmlbuttonelement, value.p-utf8)
	webkit_dom_html_canvas_element_get_height.i(*domhtmlcanvaselement)
	webkit_dom_html_canvas_element_get_width.i(*domhtmlcanvaselement)
	webkit_dom_html_canvas_element_set_height(*domhtmlcanvaselement, value.i)
	webkit_dom_html_canvas_element_set_width(*domhtmlcanvaselement, value.i)
	webkit_dom_html_collection_get_length.i(*domhtmlcollection)
	webkit_dom_html_collection_item.i(*domhtmlcollection, index.i)
	webkit_dom_html_collection_named_item.i(*domhtmlcollection, name.p-utf8)
	webkit_dom_htmld_list_element_get_compact.l(*domhtmldlistelement)
	webkit_dom_htmld_list_element_set_compact(*domhtmldlistelement, value.l)
	webkit_dom_html_details_element_get_open.l(*domhtmldetailselement)
	webkit_dom_html_details_element_set_open(*domhtmldetailselement, value.l)
	webkit_dom_html_directory_element_get_compact.l(*domhtmldirectoryelement)
	webkit_dom_html_directory_element_set_compact(*domhtmldirectoryelement, value.l)
	webkit_dom_html_div_element_get_align.i(*domhtmldivelement)
	webkit_dom_html_div_element_set_align(*domhtmldivelement, value.p-utf8)
	webkit_dom_html_document_capture_events(*domhtmldocument)
	webkit_dom_html_document_clear(*domhtmldocument)
	webkit_dom_html_document_close(*domhtmldocument)
	webkit_dom_html_document_get_active_element.i(*domhtmldocument)
	webkit_dom_html_document_get_alink_color.i(*domhtmldocument)
	webkit_dom_html_document_get_bg_color.i(*domhtmldocument)
	webkit_dom_html_document_get_compat_mode.i(*domhtmldocument)
	webkit_dom_html_document_get_design_mode.i(*domhtmldocument)
	webkit_dom_html_document_get_dir.i(*domhtmldocument)
	webkit_dom_html_document_get_embeds.i(*domhtmldocument)
	webkit_dom_html_document_get_fg_color.i(*domhtmldocument)
	webkit_dom_html_document_get_height.i(*domhtmldocument)
	webkit_dom_html_document_get_link_color.i(*domhtmldocument)
	webkit_dom_html_document_get_plugins.i(*domhtmldocument)
	webkit_dom_html_document_get_scripts.i(*domhtmldocument)
	webkit_dom_html_document_get_vlink_color.i(*domhtmldocument)
	webkit_dom_html_document_get_width.i(*domhtmldocument)
	webkit_dom_html_document_has_focus.l(*domhtmldocument)
	webkit_dom_html_document_release_events(*domhtmldocument)
	webkit_dom_html_document_set_alink_color(*domhtmldocument, value.p-utf8)
	webkit_dom_html_document_set_bg_color(*domhtmldocument, value.p-utf8)
	webkit_dom_html_document_set_design_mode(*domhtmldocument, value.p-utf8)
	webkit_dom_html_document_set_dir(*domhtmldocument, value.p-utf8)
	webkit_dom_html_document_set_fg_color(*domhtmldocument, value.p-utf8)
	webkit_dom_html_document_set_link_color(*domhtmldocument, value.p-utf8)
	webkit_dom_html_document_set_vlink_color(*domhtmldocument, value.p-utf8)
	webkit_dom_html_element_get_children.i(*domhtmlelement)
	webkit_dom_html_element_get_class_list.i(*domhtmlelement)
	webkit_dom_html_element_get_class_name.i(*domhtmlelement)
	webkit_dom_html_element_get_content_editable.i(*domhtmlelement)
	webkit_dom_html_element_get_dir.i(*domhtmlelement)
	webkit_dom_html_element_get_draggable.l(*domhtmlelement)
	webkit_dom_html_element_get_hidden.l(*domhtmlelement)
	webkit_dom_html_element_get_id.i(*domhtmlelement)
	webkit_dom_html_element_get_inner_html.i(*domhtmlelement)
	webkit_dom_html_element_get_inner_text.i(*domhtmlelement)
	webkit_dom_html_element_get_is_content_editable.l(*domhtmlelement)
	webkit_dom_html_element_get_lang.i(*domhtmlelement)
	webkit_dom_html_element_get_outer_html.i(*domhtmlelement)
	webkit_dom_html_element_get_outer_text.i(*domhtmlelement)
	webkit_dom_html_element_get_spellcheck.l(*domhtmlelement)
	webkit_dom_html_element_get_tab_index.i(*domhtmlelement)
	webkit_dom_html_element_get_title.i(*domhtmlelement)
	webkit_dom_html_element_insert_adjacent_element.i(*domhtmlelement, where.p-utf8, *element)
	webkit_dom_html_element_insert_adjacent_html(*domhtmlelement, where.p-utf8, html.p-utf8)
	webkit_dom_html_element_insert_adjacent_text(*domhtmlelement, where.p-utf8, text.p-utf8)
	webkit_dom_html_element_set_class_name(*domhtmlelement, value.p-utf8)
	webkit_dom_html_element_set_content_editable(*domhtmlelement, value.p-utf8)
	webkit_dom_html_element_set_dir(*domhtmlelement, value.p-utf8)
	webkit_dom_html_element_set_draggable(*domhtmlelement, value.l)
	webkit_dom_html_element_set_hidden(*domhtmlelement, value.l)
	webkit_dom_html_element_set_id(*domhtmlelement, value.p-utf8)
	webkit_dom_html_element_set_inner_html(*domhtmlelement, value.p-utf8)
	webkit_dom_html_element_set_inner_text(*domhtmlelement, value.p-utf8)
	webkit_dom_html_element_set_lang(*domhtmlelement, value.p-utf8)
	webkit_dom_html_element_set_outer_html(*domhtmlelement, value.p-utf8)
	webkit_dom_html_element_set_outer_text(*domhtmlelement, value.p-utf8)
	webkit_dom_html_element_set_spellcheck(*domhtmlelement, value.l)
	webkit_dom_html_element_set_tab_index(*domhtmlelement, value.i)
	webkit_dom_html_element_set_title(*domhtmlelement, value.p-utf8)
	webkit_dom_html_embed_element_get_align.i(*domhtmlembedelement)
	webkit_dom_html_embed_element_get_height.i(*domhtmlembedelement)
	webkit_dom_html_embed_element_get_name.i(*domhtmlembedelement)
	webkit_dom_html_embed_element_get_src.i(*domhtmlembedelement)
	webkit_dom_html_embed_element_get_width.i(*domhtmlembedelement)
	webkit_dom_html_embed_element_set_align(*domhtmlembedelement, value.p-utf8)
	webkit_dom_html_embed_element_set_height(*domhtmlembedelement, value.i)
	webkit_dom_html_embed_element_set_name(*domhtmlembedelement, value.p-utf8)
	webkit_dom_html_embed_element_set_src(*domhtmlembedelement, value.p-utf8)
	webkit_dom_html_embed_element_set_width(*domhtmlembedelement, value.i)
	webkit_dom_html_field_set_element_check_validity.l(*domhtmlfieldsetelement)
	webkit_dom_html_field_set_element_get_form.i(*domhtmlfieldsetelement)
	webkit_dom_html_field_set_element_get_validation_message.i(*domhtmlfieldsetelement)
	webkit_dom_html_field_set_element_get_validity.i(*domhtmlfieldsetelement)
	webkit_dom_html_field_set_element_get_will_validate.l(*domhtmlfieldsetelement)
	webkit_dom_html_field_set_element_set_custom_validity(*domhtmlfieldsetelement, error.p-utf8)
	webkit_dom_html_font_element_get_color.i(*domhtmlfontelement)
	webkit_dom_html_font_element_get_face.i(*domhtmlfontelement)
	webkit_dom_html_font_element_get_size.i(*domhtmlfontelement)
	webkit_dom_html_font_element_set_color(*domhtmlfontelement, value.p-utf8)
	webkit_dom_html_font_element_set_face(*domhtmlfontelement, value.p-utf8)
	webkit_dom_html_font_element_set_size(*domhtmlfontelement, value.p-utf8)
	webkit_dom_html_form_element_check_validity.l(*domhtmlformelement)
	webkit_dom_html_form_element_dispatch_form_change(*domhtmlformelement)
	webkit_dom_html_form_element_dispatch_form_input(*domhtmlformelement)
	webkit_dom_html_form_element_get_accept_charset.i(*domhtmlformelement)
	webkit_dom_html_form_element_get_action.i(*domhtmlformelement)
	webkit_dom_html_form_element_get_elements.i(*domhtmlformelement)
	webkit_dom_html_form_element_get_encoding.i(*domhtmlformelement)
	webkit_dom_html_form_element_get_enctype.i(*domhtmlformelement)
	webkit_dom_html_form_element_get_length.i(*domhtmlformelement)
	webkit_dom_html_form_element_get_method.i(*domhtmlformelement)
	webkit_dom_html_form_element_get_name.i(*domhtmlformelement)
	webkit_dom_html_form_element_get_no_validate.l(*domhtmlformelement)
	webkit_dom_html_form_element_get_target.i(*domhtmlformelement)
	webkit_dom_html_form_element_reset(*domhtmlformelement)
	webkit_dom_html_form_element_set_accept_charset(*domhtmlformelement, value.p-utf8)
	webkit_dom_html_form_element_set_action(*domhtmlformelement, value.p-utf8)
	webkit_dom_html_form_element_set_encoding(*domhtmlformelement, value.p-utf8)
	webkit_dom_html_form_element_set_enctype(*domhtmlformelement, value.p-utf8)
	webkit_dom_html_form_element_set_method(*domhtmlformelement, value.p-utf8)
	webkit_dom_html_form_element_set_name(*domhtmlformelement, value.p-utf8)
	webkit_dom_html_form_element_set_no_validate(*domhtmlformelement, value.l)
	webkit_dom_html_form_element_set_target(*domhtmlformelement, value.p-utf8)
	webkit_dom_html_form_element_submit(*domhtmlformelement)
	webkit_dom_html_frame_element_get_content_document.i(*domhtmlframeelement)
	webkit_dom_html_frame_element_get_content_window.i(*domhtmlframeelement)
	webkit_dom_html_frame_element_get_frame_border.i(*domhtmlframeelement)
	webkit_dom_html_frame_element_get_height.i(*domhtmlframeelement)
	webkit_dom_html_frame_element_get_long_desc.i(*domhtmlframeelement)
	webkit_dom_html_frame_element_get_margin_height.i(*domhtmlframeelement)
	webkit_dom_html_frame_element_get_margin_width.i(*domhtmlframeelement)
	webkit_dom_html_frame_element_get_name.i(*domhtmlframeelement)
	webkit_dom_html_frame_element_get_no_resize.l(*domhtmlframeelement)
	webkit_dom_html_frame_element_get_scrolling.i(*domhtmlframeelement)
	webkit_dom_html_frame_element_get_src.i(*domhtmlframeelement)
	webkit_dom_html_frame_element_get_width.i(*domhtmlframeelement)
	webkit_dom_html_frame_element_set_frame_border(*domhtmlframeelement, value.p-utf8)
	webkit_dom_html_frame_element_set_long_desc(*domhtmlframeelement, value.p-utf8)
	webkit_dom_html_frame_element_set_margin_height(*domhtmlframeelement, value.p-utf8)
	webkit_dom_html_frame_element_set_margin_width(*domhtmlframeelement, value.p-utf8)
	webkit_dom_html_frame_element_set_name(*domhtmlframeelement, value.p-utf8)
	webkit_dom_html_frame_element_set_no_resize(*domhtmlframeelement, value.l)
	webkit_dom_html_frame_element_set_scrolling(*domhtmlframeelement, value.p-utf8)
	webkit_dom_html_frame_element_set_src(*domhtmlframeelement, value.p-utf8)
	webkit_dom_html_frame_set_element_get_cols.i(*domhtmlframesetelement)
	webkit_dom_html_frame_set_element_get_rows.i(*domhtmlframesetelement)
	webkit_dom_html_frame_set_element_set_cols(*domhtmlframesetelement, value.p-utf8)
	webkit_dom_html_frame_set_element_set_rows(*domhtmlframesetelement, value.p-utf8)
	webkit_dom_htmlhr_element_get_align.i(*domhtmlhrelement)
	webkit_dom_htmlhr_element_get_no_shade.l(*domhtmlhrelement)
	webkit_dom_htmlhr_element_get_size.i(*domhtmlhrelement)
	webkit_dom_htmlhr_element_get_width.i(*domhtmlhrelement)
	webkit_dom_htmlhr_element_set_align(*domhtmlhrelement, value.p-utf8)
	webkit_dom_htmlhr_element_set_no_shade(*domhtmlhrelement, value.l)
	webkit_dom_htmlhr_element_set_size(*domhtmlhrelement, value.p-utf8)
	webkit_dom_htmlhr_element_set_width(*domhtmlhrelement, value.p-utf8)
	webkit_dom_html_head_element_get_profile.i(*domhtmlheadelement)
	webkit_dom_html_head_element_set_profile(*domhtmlheadelement, value.p-utf8)
	webkit_dom_html_heading_element_get_align.i(*domhtmlheadingelement)
	webkit_dom_html_heading_element_set_align(*domhtmlheadingelement, value.p-utf8)
	webkit_dom_html_html_element_get_manifest.i(*domhtmlhtmlelement)
	webkit_dom_html_html_element_get_version.i(*domhtmlhtmlelement)
	webkit_dom_html_html_element_set_manifest(*domhtmlhtmlelement, value.p-utf8)
	webkit_dom_html_html_element_set_version(*domhtmlhtmlelement, value.p-utf8)
	webkit_dom_html_iframe_element_get_align.i(*domhtmliframeelement)
	webkit_dom_html_iframe_element_get_content_document.i(*domhtmliframeelement)
	webkit_dom_html_iframe_element_get_content_window.i(*domhtmliframeelement)
	webkit_dom_html_iframe_element_get_frame_border.i(*domhtmliframeelement)
	webkit_dom_html_iframe_element_get_height.i(*domhtmliframeelement)
	webkit_dom_html_iframe_element_get_long_desc.i(*domhtmliframeelement)
	webkit_dom_html_iframe_element_get_margin_height.i(*domhtmliframeelement)
	webkit_dom_html_iframe_element_get_margin_width.i(*domhtmliframeelement)
	webkit_dom_html_iframe_element_get_name.i(*domhtmliframeelement)
	webkit_dom_html_iframe_element_get_sandbox.i(*domhtmliframeelement)
	webkit_dom_html_iframe_element_get_scrolling.i(*domhtmliframeelement)
	webkit_dom_html_iframe_element_get_src.i(*domhtmliframeelement)
	webkit_dom_html_iframe_element_get_width.i(*domhtmliframeelement)
	webkit_dom_html_iframe_element_set_align(*domhtmliframeelement, value.p-utf8)
	webkit_dom_html_iframe_element_set_frame_border(*domhtmliframeelement, value.p-utf8)
	webkit_dom_html_iframe_element_set_height(*domhtmliframeelement, value.p-utf8)
	webkit_dom_html_iframe_element_set_long_desc(*domhtmliframeelement, value.p-utf8)
	webkit_dom_html_iframe_element_set_margin_height(*domhtmliframeelement, value.p-utf8)
	webkit_dom_html_iframe_element_set_margin_width(*domhtmliframeelement, value.p-utf8)
	webkit_dom_html_iframe_element_set_name(*domhtmliframeelement, value.p-utf8)
	webkit_dom_html_iframe_element_set_sandbox(*domhtmliframeelement, value.p-utf8)
	webkit_dom_html_iframe_element_set_scrolling(*domhtmliframeelement, value.p-utf8)
	webkit_dom_html_iframe_element_set_src(*domhtmliframeelement, value.p-utf8)
	webkit_dom_html_iframe_element_set_width(*domhtmliframeelement, value.p-utf8)
	webkit_dom_html_image_element_get_align.i(*domhtmlimageelement)
	webkit_dom_html_image_element_get_alt.i(*domhtmlimageelement)
	webkit_dom_html_image_element_get_border.i(*domhtmlimageelement)
	webkit_dom_html_image_element_get_complete.l(*domhtmlimageelement)
	webkit_dom_html_image_element_get_height.i(*domhtmlimageelement)
	webkit_dom_html_image_element_get_hspace.i(*domhtmlimageelement)
	webkit_dom_html_image_element_get_is_map.l(*domhtmlimageelement)
	webkit_dom_html_image_element_get_long_desc.i(*domhtmlimageelement)
	webkit_dom_html_image_element_get_lowsrc.i(*domhtmlimageelement)
	webkit_dom_html_image_element_get_name.i(*domhtmlimageelement)
	webkit_dom_html_image_element_get_natural_height.i(*domhtmlimageelement)
	webkit_dom_html_image_element_get_natural_width.i(*domhtmlimageelement)
	webkit_dom_html_image_element_get_src.i(*domhtmlimageelement)
	webkit_dom_html_image_element_get_use_map.i(*domhtmlimageelement)
	webkit_dom_html_image_element_get_vspace.i(*domhtmlimageelement)
	webkit_dom_html_image_element_get_width.i(*domhtmlimageelement)
	webkit_dom_html_image_element_get_x.i(*domhtmlimageelement)
	webkit_dom_html_image_element_get_y.i(*domhtmlimageelement)
	webkit_dom_html_image_element_set_align(*domhtmlimageelement, value.p-utf8)
	webkit_dom_html_image_element_set_alt(*domhtmlimageelement, value.p-utf8)
	webkit_dom_html_image_element_set_border(*domhtmlimageelement, value.p-utf8)
	webkit_dom_html_image_element_set_height(*domhtmlimageelement, value.i)
	webkit_dom_html_image_element_set_hspace(*domhtmlimageelement, value.i)
	webkit_dom_html_image_element_set_is_map(*domhtmlimageelement, value.l)
	webkit_dom_html_image_element_set_long_desc(*domhtmlimageelement, value.p-utf8)
	webkit_dom_html_image_element_set_lowsrc(*domhtmlimageelement, value.p-utf8)
	webkit_dom_html_image_element_set_name(*domhtmlimageelement, value.p-utf8)
	webkit_dom_html_image_element_set_src(*domhtmlimageelement, value.p-utf8)
	webkit_dom_html_image_element_set_use_map(*domhtmlimageelement, value.p-utf8)
	webkit_dom_html_image_element_set_vspace(*domhtmlimageelement, value.i)
	webkit_dom_html_image_element_set_width(*domhtmlimageelement, value.i)
	webkit_dom_html_input_element_check_validity.l(*domhtmlinputelement)
	webkit_dom_html_input_element_click(*domhtmlinputelement)
	webkit_dom_html_input_element_get_accept.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_access_key.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_align.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_alt.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_autofocus.l(*domhtmlinputelement)
	webkit_dom_html_input_element_get_checked.l(*domhtmlinputelement)
	webkit_dom_html_input_element_get_default_checked.l(*domhtmlinputelement)
	webkit_dom_html_input_element_get_default_value.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_disabled.l(*domhtmlinputelement)
	webkit_dom_html_input_element_get_files.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_form.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_form_action.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_form_enctype.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_form_method.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_form_no_validate.l(*domhtmlinputelement)
	webkit_dom_html_input_element_get_form_target.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_incremental.l(*domhtmlinputelement)
	webkit_dom_html_input_element_get_indeterminate.l(*domhtmlinputelement)
	webkit_dom_html_input_element_get_labels.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_list.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_max.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_max_length.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_min.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_multiple.l(*domhtmlinputelement)
	webkit_dom_html_input_element_get_name.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_pattern.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_placeholder.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_read_only.l(*domhtmlinputelement)
	webkit_dom_html_input_element_get_required.l(*domhtmlinputelement)
	webkit_dom_html_input_element_get_selected_option.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_size.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_src.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_step.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_use_map.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_validation_message.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_validity.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_value.i(*domhtmlinputelement)
	webkit_dom_html_input_element_get_value_as_number.d(*domhtmlinputelement)
	webkit_dom_html_input_element_get_will_validate.l(*domhtmlinputelement)
	webkit_dom_html_input_element_select(*domhtmlinputelement)
	webkit_dom_html_input_element_set_accept(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_access_key(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_align(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_alt(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_autofocus(*domhtmlinputelement, value.l)
	webkit_dom_html_input_element_set_checked(*domhtmlinputelement, value.l)
	webkit_dom_html_input_element_set_custom_validity(*domhtmlinputelement, error.p-utf8)
	webkit_dom_html_input_element_set_default_checked(*domhtmlinputelement, value.l)
	webkit_dom_html_input_element_set_default_value(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_disabled(*domhtmlinputelement, value.l)
	webkit_dom_html_input_element_set_form_action(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_form_enctype(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_form_method(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_form_no_validate(*domhtmlinputelement, value.l)
	webkit_dom_html_input_element_set_form_target(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_incremental(*domhtmlinputelement, value.l)
	webkit_dom_html_input_element_set_indeterminate(*domhtmlinputelement, value.l)
	webkit_dom_html_input_element_set_max(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_max_length(*domhtmlinputelement, value.i)
	webkit_dom_html_input_element_set_min(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_multiple(*domhtmlinputelement, value.l)
	webkit_dom_html_input_element_set_name(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_pattern(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_placeholder(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_read_only(*domhtmlinputelement, value.l)
	webkit_dom_html_input_element_set_required(*domhtmlinputelement, value.l)
	webkit_dom_html_input_element_set_size(*domhtmlinputelement, value.i)
	webkit_dom_html_input_element_set_src(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_step(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_use_map(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_value(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_set_value_as_number(*domhtmlinputelement, value.d)
	webkit_dom_html_input_element_set_value_for_user(*domhtmlinputelement, value.p-utf8)
	webkit_dom_html_input_element_step_down(*domhtmlinputelement, n.i)
	webkit_dom_html_input_element_step_up(*domhtmlinputelement, n.i)
	webkit_dom_html_is_index_element_get_form.i(*domhtmlisindexelement)
	webkit_dom_html_is_index_element_get_prompt.i(*domhtmlisindexelement)
	webkit_dom_html_is_index_element_set_prompt(*domhtmlisindexelement, value.p-utf8)
	webkit_dom_html_keygen_element_check_validity.l(*domhtmlkeygenelement)
	webkit_dom_html_keygen_element_get_autofocus.l(*domhtmlkeygenelement)
	webkit_dom_html_keygen_element_get_challenge.i(*domhtmlkeygenelement)
	webkit_dom_html_keygen_element_get_disabled.l(*domhtmlkeygenelement)
	webkit_dom_html_keygen_element_get_form.i(*domhtmlkeygenelement)
	webkit_dom_html_keygen_element_get_keytype.i(*domhtmlkeygenelement)
	webkit_dom_html_keygen_element_get_labels.i(*domhtmlkeygenelement)
	webkit_dom_html_keygen_element_get_name.i(*domhtmlkeygenelement)
	webkit_dom_html_keygen_element_get_validation_message.i(*domhtmlkeygenelement)
	webkit_dom_html_keygen_element_get_validity.i(*domhtmlkeygenelement)
	webkit_dom_html_keygen_element_get_will_validate.l(*domhtmlkeygenelement)
	webkit_dom_html_keygen_element_set_autofocus(*domhtmlkeygenelement, value.l)
	webkit_dom_html_keygen_element_set_challenge(*domhtmlkeygenelement, value.p-utf8)
	webkit_dom_html_keygen_element_set_custom_validity(*domhtmlkeygenelement, error.p-utf8)
	webkit_dom_html_keygen_element_set_disabled(*domhtmlkeygenelement, value.l)
	webkit_dom_html_keygen_element_set_keytype(*domhtmlkeygenelement, value.p-utf8)
	webkit_dom_html_keygen_element_set_name(*domhtmlkeygenelement, value.p-utf8)
	webkit_dom_htmlli_element_get_value.i(*domhtmllielement)
	webkit_dom_htmlli_element_set_value(*domhtmllielement, value.i)
	webkit_dom_html_label_element_get_access_key.i(*domhtmllabelelement)
	webkit_dom_html_label_element_get_control.i(*domhtmllabelelement)
	webkit_dom_html_label_element_get_form.i(*domhtmllabelelement)
	webkit_dom_html_label_element_get_html_for.i(*domhtmllabelelement)
	webkit_dom_html_label_element_set_access_key(*domhtmllabelelement, value.p-utf8)
	webkit_dom_html_label_element_set_html_for(*domhtmllabelelement, value.p-utf8)
	webkit_dom_html_legend_element_get_access_key.i(*domhtmllegendelement)
	webkit_dom_html_legend_element_get_align.i(*domhtmllegendelement)
	webkit_dom_html_legend_element_get_form.i(*domhtmllegendelement)
	webkit_dom_html_legend_element_set_access_key(*domhtmllegendelement, value.p-utf8)
	webkit_dom_html_legend_element_set_align(*domhtmllegendelement, value.p-utf8)
	webkit_dom_html_link_element_get_charset.i(*domhtmllinkelement)
	webkit_dom_html_link_element_get_disabled.l(*domhtmllinkelement)
	webkit_dom_html_link_element_get_href.i(*domhtmllinkelement)
	webkit_dom_html_link_element_get_hreflang.i(*domhtmllinkelement)
	webkit_dom_html_link_element_get_media.i(*domhtmllinkelement)
	webkit_dom_html_link_element_get_rel.i(*domhtmllinkelement)
	webkit_dom_html_link_element_get_rev.i(*domhtmllinkelement)
	webkit_dom_html_link_element_get_sheet.i(*domhtmllinkelement)
	webkit_dom_html_link_element_get_target.i(*domhtmllinkelement)
	webkit_dom_html_link_element_set_charset(*domhtmllinkelement, value.p-utf8)
	webkit_dom_html_link_element_set_disabled(*domhtmllinkelement, value.l)
	webkit_dom_html_link_element_set_href(*domhtmllinkelement, value.p-utf8)
	webkit_dom_html_link_element_set_hreflang(*domhtmllinkelement, value.p-utf8)
	webkit_dom_html_link_element_set_media(*domhtmllinkelement, value.p-utf8)
	webkit_dom_html_link_element_set_rel(*domhtmllinkelement, value.p-utf8)
	webkit_dom_html_link_element_set_rev(*domhtmllinkelement, value.p-utf8)
	webkit_dom_html_link_element_set_target(*domhtmllinkelement, value.p-utf8)
	webkit_dom_html_map_element_get_areas.i(*domhtmlmapelement)
	webkit_dom_html_map_element_get_name.i(*domhtmlmapelement)
	webkit_dom_html_map_element_set_name(*domhtmlmapelement, value.p-utf8)
	webkit_dom_html_marquee_element_get_behavior.i(*domhtmlmarqueeelement)
	webkit_dom_html_marquee_element_get_bg_color.i(*domhtmlmarqueeelement)
	webkit_dom_html_marquee_element_get_direction.i(*domhtmlmarqueeelement)
	webkit_dom_html_marquee_element_get_height.i(*domhtmlmarqueeelement)
	webkit_dom_html_marquee_element_get_hspace.i(*domhtmlmarqueeelement)
	webkit_dom_html_marquee_element_get_loop.i(*domhtmlmarqueeelement)
	webkit_dom_html_marquee_element_get_scroll_amount.i(*domhtmlmarqueeelement)
	webkit_dom_html_marquee_element_get_scroll_delay.i(*domhtmlmarqueeelement)
	webkit_dom_html_marquee_element_get_true_speed.l(*domhtmlmarqueeelement)
	webkit_dom_html_marquee_element_get_vspace.i(*domhtmlmarqueeelement)
	webkit_dom_html_marquee_element_get_width.i(*domhtmlmarqueeelement)
	webkit_dom_html_marquee_element_set_behavior(*domhtmlmarqueeelement, value.p-utf8)
	webkit_dom_html_marquee_element_set_bg_color(*domhtmlmarqueeelement, value.p-utf8)
	webkit_dom_html_marquee_element_set_direction(*domhtmlmarqueeelement, value.p-utf8)
	webkit_dom_html_marquee_element_set_height(*domhtmlmarqueeelement, value.p-utf8)
	webkit_dom_html_marquee_element_set_hspace(*domhtmlmarqueeelement, value.i)
	webkit_dom_html_marquee_element_set_loop(*domhtmlmarqueeelement, value.i)
	webkit_dom_html_marquee_element_set_scroll_amount(*domhtmlmarqueeelement, value.i)
	webkit_dom_html_marquee_element_set_scroll_delay(*domhtmlmarqueeelement, value.i)
	webkit_dom_html_marquee_element_set_true_speed(*domhtmlmarqueeelement, value.l)
	webkit_dom_html_marquee_element_set_vspace(*domhtmlmarqueeelement, value.i)
	webkit_dom_html_marquee_element_set_width(*domhtmlmarqueeelement, value.p-utf8)
	webkit_dom_html_marquee_element_start(*domhtmlmarqueeelement)
	webkit_dom_html_marquee_element_stop(*domhtmlmarqueeelement)
	webkit_dom_html_media_element_can_play_type.i(*domhtmlmediaelement, type.p-utf8)
	webkit_dom_html_media_element_get_autoplay.l(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_buffered.i(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_controls.l(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_current_src.i(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_current_time.f(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_default_playback_rate.f(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_duration.f(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_ended.l(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_error.i(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_loop.l(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_muted.l(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_network_state.u(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_paused.l(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_playback_rate.f(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_played.i(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_preload.i(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_ready_state.u(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_seekable.i(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_seeking.l(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_src.i(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_start_time.f(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_volume.f(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_webkit_closed_captions_visible.l(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_webkit_has_closed_captions.l(*domhtmlmediaelement)
	webkit_dom_html_media_element_get_webkit_preserves_pitch.l(*domhtmlmediaelement)
	webkit_dom_html_media_element_load(*domhtmlmediaelement, isUserGesture.l)
	webkit_dom_html_media_element_pause(*domhtmlmediaelement, isUserGesture.l)
	webkit_dom_html_media_element_play(*domhtmlmediaelement, isUserGesture.l)
	webkit_dom_html_media_element_set_autoplay(*domhtmlmediaelement, value.l)
	webkit_dom_html_media_element_set_controls(*domhtmlmediaelement, value.l)
	webkit_dom_html_media_element_set_current_time(*domhtmlmediaelement, value.f)
	webkit_dom_html_media_element_set_default_playback_rate(*domhtmlmediaelement, value.f)
	webkit_dom_html_media_element_set_loop(*domhtmlmediaelement, value.l)
	webkit_dom_html_media_element_set_muted(*domhtmlmediaelement, value.l)
	webkit_dom_html_media_element_set_playback_rate(*domhtmlmediaelement, value.f)
	webkit_dom_html_media_element_set_preload(*domhtmlmediaelement, value.p-utf8)
	webkit_dom_html_media_element_set_src(*domhtmlmediaelement, value.p-utf8)
	webkit_dom_html_media_element_set_volume(*domhtmlmediaelement, value.f)
	webkit_dom_html_media_element_set_webkit_closed_captions_visible(*domhtmlmediaelement, value.l)
	webkit_dom_html_media_element_set_webkit_preserves_pitch(*domhtmlmediaelement, value.l)
	webkit_dom_html_menu_element_get_compact.l(*domhtmlmenuelement)
	webkit_dom_html_menu_element_set_compact(*domhtmlmenuelement, value.l)
	webkit_dom_html_meta_element_get_content.i(*domhtmlmetaelement)
	webkit_dom_html_meta_element_get_http_equiv.i(*domhtmlmetaelement)
	webkit_dom_html_meta_element_get_name.i(*domhtmlmetaelement)
	webkit_dom_html_meta_element_get_scheme.i(*domhtmlmetaelement)
	webkit_dom_html_meta_element_set_content(*domhtmlmetaelement, value.p-utf8)
	webkit_dom_html_meta_element_set_http_equiv(*domhtmlmetaelement, value.p-utf8)
	webkit_dom_html_meta_element_set_name(*domhtmlmetaelement, value.p-utf8)
	webkit_dom_html_meta_element_set_scheme(*domhtmlmetaelement, value.p-utf8)
	webkit_dom_html_mod_element_get_cite.i(*domhtmlmodelement)
	webkit_dom_html_mod_element_get_date_time.i(*domhtmlmodelement)
	webkit_dom_html_mod_element_set_cite(*domhtmlmodelement, value.p-utf8)
	webkit_dom_html_mod_element_set_date_time(*domhtmlmodelement, value.p-utf8)
	webkit_dom_htmlo_list_element_get_compact.l(*domhtmlolistelement)
	webkit_dom_htmlo_list_element_get_start.i(*domhtmlolistelement)
	webkit_dom_htmlo_list_element_set_compact(*domhtmlolistelement, value.l)
	webkit_dom_htmlo_list_element_set_start(*domhtmlolistelement, value.i)
	webkit_dom_html_object_element_check_validity.l(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_align.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_archive.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_border.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_code.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_code_base.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_code_type.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_content_document.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_data.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_declare.l(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_form.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_height.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_hspace.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_name.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_standby.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_use_map.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_validation_message.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_validity.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_vspace.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_width.i(*domhtmlobjectelement)
	webkit_dom_html_object_element_get_will_validate.l(*domhtmlobjectelement)
	webkit_dom_html_object_element_set_align(*domhtmlobjectelement, value.p-utf8)
	webkit_dom_html_object_element_set_archive(*domhtmlobjectelement, value.p-utf8)
	webkit_dom_html_object_element_set_border(*domhtmlobjectelement, value.p-utf8)
	webkit_dom_html_object_element_set_code(*domhtmlobjectelement, value.p-utf8)
	webkit_dom_html_object_element_set_code_base(*domhtmlobjectelement, value.p-utf8)
	webkit_dom_html_object_element_set_code_type(*domhtmlobjectelement, value.p-utf8)
	webkit_dom_html_object_element_set_custom_validity(*domhtmlobjectelement, error.p-utf8)
	webkit_dom_html_object_element_set_data(*domhtmlobjectelement, value.p-utf8)
	webkit_dom_html_object_element_set_declare(*domhtmlobjectelement, value.l)
	webkit_dom_html_object_element_set_height(*domhtmlobjectelement, value.p-utf8)
	webkit_dom_html_object_element_set_hspace(*domhtmlobjectelement, value.i)
	webkit_dom_html_object_element_set_name(*domhtmlobjectelement, value.p-utf8)
	webkit_dom_html_object_element_set_standby(*domhtmlobjectelement, value.p-utf8)
	webkit_dom_html_object_element_set_use_map(*domhtmlobjectelement, value.p-utf8)
	webkit_dom_html_object_element_set_vspace(*domhtmlobjectelement, value.i)
	webkit_dom_html_object_element_set_width(*domhtmlobjectelement, value.p-utf8)
	webkit_dom_html_opt_group_element_get_disabled.l(*domhtmloptgroupelement)
	webkit_dom_html_opt_group_element_get_label.i(*domhtmloptgroupelement)
	webkit_dom_html_opt_group_element_set_disabled(*domhtmloptgroupelement, value.l)
	webkit_dom_html_opt_group_element_set_label(*domhtmloptgroupelement, value.p-utf8)
	webkit_dom_html_option_element_get_default_selected.l(*domhtmloptionelement)
	webkit_dom_html_option_element_get_disabled.l(*domhtmloptionelement)
	webkit_dom_html_option_element_get_form.i(*domhtmloptionelement)
	webkit_dom_html_option_element_get_index.i(*domhtmloptionelement)
	webkit_dom_html_option_element_get_label.i(*domhtmloptionelement)
	webkit_dom_html_option_element_get_selected.l(*domhtmloptionelement)
	webkit_dom_html_option_element_get_text.i(*domhtmloptionelement)
	webkit_dom_html_option_element_get_value.i(*domhtmloptionelement)
	webkit_dom_html_option_element_set_default_selected(*domhtmloptionelement, value.l)
	webkit_dom_html_option_element_set_disabled(*domhtmloptionelement, value.l)
	webkit_dom_html_option_element_set_label(*domhtmloptionelement, value.p-utf8)
	webkit_dom_html_option_element_set_selected(*domhtmloptionelement, value.l)
	webkit_dom_html_option_element_set_value(*domhtmloptionelement, value.p-utf8)
	webkit_dom_html_options_collection_get_selected_index.i(*domhtmloptionscollection)
	webkit_dom_html_options_collection_set_selected_index(*domhtmloptionscollection, value.i)
	webkit_dom_html_paragraph_element_get_align.i(*domhtmlparagraphelement)
	webkit_dom_html_paragraph_element_set_align(*domhtmlparagraphelement, value.p-utf8)
	webkit_dom_html_param_element_get_name.i(*domhtmlparamelement)
	webkit_dom_html_param_element_get_value.i(*domhtmlparamelement)
	webkit_dom_html_param_element_get_value_type.i(*domhtmlparamelement)
	webkit_dom_html_param_element_set_name(*domhtmlparamelement, value.p-utf8)
	webkit_dom_html_param_element_set_value(*domhtmlparamelement, value.p-utf8)
	webkit_dom_html_param_element_set_value_type(*domhtmlparamelement, value.p-utf8)
	webkit_dom_html_pre_element_get_width.i(*domhtmlpreelement)
	webkit_dom_html_pre_element_get_wrap.l(*domhtmlpreelement)
	webkit_dom_html_pre_element_set_width(*domhtmlpreelement, value.i)
	webkit_dom_html_pre_element_set_wrap(*domhtmlpreelement, value.l)
	webkit_dom_html_quote_element_get_cite.i(*domhtmlquoteelement)
	webkit_dom_html_quote_element_set_cite(*domhtmlquoteelement, value.p-utf8)
	webkit_dom_html_script_element_get_async.l(*domhtmlscriptelement)
	webkit_dom_html_script_element_get_charset.i(*domhtmlscriptelement)
	webkit_dom_html_script_element_get_defer.l(*domhtmlscriptelement)
	webkit_dom_html_script_element_get_event.i(*domhtmlscriptelement)
	webkit_dom_html_script_element_get_html_for.i(*domhtmlscriptelement)
	webkit_dom_html_script_element_get_src.i(*domhtmlscriptelement)
	webkit_dom_html_script_element_get_text.i(*domhtmlscriptelement)
	webkit_dom_html_script_element_set_async(*domhtmlscriptelement, value.l)
	webkit_dom_html_script_element_set_charset(*domhtmlscriptelement, value.p-utf8)
	webkit_dom_html_script_element_set_defer(*domhtmlscriptelement, value.l)
	webkit_dom_html_script_element_set_event(*domhtmlscriptelement, value.p-utf8)
	webkit_dom_html_script_element_set_html_for(*domhtmlscriptelement, value.p-utf8)
	webkit_dom_html_script_element_set_src(*domhtmlscriptelement, value.p-utf8)
	webkit_dom_html_script_element_set_text(*domhtmlscriptelement, value.p-utf8)
	webkit_dom_html_select_element_add(*domhtmlselectelement, *element, *before)
	webkit_dom_html_select_element_check_validity.l(*domhtmlselectelement)
	webkit_dom_html_select_element_get_autofocus.l(*domhtmlselectelement)
	webkit_dom_html_select_element_get_disabled.l(*domhtmlselectelement)
	webkit_dom_html_select_element_get_form.i(*domhtmlselectelement)
	webkit_dom_html_select_element_get_labels.i(*domhtmlselectelement)
	webkit_dom_html_select_element_get_length.i(*domhtmlselectelement)
	webkit_dom_html_select_element_get_multiple.l(*domhtmlselectelement)
	webkit_dom_html_select_element_get_name.i(*domhtmlselectelement)
	webkit_dom_html_select_element_get_options.i(*domhtmlselectelement)
	webkit_dom_html_select_element_get_required.l(*domhtmlselectelement)
	webkit_dom_html_select_element_get_selected_index.i(*domhtmlselectelement)
	webkit_dom_html_select_element_get_size.i(*domhtmlselectelement)
	webkit_dom_html_select_element_get_validation_message.i(*domhtmlselectelement)
	webkit_dom_html_select_element_get_validity.i(*domhtmlselectelement)
	webkit_dom_html_select_element_get_value.i(*domhtmlselectelement)
	webkit_dom_html_select_element_get_will_validate.l(*domhtmlselectelement)
	webkit_dom_html_select_element_item.i(*domhtmlselectelement, index.i)
	webkit_dom_html_select_element_named_item.i(*domhtmlselectelement, name.p-utf8)
	webkit_dom_html_select_element_remove(*domhtmlselectelement, index.i)
	webkit_dom_html_select_element_set_autofocus(*domhtmlselectelement, value.l)
	webkit_dom_html_select_element_set_custom_validity(*domhtmlselectelement, error.p-utf8)
	webkit_dom_html_select_element_set_disabled(*domhtmlselectelement, value.l)
	webkit_dom_html_select_element_set_length(*domhtmlselectelement, value.i)
	webkit_dom_html_select_element_set_multiple(*domhtmlselectelement, value.l)
	webkit_dom_html_select_element_set_name(*domhtmlselectelement, value.p-utf8)
	webkit_dom_html_select_element_set_required(*domhtmlselectelement, value.l)
	webkit_dom_html_select_element_set_selected_index(*domhtmlselectelement, value.i)
	webkit_dom_html_select_element_set_size(*domhtmlselectelement, value.i)
	webkit_dom_html_select_element_set_value(*domhtmlselectelement, value.p-utf8)
	webkit_dom_html_style_element_get_disabled.l(*domhtmlstyleelement)
	webkit_dom_html_style_element_get_media.i(*domhtmlstyleelement)
	webkit_dom_html_style_element_get_sheet.i(*domhtmlstyleelement)
	webkit_dom_html_style_element_set_disabled(*domhtmlstyleelement, value.l)
	webkit_dom_html_style_element_set_media(*domhtmlstyleelement, value.p-utf8)
	webkit_dom_html_table_caption_element_get_align.i(*domhtmltablecaptionelement)
	webkit_dom_html_table_caption_element_set_align(*domhtmltablecaptionelement, value.p-utf8)
	webkit_dom_html_table_cell_element_get_abbr.i(*domhtmltablecellelement)
	webkit_dom_html_table_cell_element_get_align.i(*domhtmltablecellelement)
	webkit_dom_html_table_cell_element_get_axis.i(*domhtmltablecellelement)
	webkit_dom_html_table_cell_element_get_bg_color.i(*domhtmltablecellelement)
	webkit_dom_html_table_cell_element_get_cell_index.i(*domhtmltablecellelement)
	webkit_dom_html_table_cell_element_get_ch.i(*domhtmltablecellelement)
	webkit_dom_html_table_cell_element_get_ch_off.i(*domhtmltablecellelement)
	webkit_dom_html_table_cell_element_get_col_span.i(*domhtmltablecellelement)
	webkit_dom_html_table_cell_element_get_headers.i(*domhtmltablecellelement)
	webkit_dom_html_table_cell_element_get_height.i(*domhtmltablecellelement)
	webkit_dom_html_table_cell_element_get_no_wrap.l(*domhtmltablecellelement)
	webkit_dom_html_table_cell_element_get_row_span.i(*domhtmltablecellelement)
	webkit_dom_html_table_cell_element_get_scope.i(*domhtmltablecellelement)
	webkit_dom_html_table_cell_element_get_v_align.i(*domhtmltablecellelement)
	webkit_dom_html_table_cell_element_get_width.i(*domhtmltablecellelement)
	webkit_dom_html_table_cell_element_set_abbr(*domhtmltablecellelement, value.p-utf8)
	webkit_dom_html_table_cell_element_set_align(*domhtmltablecellelement, value.p-utf8)
	webkit_dom_html_table_cell_element_set_axis(*domhtmltablecellelement, value.p-utf8)
	webkit_dom_html_table_cell_element_set_bg_color(*domhtmltablecellelement, value.p-utf8)
	webkit_dom_html_table_cell_element_set_ch(*domhtmltablecellelement, value.p-utf8)
	webkit_dom_html_table_cell_element_set_ch_off(*domhtmltablecellelement, value.p-utf8)
	webkit_dom_html_table_cell_element_set_col_span(*domhtmltablecellelement, value.i)
	webkit_dom_html_table_cell_element_set_headers(*domhtmltablecellelement, value.p-utf8)
	webkit_dom_html_table_cell_element_set_height(*domhtmltablecellelement, value.p-utf8)
	webkit_dom_html_table_cell_element_set_no_wrap(*domhtmltablecellelement, value.l)
	webkit_dom_html_table_cell_element_set_row_span(*domhtmltablecellelement, value.i)
	webkit_dom_html_table_cell_element_set_scope(*domhtmltablecellelement, value.p-utf8)
	webkit_dom_html_table_cell_element_set_v_align(*domhtmltablecellelement, value.p-utf8)
	webkit_dom_html_table_cell_element_set_width(*domhtmltablecellelement, value.p-utf8)
	webkit_dom_html_table_col_element_get_align.i(*domhtmltablecolelement)
	webkit_dom_html_table_col_element_get_ch.i(*domhtmltablecolelement)
	webkit_dom_html_table_col_element_get_ch_off.i(*domhtmltablecolelement)
	webkit_dom_html_table_col_element_get_span.i(*domhtmltablecolelement)
	webkit_dom_html_table_col_element_get_v_align.i(*domhtmltablecolelement)
	webkit_dom_html_table_col_element_get_width.i(*domhtmltablecolelement)
	webkit_dom_html_table_col_element_set_align(*domhtmltablecolelement, value.p-utf8)
	webkit_dom_html_table_col_element_set_ch(*domhtmltablecolelement, value.p-utf8)
	webkit_dom_html_table_col_element_set_ch_off(*domhtmltablecolelement, value.p-utf8)
	webkit_dom_html_table_col_element_set_span(*domhtmltablecolelement, value.i)
	webkit_dom_html_table_col_element_set_v_align(*domhtmltablecolelement, value.p-utf8)
	webkit_dom_html_table_col_element_set_width(*domhtmltablecolelement, value.p-utf8)
	webkit_dom_html_table_element_create_caption.i(*domhtmltableelement)
	webkit_dom_html_table_element_create_t_foot.i(*domhtmltableelement)
	webkit_dom_html_table_element_create_t_head.i(*domhtmltableelement)
	webkit_dom_html_table_element_delete_caption(*domhtmltableelement)
	webkit_dom_html_table_element_delete_row(*domhtmltableelement, index.i)
	webkit_dom_html_table_element_delete_t_foot(*domhtmltableelement)
	webkit_dom_html_table_element_delete_t_head(*domhtmltableelement)
	webkit_dom_html_table_element_get_align.i(*domhtmltableelement)
	webkit_dom_html_table_element_get_bg_color.i(*domhtmltableelement)
	webkit_dom_html_table_element_get_border.i(*domhtmltableelement)
	webkit_dom_html_table_element_get_caption.i(*domhtmltableelement)
	webkit_dom_html_table_element_get_cell_padding.i(*domhtmltableelement)
	webkit_dom_html_table_element_get_cell_spacing.i(*domhtmltableelement)
	webkit_dom_html_table_element_get_frame.i(*domhtmltableelement)
	webkit_dom_html_table_element_get_rows.i(*domhtmltableelement)
	webkit_dom_html_table_element_get_rules.i(*domhtmltableelement)
	webkit_dom_html_table_element_get_summary.i(*domhtmltableelement)
	webkit_dom_html_table_element_get_t_bodies.i(*domhtmltableelement)
	webkit_dom_html_table_element_get_t_foot.i(*domhtmltableelement)
	webkit_dom_html_table_element_get_t_head.i(*domhtmltableelement)
	webkit_dom_html_table_element_get_width.i(*domhtmltableelement)
	webkit_dom_html_table_element_insert_row.i(*domhtmltableelement, index.i)
	webkit_dom_html_table_element_set_align(*domhtmltableelement, value.p-utf8)
	webkit_dom_html_table_element_set_bg_color(*domhtmltableelement, value.p-utf8)
	webkit_dom_html_table_element_set_border(*domhtmltableelement, value.p-utf8)
	webkit_dom_html_table_element_set_caption(*domhtmltableelement, *value)
	webkit_dom_html_table_element_set_cell_padding(*domhtmltableelement, value.p-utf8)
	webkit_dom_html_table_element_set_cell_spacing(*domhtmltableelement, value.p-utf8)
	webkit_dom_html_table_element_set_frame(*domhtmltableelement, value.p-utf8)
	webkit_dom_html_table_element_set_rules(*domhtmltableelement, value.p-utf8)
	webkit_dom_html_table_element_set_summary(*domhtmltableelement, value.p-utf8)
	webkit_dom_html_table_element_set_t_foot(*domhtmltableelement, *value)
	webkit_dom_html_table_element_set_t_head(*domhtmltableelement, *value)
	webkit_dom_html_table_element_set_width(*domhtmltableelement, value.p-utf8)
	webkit_dom_html_table_row_element_delete_cell(*domhtmltablerowelement, index.i)
	webkit_dom_html_table_row_element_get_align.i(*domhtmltablerowelement)
	webkit_dom_html_table_row_element_get_bg_color.i(*domhtmltablerowelement)
	webkit_dom_html_table_row_element_get_cells.i(*domhtmltablerowelement)
	webkit_dom_html_table_row_element_get_ch.i(*domhtmltablerowelement)
	webkit_dom_html_table_row_element_get_ch_off.i(*domhtmltablerowelement)
	webkit_dom_html_table_row_element_get_row_index.i(*domhtmltablerowelement)
	webkit_dom_html_table_row_element_get_section_row_index.i(*domhtmltablerowelement)
	webkit_dom_html_table_row_element_get_v_align.i(*domhtmltablerowelement)
	webkit_dom_html_table_row_element_insert_cell.i(*domhtmltablerowelement, index.i)
	webkit_dom_html_table_row_element_set_align(*domhtmltablerowelement, value.p-utf8)
	webkit_dom_html_table_row_element_set_bg_color(*domhtmltablerowelement, value.p-utf8)
	webkit_dom_html_table_row_element_set_ch(*domhtmltablerowelement, value.p-utf8)
	webkit_dom_html_table_row_element_set_ch_off(*domhtmltablerowelement, value.p-utf8)
	webkit_dom_html_table_row_element_set_v_align(*domhtmltablerowelement, value.p-utf8)
	webkit_dom_html_table_section_element_delete_row(*domhtmltablesectionelement, index.i)
	webkit_dom_html_table_section_element_get_align.i(*domhtmltablesectionelement)
	webkit_dom_html_table_section_element_get_ch.i(*domhtmltablesectionelement)
	webkit_dom_html_table_section_element_get_ch_off.i(*domhtmltablesectionelement)
	webkit_dom_html_table_section_element_get_rows.i(*domhtmltablesectionelement)
	webkit_dom_html_table_section_element_get_v_align.i(*domhtmltablesectionelement)
	webkit_dom_html_table_section_element_insert_row.i(*domhtmltablesectionelement, index.i)
	webkit_dom_html_table_section_element_set_align(*domhtmltablesectionelement, value.p-utf8)
	webkit_dom_html_table_section_element_set_ch(*domhtmltablesectionelement, value.p-utf8)
	webkit_dom_html_table_section_element_set_ch_off(*domhtmltablesectionelement, value.p-utf8)
	webkit_dom_html_table_section_element_set_v_align(*domhtmltablesectionelement, value.p-utf8)
	webkit_dom_html_text_area_element_check_validity.l(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_access_key.i(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_autofocus.l(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_cols.i(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_default_value.i(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_disabled.l(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_form.i(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_labels.i(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_max_length.i(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_name.i(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_placeholder.i(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_read_only.l(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_required.l(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_rows.i(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_selection_end.i(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_selection_start.i(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_text_length.i(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_validation_message.i(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_validity.i(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_value.i(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_get_will_validate.l(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_select(*domhtmltextareaelement)
	webkit_dom_html_text_area_element_set_access_key(*domhtmltextareaelement, value.p-utf8)
	webkit_dom_html_text_area_element_set_autofocus(*domhtmltextareaelement, value.l)
	webkit_dom_html_text_area_element_set_cols(*domhtmltextareaelement, value.i)
	webkit_dom_html_text_area_element_set_custom_validity(*domhtmltextareaelement, error.p-utf8)
	webkit_dom_html_text_area_element_set_default_value(*domhtmltextareaelement, value.p-utf8)
	webkit_dom_html_text_area_element_set_disabled(*domhtmltextareaelement, value.l)
	webkit_dom_html_text_area_element_set_max_length(*domhtmltextareaelement, value.i)
	webkit_dom_html_text_area_element_set_name(*domhtmltextareaelement, value.p-utf8)
	webkit_dom_html_text_area_element_set_placeholder(*domhtmltextareaelement, value.p-utf8)
	webkit_dom_html_text_area_element_set_read_only(*domhtmltextareaelement, value.l)
	webkit_dom_html_text_area_element_set_required(*domhtmltextareaelement, value.l)
	webkit_dom_html_text_area_element_set_rows(*domhtmltextareaelement, value.i)
	webkit_dom_html_text_area_element_set_selection_end(*domhtmltextareaelement, value.i)
	webkit_dom_html_text_area_element_set_selection_range(*domhtmltextareaelement, start.i, end_.i)
	webkit_dom_html_text_area_element_set_selection_start(*domhtmltextareaelement, value.i)
	webkit_dom_html_text_area_element_set_value(*domhtmltextareaelement, value.p-utf8)
	webkit_dom_html_title_element_get_text.i(*domhtmltitleelement)
	webkit_dom_html_title_element_set_text(*domhtmltitleelement, value.p-utf8)
	webkit_dom_htmlu_list_element_get_compact.l(*domhtmlulistelement)
	webkit_dom_htmlu_list_element_set_compact(*domhtmlulistelement, value.l)
	webkit_dom_html_video_element_get_height.i(*domhtmlvideoelement)
	webkit_dom_html_video_element_get_poster.i(*domhtmlvideoelement)
	webkit_dom_html_video_element_get_video_height.i(*domhtmlvideoelement)
	webkit_dom_html_video_element_get_video_width.i(*domhtmlvideoelement)
	webkit_dom_html_video_element_get_webkit_displaying_fullscreen.l(*domhtmlvideoelement)
	webkit_dom_html_video_element_get_webkit_supports_fullscreen.l(*domhtmlvideoelement)
	webkit_dom_html_video_element_get_width.i(*domhtmlvideoelement)
	webkit_dom_html_video_element_set_height(*domhtmlvideoelement, value.i)
	webkit_dom_html_video_element_set_poster(*domhtmlvideoelement, value.p-utf8)
	webkit_dom_html_video_element_set_width(*domhtmlvideoelement, value.i)
	webkit_dom_html_video_element_webkit_enter_full_screen(*domhtmlvideoelement, isUserGesture.l)
	webkit_dom_html_video_element_webkit_enter_fullscreen(*domhtmlvideoelement, isUserGesture.l)
	webkit_dom_html_video_element_webkit_exit_full_screen(*domhtmlvideoelement)
	webkit_dom_html_video_element_webkit_exit_fullscreen(*domhtmlvideoelement)
	webkit_dom_history_back(*domhistory)
	webkit_dom_history_forward(*domhistory)
	webkit_dom_history_get_length.i(*domhistory)
	webkit_dom_history_go(*domhistory, distance.i)
	webkit_dom_location_get_origin.i(*domlocation)
	webkit_dom_location_get_parameter.i(*domlocation, name.p-utf8)
	webkit_dom_media_error_get_code.u(*dommediaerror)
	webkit_dom_media_list_append_medium(*dommedialist, new_medium.p-utf8)
	webkit_dom_media_list_delete_medium(*dommedialist, old_medium.p-utf8)
	webkit_dom_media_list_get_length.i(*dommedialist)
	webkit_dom_media_list_get_media_text.i(*dommedialist)
	webkit_dom_media_list_item.i(*dommedialist, index.i)
	webkit_dom_media_list_set_media_text(*dommedialist, value.p-utf8)
	webkit_dom_media_query_list_get_matches.l(*dommediaquerylist)
	webkit_dom_media_query_list_get_media.i(*dommediaquerylist)
	webkit_dom_memory_info_get_js_heap_size_limit.i(*dommemoryinfo)
	webkit_dom_memory_info_get_total_js_heap_size.i(*dommemoryinfo)
	webkit_dom_memory_info_get_used_js_heap_size.i(*dommemoryinfo)
	webkit_dom_mouse_event_get_alt_key.l(*dommouseevent)
	webkit_dom_mouse_event_get_button.u(*dommouseevent)
	webkit_dom_mouse_event_get_client_x.i(*dommouseevent)
	webkit_dom_mouse_event_get_client_y.i(*dommouseevent)
	webkit_dom_mouse_event_get_ctrl_key.l(*dommouseevent)
	webkit_dom_mouse_event_get_from_element.i(*dommouseevent)
	webkit_dom_mouse_event_get_meta_key.l(*dommouseevent)
	webkit_dom_mouse_event_get_offset_x.i(*dommouseevent)
	webkit_dom_mouse_event_get_offset_y.i(*dommouseevent)
	webkit_dom_mouse_event_get_related_target.i(*dommouseevent)
	webkit_dom_mouse_event_get_screen_x.i(*dommouseevent)
	webkit_dom_mouse_event_get_screen_y.i(*dommouseevent)
	webkit_dom_mouse_event_get_shift_key.l(*dommouseevent)
	webkit_dom_mouse_event_get_to_element.i(*dommouseevent)
	webkit_dom_mouse_event_get_x.i(*dommouseevent)
	webkit_dom_mouse_event_get_y.i(*dommouseevent)
	webkit_dom_mouse_event_init_mouse_event(*dommouseevent, type.p-utf8, can_bubble.l, cancelable.l, *view, detail.i, screen_x.i, screen_y.i, client_x.i, client_y.i, ctrl_key.l, alt_key.l, shift_key.l, meta_key.l, button.u, *related_target)
	webkit_dom_named_node_map_get_length.i(*domnamednodemap)
	webkit_dom_named_node_map_get_named_item.i(*domnamednodemap, name.p-utf8)
	webkit_dom_named_node_map_get_named_item_ns.i(*domnamednodemap, namespace_uri.p-utf8, local_name.p-utf8)
	webkit_dom_named_node_map_item.i(*domnamednodemap, index.i)
	webkit_dom_named_node_map_remove_named_item.i(*domnamednodemap, name.p-utf8)
	webkit_dom_named_node_map_remove_named_item_ns.i(*domnamednodemap, namespace_uri.p-utf8, local_name.p-utf8)
	webkit_dom_named_node_map_set_named_item.i(*domnamednodemap, *node)
	webkit_dom_named_node_map_set_named_item_ns.i(*domnamednodemap, *node)
	webkit_dom_navigator_get_app_code_name.i(*domnavigator)
	webkit_dom_navigator_get_app_name.i(*domnavigator)
	webkit_dom_navigator_get_app_version.i(*domnavigator)
	webkit_dom_navigator_get_cookie_enabled.l(*domnavigator)
	webkit_dom_navigator_get_language.i(*domnavigator)
	webkit_dom_navigator_get_mime_types.i(*domnavigator)
	webkit_dom_navigator_get_on_line.l(*domnavigator)
	webkit_dom_navigator_get_platform.i(*domnavigator)
	webkit_dom_navigator_get_plugins.i(*domnavigator)
	webkit_dom_navigator_get_product.i(*domnavigator)
	webkit_dom_navigator_get_product_sub.i(*domnavigator)
	webkit_dom_navigator_get_storage_updates(*domnavigator)
	webkit_dom_navigator_get_user_agent.i(*domnavigator)
	webkit_dom_navigator_get_vendor.i(*domnavigator)
	webkit_dom_navigator_get_vendor_sub.i(*domnavigator)
	webkit_dom_navigator_java_enabled.l(*domnavigator)
	webkit_dom_node_append_child.i(*domnode, *new_child)
	webkit_dom_node_clone_node.i(*domnode, deep.l)
	webkit_dom_node_compare_document_position.u(*domnode, *other)
	webkit_dom_node_dispatch_event.l(*domnode, *event)
	webkit_dom_node_get_attributes.i(*domnode)
	webkit_dom_node_get_base_uri.i(*domnode)
	webkit_dom_node_get_child_nodes.i(*domnode)
	webkit_dom_node_get_first_child.i(*domnode)
	webkit_dom_node_get_last_child.i(*domnode)
	webkit_dom_node_get_local_name.i(*domnode)
	webkit_dom_node_get_namespace_uri.i(*domnode)
	webkit_dom_node_get_next_sibling.i(*domnode)
	webkit_dom_node_get_node_name.i(*domnode)
	webkit_dom_node_get_node_type.u(*domnode)
	webkit_dom_node_get_node_value.i(*domnode)
	webkit_dom_node_get_owner_document.i(*domnode)
	webkit_dom_node_get_parent_element.i(*domnode)
	webkit_dom_node_get_parent_node.i(*domnode)
	webkit_dom_node_get_prefix.i(*domnode)
	webkit_dom_node_get_previous_sibling.i(*domnode)
	webkit_dom_node_get_text_content.i(*domnode)
	webkit_dom_node_has_attributes.l(*domnode)
	webkit_dom_node_has_child_nodes.l(*domnode)
	webkit_dom_node_insert_before.i(*domnode, *new_child, *ref_child)
	webkit_dom_node_is_default_namespace.l(*domnode, namespace_uri.p-utf8)
	webkit_dom_node_is_equal_node.l(*domnode, *other)
	webkit_dom_node_is_same_node.l(*domnode, *other)
	webkit_dom_node_is_supported.l(*domnode, feature.p-utf8, version.p-utf8)
	webkit_dom_node_lookup_namespace_uri.i(*domnode, prefix.p-utf8)
	webkit_dom_node_lookup_prefix.i(*domnode, namespace_uri.p-utf8)
	webkit_dom_node_normalize(*domnode)
	webkit_dom_node_remove_child.i(*domnode, *old_child)
	webkit_dom_node_replace_child.i(*domnode, *new_child, *old_child)
	webkit_dom_node_set_node_value(*domnode, value.p-utf8)
	webkit_dom_node_set_prefix(*domnode, value.p-utf8)
	webkit_dom_node_set_text_content(*domnode, value.p-utf8)
	webkit_dom_node_filter_accept_node.w(*domnodefilter, *n)
	webkit_dom_node_iterator_detach(*domnodeiterator)
	webkit_dom_node_iterator_get_expand_entity_references.l(*domnodeiterator)
	webkit_dom_node_iterator_get_filter.i(*domnodeiterator)
	webkit_dom_node_iterator_get_pointer_before_reference_node.l(*domnodeiterator)
	webkit_dom_node_iterator_get_reference_node.i(*domnodeiterator)
	webkit_dom_node_iterator_get_root.i(*domnodeiterator)
	webkit_dom_node_iterator_get_what_to_show.i(*domnodeiterator)
	webkit_dom_node_iterator_next_node.i(*domnodeiterator)
	webkit_dom_node_iterator_previous_node.i(*domnodeiterator)
	webkit_dom_node_list_get_length.i(*domnodelist)
	webkit_dom_node_list_item.i(*domnodelist, index.i)
	webkit_dom_processing_instruction_get_data.i(*domprocessinginstruction)
	webkit_dom_processing_instruction_get_sheet.i(*domprocessinginstruction)
	webkit_dom_processing_instruction_get_target.i(*domprocessinginstruction)
	webkit_dom_processing_instruction_set_data(*domprocessinginstruction, value.p-utf8)
	webkit_dom_range_clone_contents.i(*domrange)
	webkit_dom_range_clone_range.i(*domrange)
	webkit_dom_range_collapse(*domrange, to_start.l)
	webkit_dom_range_compare_boundary_points.w(*domrange, how.u, *source_range)
	webkit_dom_range_compare_node.w(*domrange, *ref_node)
	webkit_dom_range_compare_point.w(*domrange, *ref_node, offset.i)
	webkit_dom_range_create_contextual_fragment.i(*domrange, html.p-utf8)
	webkit_dom_range_delete_contents(*domrange)
	webkit_dom_range_detach(*domrange)
	webkit_dom_range_expand(*domrange, unit.p-utf8)
	webkit_dom_range_extract_contents.i(*domrange)
	webkit_dom_range_get_collapsed.l(*domrange)
	webkit_dom_range_get_common_ancestor_container.i(*domrange)
	webkit_dom_range_get_end_container.i(*domrange)
	webkit_dom_range_get_end_offset.i(*domrange)
	webkit_dom_range_get_start_container.i(*domrange)
	webkit_dom_range_get_start_offset.i(*domrange)
	webkit_dom_range_get_text.i(*domrange)
	webkit_dom_range_insert_node(*domrange, *new_node)
	webkit_dom_range_intersects_node.l(*domrange, *ref_node)
	webkit_dom_range_is_point_in_range.l(*domrange, *ref_node, offset.i)
	webkit_dom_range_select_node(*domrange, *ref_node)
	webkit_dom_range_select_node_contents(*domrange, *ref_node)
	webkit_dom_range_set_end(*domrange, *ref_node, offset.i)
	webkit_dom_range_set_end_after(*domrange, *ref_node)
	webkit_dom_range_set_end_before(*domrange, *ref_node)
	webkit_dom_range_set_start(*domrange, *ref_node, offset.i)
	webkit_dom_range_set_start_after(*domrange, *ref_node)
	webkit_dom_range_set_start_before(*domrange, *ref_node)
	webkit_dom_range_surround_contents(*domrange, *new_parent)
	webkit_dom_range_to_string.i(*domrange)
	webkit_dom_screen_get_avail_height.i(*domscreen)
	webkit_dom_screen_get_avail_left.i(*domscreen)
	webkit_dom_screen_get_avail_top.i(*domscreen)
	webkit_dom_screen_get_avail_width.i(*domscreen)
	webkit_dom_screen_get_color_depth.i(*domscreen)
	webkit_dom_screen_get_height.i(*domscreen)
	webkit_dom_screen_get_pixel_depth.i(*domscreen)
	webkit_dom_screen_get_width.i(*domscreen)
	webkit_dom_storage_clear(*domstorage)
	webkit_dom_storage_get_item.i(*domstorage, key.p-utf8)
	webkit_dom_storage_get_length.i(*domstorage)
	webkit_dom_storage_key.i(*domstorage, index.i)
	webkit_dom_storage_remove_item(*domstorage, key.p-utf8)
	webkit_dom_storage_set_item(*domstorage, key.p-utf8, data_.p-utf8)
	webkit_dom_style_media_match_medium.l(*domstylemedia, mediaquery.p-utf8)
	webkit_dom_style_sheet_get_disabled.l(*domstylesheet)
	webkit_dom_style_sheet_get_href.i(*domstylesheet)
	webkit_dom_style_sheet_get_media.i(*domstylesheet)
	webkit_dom_style_sheet_get_owner_node.i(*domstylesheet)
	webkit_dom_style_sheet_get_parent_style_sheet.i(*domstylesheet)
	webkit_dom_style_sheet_get_title.i(*domstylesheet)
	webkit_dom_style_sheet_set_disabled(*domstylesheet, value.l)
	webkit_dom_style_sheet_list_get_length.i(*domstylesheetlist)
	webkit_dom_style_sheet_list_item.i(*domstylesheetlist, index.i)
	webkit_dom_text_get_whole_text.i(*domtext)
	webkit_dom_text_replace_whole_text.i(*domtext, content.p-utf8)
	webkit_dom_text_split_text.i(*domtext, offset.i)
	webkit_dom_time_ranges_end.f(*domtimeranges, index.i)
	webkit_dom_time_ranges_get_length.i(*domtimeranges)
	webkit_dom_time_ranges_start.f(*domtimeranges, index.i)
	webkit_dom_tree_walker_first_child.i(*domtreewalker)
	webkit_dom_tree_walker_get_current_node.i(*domtreewalker)
	webkit_dom_tree_walker_get_expand_entity_references.l(*domtreewalker)
	webkit_dom_tree_walker_get_filter.i(*domtreewalker)
	webkit_dom_tree_walker_get_root.i(*domtreewalker)
	webkit_dom_tree_walker_get_what_to_show.i(*domtreewalker)
	webkit_dom_tree_walker_last_child.i(*domtreewalker)
	webkit_dom_tree_walker_next_node.i(*domtreewalker)
	webkit_dom_tree_walker_next_sibling.i(*domtreewalker)
	webkit_dom_tree_walker_parent_node.i(*domtreewalker)
	webkit_dom_tree_walker_previous_node.i(*domtreewalker)
	webkit_dom_tree_walker_previous_sibling.i(*domtreewalker)
	webkit_dom_tree_walker_set_current_node(*domtreewalker, *value)
	webkit_dom_ui_event_get_char_code.i(*domuievent)
	webkit_dom_ui_event_get_detail.i(*domuievent)
	webkit_dom_ui_event_get_key_code.i(*domuievent)
	webkit_dom_ui_event_get_layer_x.i(*domuievent)
	webkit_dom_ui_event_get_layer_y.i(*domuievent)
	webkit_dom_ui_event_get_page_x.i(*domuievent)
	webkit_dom_ui_event_get_page_y.i(*domuievent)
	webkit_dom_ui_event_get_view.i(*domuievent)
	webkit_dom_ui_event_get_which.i(*domuievent)
	webkit_dom_ui_event_init_ui_event(*domuievent, type.p-utf8, can_bubble.l, cancelable.l, *view, detail.i)
	webkit_dom_validity_state_get_custom_error.l(*domvaliditystate)
	webkit_dom_validity_state_get_pattern_mismatch.l(*domvaliditystate)
	webkit_dom_validity_state_get_range_overflow.l(*domvaliditystate)
	webkit_dom_validity_state_get_range_underflow.l(*domvaliditystate)
	webkit_dom_validity_state_get_step_mismatch.l(*domvaliditystate)
	webkit_dom_validity_state_get_too_long.l(*domvaliditystate)
	webkit_dom_validity_state_get_type_mismatch.l(*domvaliditystate)
	webkit_dom_validity_state_get_valid.l(*domvaliditystate)
	webkit_dom_validity_state_get_value_missing.l(*domvaliditystate)
	webkit_dom_webkit_animation_get_delay.d(*domwebkitanimation)
	webkit_dom_webkit_animation_get_direction.u(*domwebkitanimation)
	webkit_dom_webkit_animation_get_duration.d(*domwebkitanimation)
	webkit_dom_webkit_animation_get_elapsed_time.d(*domwebkitanimation)
	webkit_dom_webkit_animation_get_ended.l(*domwebkitanimation)
	webkit_dom_webkit_animation_get_fill_mode.u(*domwebkitanimation)
	webkit_dom_webkit_animation_get_name.i(*domwebkitanimation)
	webkit_dom_webkit_animation_get_paused.l(*domwebkitanimation)
	webkit_dom_webkit_animation_pause(*domwebkitanimation)
	webkit_dom_webkit_animation_play(*domwebkitanimation)
	webkit_dom_webkit_animation_set_elapsed_time(*domwebkitanimation, value.d)
	webkit_dom_webkit_animation_list_get_length.i(*domwebkitanimationlist)
	webkit_dom_webkit_animation_list_item.i(*domwebkitanimationlist, index.i)
	webkit_dom_webkit_point_get_x.f(*domwebkitpoint)
	webkit_dom_webkit_point_get_y.f(*domwebkitpoint)
	webkit_dom_webkit_point_set_x(*domwebkitpoint, value.f)
	webkit_dom_webkit_point_set_y(*domwebkitpoint, value.f)
	webkit_dom_xpath_expression_evaluate.i(*domxpathexpression, *context_node, type.u, *in_result)
	webkit_dom_xpath_ns_resolver_lookup_namespace_uri.i(*domxpathnsresolver, prefix.p-utf8)
	webkit_dom_xpath_result_get_boolean_value.l(*domxpathresult)
	webkit_dom_xpath_result_get_invalid_iterator_state.l(*domxpathresult)
	webkit_dom_xpath_result_get_number_value.d(*domxpathresult)
	webkit_dom_xpath_result_get_result_type.u(*domxpathresult)
	webkit_dom_xpath_result_get_single_node_value.i(*domxpathresult)
	webkit_dom_xpath_result_get_snapshot_length.i(*domxpathresult)
	webkit_dom_xpath_result_get_string_value.i(*domxpathresult)
	webkit_dom_xpath_result_iterate_next.i(*domxpathresult)
	webkit_dom_xpath_result_snapshot_item.i(*domxpathresult, index.i)
	webkit_download_new.i(*request)
	webkit_download_cancel(*download)
	webkit_download_get_current_size.q(*download)
	webkit_download_get_destination_uri.i(*download)
	webkit_download_get_elapsed_time.d(*download)
	webkit_download_get_network_request.i(*download)
	webkit_download_get_network_response.i(*download)
	webkit_download_get_progress.d(*download)
	webkit_download_get_status.l(*download)
	webkit_download_get_suggested_filename.i(*download)
	webkit_download_get_total_size.q(*download)
	webkit_download_get_uri.i(*download)
	webkit_download_set_destination_uri(*download, destination_uri.p-utf8)
	webkit_download_start(*download)
	webkit_icon_database_clear(*icondatabase)
	webkit_icon_database_get_icon_pixbuf.i(*icondatabase, page_uri.p-utf8)
	webkit_icon_database_get_icon_uri.i(*icondatabase, page_uri.p-utf8)
	webkit_icon_database_get_path.i(*icondatabase)
	webkit_icon_database_set_path(*icondatabase, path.p-utf8)
	webkit_network_request_new.i(uri.p-utf8)
	webkit_network_request_get_message.i(*networkrequest)
	webkit_network_request_get_uri.i(*networkrequest)
	webkit_network_request_set_uri(*networkrequest, uri.p-utf8)
	webkit_network_response_new.i(uri.p-utf8)
	webkit_network_response_get_message.i(*networkresponse)
	webkit_network_response_get_uri.i(*networkresponse)
	webkit_network_response_set_uri(*networkresponse, uri.p-utf8)
	webkit_security_origin_get_all_web_databases.i(*securityorigin)
	webkit_security_origin_get_host.i(*securityorigin)
	webkit_security_origin_get_port.l(*securityorigin)
	webkit_security_origin_get_protocol.i(*securityorigin)
	webkit_security_origin_get_web_database_quota.q(*securityorigin)
	webkit_security_origin_get_web_database_usage.q(*securityorigin)
	webkit_security_origin_set_web_database_quota(*securityorigin, quota.q)
	webkit_viewport_attributes_recompute(*viewportattributes)
	webkit_web_back_forward_list_new_with_web_view.i(*web_view)
	webkit_web_back_forward_list_add_item(*webbackforwardlist, *history_item)
	webkit_web_back_forward_list_clear(*webbackforwardlist)
	webkit_web_back_forward_list_contains_item.l(*webbackforwardlist, *history_item)
	webkit_web_back_forward_list_get_back_item.i(*webbackforwardlist)
	webkit_web_back_forward_list_get_back_length.l(*webbackforwardlist)
	webkit_web_back_forward_list_get_back_list_with_limit.i(*webbackforwardlist, limit.l)
	webkit_web_back_forward_list_get_current_item.i(*webbackforwardlist)
	webkit_web_back_forward_list_get_forward_item.i(*webbackforwardlist)
	webkit_web_back_forward_list_get_forward_length.l(*webbackforwardlist)
	webkit_web_back_forward_list_get_forward_list_with_limit.i(*webbackforwardlist, limit.l)
	webkit_web_back_forward_list_get_limit.l(*webbackforwardlist)
	webkit_web_back_forward_list_get_nth_item.i(*webbackforwardlist, index.l)
	webkit_web_back_forward_list_go_back(*webbackforwardlist)
	webkit_web_back_forward_list_go_forward(*webbackforwardlist)
	webkit_web_back_forward_list_go_to_item(*webbackforwardlist, *history_item)
	webkit_web_back_forward_list_set_limit(*webbackforwardlist, limit.l)
	webkit_web_data_source_new.i()
	webkit_web_data_source_new_with_request.i(*request)
	webkit_web_data_source_get_data.i(*webdatasource)
	webkit_web_data_source_get_encoding.i(*webdatasource)
	webkit_web_data_source_get_initial_request.i(*webdatasource)
	webkit_web_data_source_get_main_resource.i(*webdatasource)
	webkit_web_data_source_get_request.i(*webdatasource)
	webkit_web_data_source_get_subresources.i(*webdatasource)
	webkit_web_data_source_get_unreachable_uri.i(*webdatasource)
	webkit_web_data_source_get_web_frame.i(*webdatasource)
	webkit_web_data_source_is_loading.l(*webdatasource)
	webkit_web_database_get_display_name.i(*webdatabase)
	webkit_web_database_get_expected_size.q(*webdatabase)
	webkit_web_database_get_filename.i(*webdatabase)
	webkit_web_database_get_name.i(*webdatabase)
	webkit_web_database_get_security_origin.i(*webdatabase)
	webkit_web_database_get_size.q(*webdatabase)
	webkit_web_database_remove(*webdatabase)
	webkit_web_frame_new.i(*web_view)
	webkit_web_frame_find_frame.i(*webframe, name.p-utf8)
	webkit_web_frame_get_data_source.i(*webframe)
	webkit_web_frame_get_global_context.i(*webframe)
	webkit_web_frame_get_horizontal_scrollbar_policy.i(*webframe)
	webkit_web_frame_get_load_status.l(*webframe)
	webkit_web_frame_get_name.i(*webframe)
	webkit_web_frame_get_network_response.i(*webframe)
	webkit_web_frame_get_parent.i(*webframe)
	webkit_web_frame_get_provisional_data_source.i(*webframe)
	webkit_web_frame_get_security_origin.i(*webframe)
	webkit_web_frame_get_title.i(*webframe)
	webkit_web_frame_get_uri.i(*webframe)
	webkit_web_frame_get_vertical_scrollbar_policy.i(*webframe)
	webkit_web_frame_get_web_view.i(*webframe)
	webkit_web_frame_load_alternate_string(*webframe, content.p-utf8, base_url.p-utf8, unreachable_url.p-utf8)
	webkit_web_frame_load_request(*webframe, *request)
	webkit_web_frame_load_string(*webframe, content.p-utf8, mime_type.p-utf8, encoding.p-utf8, base_uri.p-utf8)
	webkit_web_frame_load_uri(*webframe, uri.p-utf8)
	webkit_web_frame_print(*webframe)
	webkit_web_frame_print_full.i(*webframe, *operation, *action)
	webkit_web_frame_reload(*webframe)
	webkit_web_frame_stop_loading(*webframe)
	webkit_web_history_item_new.i()
	webkit_web_history_item_new_with_data.i(uri.p-utf8, title.p-utf8)
	webkit_web_history_item_copy.i(*webhistoryitem)
	webkit_web_history_item_get_alternate_title.i(*webhistoryitem)
	webkit_web_history_item_get_last_visited_time.d(*webhistoryitem)
	webkit_web_history_item_get_original_uri.i(*webhistoryitem)
	webkit_web_history_item_get_title.i(*webhistoryitem)
	webkit_web_history_item_get_uri.i(*webhistoryitem)
	webkit_web_history_item_set_alternate_title(*webhistoryitem, title.p-utf8)
	webkit_web_inspector_close(*webinspector)
	webkit_web_inspector_get_inspected_uri.i(*webinspector)
	webkit_web_inspector_get_web_view.i(*webinspector)
	webkit_web_inspector_inspect_coordinates(*webinspector, x.d, y.d)
	webkit_web_inspector_inspect_node(*webinspector, *node)
	webkit_web_inspector_show(*webinspector)
	webkit_web_navigation_action_get_button.l(*webnavigationaction)
	webkit_web_navigation_action_get_modifier_state.l(*webnavigationaction)
	webkit_web_navigation_action_get_original_uri.i(*webnavigationaction)
	webkit_web_navigation_action_get_reason.l(*webnavigationaction)
	webkit_web_navigation_action_get_target_frame.i(*webnavigationaction)
	webkit_web_navigation_action_set_original_uri(*webnavigationaction, originalUri.p-utf8)
	webkit_web_navigation_action_set_reason(*webnavigationaction, reason.l)
	webkit_web_plugin_get_description.i(*webplugin)
	webkit_web_plugin_get_enabled.l(*webplugin)
	webkit_web_plugin_get_mimetypes.i(*webplugin)
	webkit_web_plugin_get_name.i(*webplugin)
	webkit_web_plugin_get_path.i(*webplugin)
	webkit_web_plugin_set_enabled(*webplugin)
	webkit_web_plugin_database_get_plugin_for_mimetype.i(*webplugindatabase)
	webkit_web_plugin_database_get_plugins.i(*webplugindatabase)
	webkit_web_plugin_database_refresh(*webplugindatabase)
	webkit_web_policy_decision_download(*webpolicydecision)
	webkit_web_policy_decision_ignore(*webpolicydecision)
	webkit_web_policy_decision_use(*webpolicydecision)
	webkit_web_resource_new.i(data_.p-utf8, size.i, uri.p-utf8, mime_type.p-utf8, encoding.p-utf8, frame_name.p-utf8)
	webkit_web_resource_get_data.i(*webresource)
	webkit_web_resource_get_encoding.i(*webresource)
	webkit_web_resource_get_frame_name.i(*webresource)
	webkit_web_resource_get_mime_type.i(*webresource)
	webkit_web_resource_get_uri.i(*webresource)
	webkit_web_settings_new.i()
	webkit_web_settings_copy.i(*websettings)
	webkit_web_settings_get_user_agent.i(*websettings)
	webkit_web_view_new.i()
	webkit_web_view_can_copy_clipboard.l(*webview)
	webkit_web_view_can_cut_clipboard.l(*webview)
	webkit_web_view_can_go_back.l(*webview)
	webkit_web_view_can_go_back_or_forward.l(*webview, steps.l)
	webkit_web_view_can_go_forward.l(*webview)
	webkit_web_view_can_paste_clipboard.l(*webview)
	webkit_web_view_can_redo.l(*webview)
	webkit_web_view_can_show_mime_type.l(*webview, mime_type.p-utf8)
	webkit_web_view_can_undo.l(*webview)
	webkit_web_view_copy_clipboard(*webview)
	webkit_web_view_cut_clipboard(*webview)
	webkit_web_view_delete_selection(*webview)
	webkit_web_view_execute_script(*webview, script.p-utf8)
	webkit_web_view_get_back_forward_list.i(*webview)
	webkit_web_view_get_copy_target_list.i(*webview)
	webkit_web_view_get_custom_encoding.i(*webview)
	webkit_web_view_get_dom_document.i(*webview)
	webkit_web_view_get_editable.l(*webview)
	webkit_web_view_get_encoding.i(*webview)
	webkit_web_view_get_focused_frame.i(*webview)
	webkit_web_view_get_full_content_zoom.l(*webview)
	webkit_web_view_get_hit_test_result.i(*webview, *event)
	webkit_web_view_get_icon_pixbuf.i(*webview)
	webkit_web_view_get_icon_uri.i(*webview)
	webkit_web_view_get_inspector.i(*webview)
	webkit_web_view_get_load_status.l(*webview)
	webkit_web_view_get_main_frame.i(*webview)
	webkit_web_view_get_paste_target_list.i(*webview)
	webkit_web_view_get_progress.d(*webview)
	webkit_web_view_get_settings.i(*webview)
	webkit_web_view_get_title.i(*webview)
	webkit_web_view_get_transparent.l(*webview)
	webkit_web_view_get_uri.i(*webview)
	webkit_web_view_get_view_mode.l(*webview)
	webkit_web_view_get_view_source_mode.l(*webview)
	webkit_web_view_get_viewport_attributes.i(*webview)
	webkit_web_view_get_window_features.i(*webview)
	webkit_web_view_get_zoom_level.f(*webview)
	webkit_web_view_go_back(*webview)
	webkit_web_view_go_back_or_forward(*webview, steps.l)
	webkit_web_view_go_forward(*webview)
	webkit_web_view_go_to_back_forward_item.l(*webview, *item)
	webkit_web_view_has_selection.l(*webview)
	webkit_web_view_load_html_string(*webview, content.p-utf8, base_uri.p-utf8)
	webkit_web_view_load_request(*webview, *request)
	webkit_web_view_load_string(*webview, content.p-utf8, mime_type.p-utf8, encoding.p-utf8, base_uri.p-utf8)
	webkit_web_view_load_uri(*webview, uri.p-utf8)
	webkit_web_view_mark_text_matches.l(*webview, string.p-utf8, case_sensitive.l, limit.l)
	webkit_web_view_move_cursor(*webview, *step_, count.l)
	webkit_web_view_open(*webview, uri.p-utf8)
	webkit_web_view_paste_clipboard(*webview)
	webkit_web_view_redo(*webview)
	webkit_web_view_reload(*webview)
	webkit_web_view_reload_bypass_cache(*webview)
	webkit_web_view_search_text.l(*webview, text.p-utf8, case_sensitive.l, forward.l, wrap.l)
	webkit_web_view_select_all(*webview)
	webkit_web_view_set_custom_encoding(*webview, encoding.p-utf8)
	webkit_web_view_set_editable(*webview, flag.l)
	webkit_web_view_set_full_content_zoom(*webview, full_content_zoom.l)
	webkit_web_view_set_highlight_text_matches(*webview, highlight.l)
	webkit_web_view_set_maintains_back_forward_list(*webview, flag.l)
	webkit_web_view_set_settings(*webview, *settings)
	webkit_web_view_set_transparent(*webview, flag.l)
	webkit_web_view_set_view_mode(*webview, mode.l)
	webkit_web_view_set_view_source_mode(*webview, view_source_mode.l)
	webkit_web_view_set_zoom_level(*webview, zoom_level.f)
	webkit_web_view_stop_loading(*webview)
	webkit_web_view_undo(*webview)
	webkit_web_view_unmark_text_matches(*webview)
	webkit_web_view_zoom_in(*webview)
	webkit_web_view_zoom_out(*webview)
	webkit_web_window_features_new.i()
	webkit_web_window_features_equal.l(*webwindowfeatures, *features2)
	webkit_dom_event_target_add_event_listener.l(*domeventtarget, eventName.p-utf8, *handler, bubble.l, *userData)
	webkit_dom_event_target_dispatch_event(*domeventtarget, *event)
	webkit_dom_event_target_remove_event_listener.l(*domeventtarget, eventName.p-utf8, *handler, bubble.l)
	webkit_web_plugin_database_plugins_list_free()
	webkit_application_cache_get_database_directory_path.i()
	webkit_application_cache_get_maximum_size.i()
	webkit_application_cache_set_maximum_size(*size)
	webkit_check_version.l(major.l, minor.l, micro.l)
	webkit_geolocation_policy_allow(*decision)
	webkit_geolocation_policy_deny(*decision)
	webkit_get_cache_model.l()
	webkit_get_default_session.i()
	webkit_get_default_web_database_quota.q()
	webkit_get_icon_database.i()
	webkit_get_web_database_directory_path.i()
	webkit_get_web_plugin_database.i()
	webkit_major_version.l()
	webkit_micro_version.l()
	webkit_minor_version.l()
	webkit_network_error_quark.i()
	webkit_plugin_error_quark.i()
	webkit_policy_error_quark.i()
	webkit_remove_all_web_databases()
	webkit_set_cache_model(cache_model.l)
	webkit_set_default_web_database_quota(defaultQuota.q)
	webkit_set_web_database_directory_path(path.p-utf8)
EndImport


